/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth;

import org.apereo.cas.support.oauth.OAuthCasClientRedirectActionBuilder;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthCasClientRedirectActionBuilder
implements OAuthCasClientRedirectActionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuthCasClientRedirectActionBuilder.class);

    @Override
    public RedirectAction build(CasClient casClient, WebContext context) {
        try {
            CasConfiguration casConfiguration = casClient.getConfiguration();
            String redirectionUrl = CommonUtils.constructRedirectUrl((String)casConfiguration.getLoginUrl(), (String)"service", (String)casClient.computeFinalCallbackUrl(context), (boolean)casConfiguration.isRenew(), (boolean)casConfiguration.isGateway());
            LOGGER.debug("Final redirect url is {}", (Object)redirectionUrl);
            return RedirectAction.redirect((String)redirectionUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

