/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.DefaultOAuthCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.OAuthCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuthClientAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuthUserAuthenticator;
import org.apereo.cas.support.oauth.services.OAuthCallbackAuthorizeService;
import org.apereo.cas.support.oauth.validator.OAuth20ValidationServiceSelectionStrategy;
import org.apereo.cas.support.oauth.validator.OAuthValidator;
import org.apereo.cas.support.oauth.web.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.OAuth20AccessTokenController;
import org.apereo.cas.support.oauth.web.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.OAuth20AuthorizeController;
import org.apereo.cas.support.oauth.web.OAuth20CallbackAuthorizeController;
import org.apereo.cas.support.oauth.web.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.OAuth20ProfileController;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuthAccessTokenExpirationPolicy;
import org.apereo.cas.ticket.code.DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.validation.ValidationServiceSelectionStrategy;
import org.jasig.cas.client.util.URIBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.springframework.web.CallbackController;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="oauthConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthConfiguration
extends WebMvcConfigurerAdapter {
    private static final String CAS_OAUTH_CLIENT = "CasOAuthClient";
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="validationServiceSelectionStrategies")
    private List validationServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;

    @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
    @Bean(autowire=Autowire.BY_NAME)
    public AccessTokenResponseGenerator accessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
    @Bean(autowire=Autowire.BY_NAME)
    public OAuthCasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new DefaultOAuthCasClientRedirectActionBuilder();
    }

    @Bean
    public Config oauthSecConfig() {
        CasClient oauthCasClient = new CasClient(this.casProperties.getServer().getLoginUrl()){

            protected RedirectAction retrieveRedirectAction(WebContext context) {
                return CasOAuthConfiguration.this.oauthCasClientRedirectActionBuilder().build(this, context);
            }
        };
        oauthCasClient.setName(CAS_OAUTH_CLIENT);
        oauthCasClient.setCallbackUrlResolver(this.buildOAuthCasCallbackUrlResolver());
        Authenticator<UsernamePasswordCredentials> authenticator = this.oAuthClientAuthenticator();
        DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(authenticator);
        basicAuthClient.setName("clientBasicAuth");
        DirectFormClient directFormClient = new DirectFormClient(authenticator);
        directFormClient.setName("clientForm");
        directFormClient.setUsernameParameter("client_id");
        directFormClient.setPasswordParameter("client_secret");
        DirectFormClient userFormClient = new DirectFormClient(this.oAuthUserAuthenticator());
        userFormClient.setName("userForm");
        String callbackUrl = this.casProperties.getServer().getPrefix().concat("/oauth2.0/callbackAuthorize");
        return new Config(callbackUrl, new Client[]{oauthCasClient, basicAuthClient, directFormClient, userFormClient});
    }

    private CallbackUrlResolver buildOAuthCasCallbackUrlResolver() {
        return (url, context) -> {
            String callbackUrl = this.casProperties.getServer().getPrefix().concat("/oauth2.0/callbackAuthorize");
            if (url.startsWith(callbackUrl)) {
                URIBuilder builder = new URIBuilder(url);
                URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
                Optional<URIBuilder.BasicNameValuePair> parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("client_id")).findFirst();
                if (parameter.isPresent()) {
                    builder.addParameter(parameter.get().getName(), parameter.get().getValue());
                }
                if ((parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("redirect_uri")).findFirst()).isPresent()) {
                    builder.addParameter(parameter.get().getName(), parameter.get().getValue());
                }
                if ((parameter = builderContext.getQueryParams().stream().filter(p -> p.getName().equals("acr_values")).findFirst()).isPresent()) {
                    builder.addParameter(parameter.get().getName(), parameter.get().getValue());
                }
                return builder.build().toString();
            }
            return url;
        };
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        return new SecurityInterceptor(this.oauthSecConfig(), CAS_OAUTH_CLIENT);
    }

    @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OAuth20ConsentApprovalViewResolver();
    }

    @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){};
    }

    @Bean
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        return new SecurityInterceptor(this.oauthSecConfig(), "clientBasicAuth,clientForm,userForm");
    }

    @Bean
    public HandlerInterceptorAdapter oauthInterceptor() {
        return new HandlerInterceptorAdapter(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                String requestPath = request.getRequestURI();
                Pattern pattern = Pattern.compile("/accessToken(/)*$");
                if (pattern.matcher(requestPath).find()) {
                    return CasOAuthConfiguration.this.requiresAuthenticationAccessTokenInterceptor().preHandle(request, response, handler);
                }
                pattern = Pattern.compile("/authorize(/)*$");
                if (pattern.matcher(requestPath).find()) {
                    return CasOAuthConfiguration.this.requiresAuthenticationAuthorizeInterceptor().preHandle(request, response, handler);
                }
                return true;
            }
        };
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{"/oauth2.0".concat("/").concat("*")});
    }

    @Bean
    public OAuthCasClientRedirectActionBuilder defaultOAuthCasClientRedirectActionBuilder() {
        return new DefaultOAuthCasClientRedirectActionBuilder();
    }

    @Bean
    public Authenticator<UsernamePasswordCredentials> oAuthClientAuthenticator() {
        OAuthClientAuthenticator c = new OAuthClientAuthenticator();
        c.setValidator(this.oAuthValidator());
        c.setServicesManager(this.servicesManager);
        return c;
    }

    @Bean
    public Authenticator<UsernamePasswordCredentials> oAuthUserAuthenticator() {
        OAuthUserAuthenticator w = new OAuthUserAuthenticator();
        w.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        return w;
    }

    @Bean
    public OAuthValidator oAuthValidator() {
        return new OAuthValidator();
    }

    @Bean
    public AccessTokenResponseGenerator oauthAccessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
    public AccessTokenFactory defaultAccessTokenFactory() {
        DefaultAccessTokenFactory f = new DefaultAccessTokenFactory();
        f.setAccessTokenIdGenerator(this.accessTokenIdGenerator());
        f.setExpirationPolicy(this.accessTokenExpirationPolicy());
        return f;
    }

    private ExpirationPolicy accessTokenExpirationPolicy() {
        return new OAuthAccessTokenExpirationPolicy(this.casProperties.getAuthn().getOauth().getAccessToken().getMaxTimeToLiveInSeconds(), this.casProperties.getAuthn().getOauth().getAccessToken().getTimeToKillInSeconds());
    }

    private ExpirationPolicy oAuthCodeExpirationPolicy() {
        return new OAuthCodeExpirationPolicy(this.casProperties.getAuthn().getOauth().getCode().getNumberOfUses(), this.casProperties.getAuthn().getOauth().getCode().getTimeToKillInSeconds());
    }

    @Bean
    public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    public UniqueTicketIdGenerator refreshTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
    public OAuthCodeFactory defaultOAuthCodeFactory() {
        DefaultOAuthCodeFactory f = new DefaultOAuthCodeFactory();
        f.setExpirationPolicy(this.oAuthCodeExpirationPolicy());
        f.setoAuthCodeIdGenerator(this.oAuthCodeIdGenerator());
        return f;
    }

    @Bean
    @ConditionalOnMissingBean(name={"callbackAuthorizeController"})
    public OAuth20CallbackAuthorizeController callbackAuthorizeController() {
        OAuth20CallbackAuthorizeController c = new OAuth20CallbackAuthorizeController();
        c.setCallbackController(this.callbackController());
        c.setConfig(this.oauthSecConfig());
        c.setAuth20CallbackAuthorizeViewResolver(this.callbackAuthorizeViewResolver());
        return c;
    }

    @ConditionalOnMissingBean(name={"accessTokenController"})
    @Bean
    public OAuth20AccessTokenController accessTokenController() {
        OAuth20AccessTokenController c = new OAuth20AccessTokenController();
        c.setAccessTokenFactory(this.defaultAccessTokenFactory());
        c.setAccessTokenResponseGenerator(this.accessTokenResponseGenerator());
        c.setPrincipalFactory(this.oauthPrincipalFactory());
        c.setRefreshTokenFactory(this.defaultRefreshTokenFactory());
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator());
        return c;
    }

    @ConditionalOnMissingBean(name={"profileController"})
    @Bean
    public OAuth20ProfileController profileController() {
        OAuth20ProfileController c = new OAuth20ProfileController();
        c.setAccessTokenFactory(this.defaultAccessTokenFactory());
        c.setPrincipalFactory(this.oauthPrincipalFactory());
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator());
        return c;
    }

    @ConditionalOnMissingBean(name={"authorizeController"})
    @Bean
    public OAuth20AuthorizeController authorizeController() {
        OAuth20AuthorizeController c = new OAuth20AuthorizeController();
        c.setAccessTokenFactory(this.defaultAccessTokenFactory());
        c.setPrincipalFactory(this.oauthPrincipalFactory());
        c.setServicesManager(this.servicesManager);
        c.setTicketRegistry(this.ticketRegistry);
        c.setValidator(this.oAuthValidator());
        c.setConsentApprovalViewResolver(this.consentApprovalViewResolver());
        c.setoAuthCodeFactory(this.defaultOAuthCodeFactory());
        return c;
    }

    @Bean
    public PrincipalFactory oauthPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
    public RefreshTokenFactory defaultRefreshTokenFactory() {
        DefaultRefreshTokenFactory f = new DefaultRefreshTokenFactory();
        f.setExpirationPolicy(this.refreshTokenExpirationPolicy());
        f.setRefreshTokenIdGenerator(this.refreshTokenIdGenerator());
        return f;
    }

    private ExpirationPolicy refreshTokenExpirationPolicy() {
        return new OAuthRefreshTokenExpirationPolicy(this.casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oauth20ValidationServiceSelectionStrategy"})
    public ValidationServiceSelectionStrategy oauth20ValidationServiceSelectionStrategy() {
        OAuth20ValidationServiceSelectionStrategy s = new OAuth20ValidationServiceSelectionStrategy();
        s.setServicesManager(this.servicesManager);
        s.setWebApplicationServiceFactory((ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory);
        return s;
    }

    @Bean
    public CallbackController callbackController() {
        CallbackController c = new CallbackController();
        c.setConfig(this.oauthSecConfig());
        return c;
    }

    @Bean
    public UniqueTicketIdGenerator accessTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @PostConstruct
    public void initializeServletApplicationContext() {
        String oAuthCallbackUrl = this.casProperties.getServer().getPrefix() + "/oauth2.0" + '/' + "callbackAuthorize.*";
        Service callbackService = this.webApplicationServiceFactory.createService(oAuthCallbackUrl);
        RegisteredService svc = this.servicesManager.findServiceBy(callbackService);
        if (svc == null || !svc.getServiceId().equals(oAuthCallbackUrl)) {
            OAuthCallbackAuthorizeService service = new OAuthCallbackAuthorizeService();
            service.setName("OAuth Callback url");
            service.setDescription("OAuth Wrapper Callback Url");
            service.setServiceId(oAuthCallbackUrl);
            service.setEvaluationOrder(Integer.MIN_VALUE);
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
            this.servicesManager.save((RegisteredService)service);
            this.servicesManager.load();
        }
        this.validationServiceSelectionStrategies.add(0, this.oauth20ValidationServiceSelectionStrategy());
    }
}

