/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.AccountStateHandler;
import org.apereo.cas.authentication.support.DefaultAccountStateHandler;
import org.apereo.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.apereo.cas.authentication.support.OptionalWarningAccountStateHandler;
import org.apereo.cas.authentication.support.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.auth.PooledCompareAuthenticationHandler;
import org.ldaptive.auth.PooledSearchDnResolver;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="ldapAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapAuthenticationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @PostConstruct
    public void initLdapAuthenticationHandlers() {
        this.casProperties.getAuthn().getLdap().stream().filter(l -> {
            if (l.getType() == null) {
                LOGGER.warn("Skipping ldap authentication entry since no type is defined");
                return false;
            }
            if (l.getBaseDn() == null) {
                LOGGER.warn("Skipping ldap authentication entry since no baseDn is defined");
                return false;
            }
            if (l.getLdapUrl() == null) {
                LOGGER.warn("Skipping ldap authentication entry since no ldap url is defined");
                return false;
            }
            return true;
        }).forEach(l -> {
            LOGGER.debug("Creating ldap authentication handler for {}", (Object)l.getLdapUrl());
            LdapAuthenticationHandler handler = new LdapAuthenticationHandler();
            handler.setServicesManager(this.servicesManager);
            ArrayList additionalAttrs = Lists.newArrayList((Iterable)l.getAdditionalAttributes());
            if (StringUtils.isNotBlank((CharSequence)l.getPrincipalAttributeId())) {
                additionalAttrs.add(l.getPrincipalAttributeId());
            }
            handler.setAdditionalAttributes(additionalAttrs);
            handler.setAllowMultiplePrincipalAttributeValues(l.isAllowMultiplePrincipalAttributeValues());
            handler.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)l.getPasswordEncoder()));
            handler.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)l.getPrincipalTransformation()));
            if (StringUtils.isNotBlank((CharSequence)l.getCredentialCriteria())) {
                LOGGER.debug("Ldap authentication for {} is filtering credentials by {}", (Object)l.getCredentialCriteria());
                handler.setCredentialSelectionPredicate(credential -> Predicates.containsPattern((String)l.getCredentialCriteria()).apply((Object)credential.getId()));
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (l.getPrincipalAttributeList().isEmpty()) {
                LOGGER.debug("No principal attributes are defined for {}", (Object)l.getLdapUrl());
            } else {
                l.getPrincipalAttributeList().forEach(a -> {
                    String attributeName = a.toString().trim();
                    if (attributeName.contains(":")) {
                        String[] attrCombo = attributeName.split(":");
                        String name = attrCombo[0].trim();
                        String value = attrCombo[1].trim();
                        LOGGER.debug("Mapped principal attribute name {} to {} for {}", new Object[]{name, value, l.getLdapUrl()});
                        attributes.put(name, value);
                    } else {
                        LOGGER.debug("Mapped principal attribute name {} for {}", (Object)attributeName, (Object)l.getLdapUrl());
                        attributes.put(attributeName, attributeName);
                    }
                });
            }
            attributes.putAll(this.casProperties.getAuthn().getAttributeRepository().getAttributes());
            handler.setPrincipalAttributeMap(attributes);
            LOGGER.debug("Ldap authentication for {} is configured with principal attributes {}...", (Object)l.getLdapUrl(), attributes);
            if (StringUtils.isBlank((CharSequence)l.getPrincipalAttributeId())) {
                LOGGER.debug("No principal id attribute is found for ldap authentication via {}", (Object)l.getLdapUrl());
            } else {
                handler.setPrincipalIdAttribute(l.getPrincipalAttributeId());
                LOGGER.debug("Using principal id attribute {} for ldap authentication via {}", (Object)l.getPrincipalAttributeId(), (Object)l.getLdapUrl());
            }
            LOGGER.debug("Creating ldap authenticator for {} and baseDn {}", (Object)l.getLdapUrl(), (Object)l.getBaseDn());
            Authenticator authenticator = LdapAuthenticationConfiguration.getAuthenticator(l);
            authenticator.setReturnAttributes(attributes.keySet().toArray(new String[0]));
            LOGGER.debug("Ldap authenticator configured with return attributes {} for {} and baseDn {}", new Object[]{attributes.keySet(), l.getLdapUrl(), l.getBaseDn()});
            if (l.getPasswordPolicy().isEnabled()) {
                LOGGER.debug("Password policy is enabled for {}. Constructing password policy configuration", (Object)l.getLdapUrl());
                handler.setPasswordPolicyConfiguration((PasswordPolicyConfiguration)LdapAuthenticationConfiguration.createLdapPasswordPolicyConfiguration(l, authenticator));
            }
            handler.setAuthenticator(authenticator);
            LOGGER.debug("Initializing ldap authentication handler...");
            handler.initialize();
            if (l.getAdditionalAttributes().isEmpty() && l.getPrincipalAttributeList().isEmpty()) {
                LOGGER.debug("Ldap authentication for {} is to delegate to principal resolvers for attributes", (Object)l.getLdapUrl());
                this.authenticationHandlersResolvers.put(handler, this.personDirectoryPrincipalResolver);
            } else {
                LOGGER.debug("Ldap authentication for {} and baseDn {} is retrieving attributes. Principal resolvers are inactive.", (Object)l.getLdapUrl(), (Object)l.getBaseDn());
                this.authenticationHandlersResolvers.put(handler, null);
            }
        });
    }

    private static LdapPasswordPolicyConfiguration createLdapPasswordPolicyConfiguration(LdapAuthenticationProperties l, Authenticator authenticator) {
        LdapPasswordPolicyConfiguration cfg = new LdapPasswordPolicyConfiguration(l.getPasswordPolicy());
        HashSet<Object> handlers = new HashSet<Object>();
        if (cfg.getPasswordWarningNumberOfDays() > 0) {
            handlers.add(new EDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
            handlers.add(new ActiveDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
            handlers.add(new FreeIPAAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays()), cfg.getLoginFailures()));
        }
        handlers.add(new PasswordPolicyAuthenticationResponseHandler());
        handlers.add(new PasswordExpirationAuthenticationResponseHandler());
        authenticator.setAuthenticationResponseHandlers(handlers.toArray(new AuthenticationResponseHandler[handlers.size()]));
        if (StringUtils.isNotBlank((CharSequence)l.getPasswordPolicy().getWarningAttributeName()) && StringUtils.isNotBlank((CharSequence)l.getPasswordPolicy().getWarningAttributeValue())) {
            OptionalWarningAccountStateHandler accountHandler = new OptionalWarningAccountStateHandler();
            accountHandler.setDisplayWarningOnMatch(l.getPasswordPolicy().isDisplayWarningOnMatch());
            accountHandler.setWarnAttributeName(l.getPasswordPolicy().getWarningAttributeName());
            accountHandler.setWarningAttributeValue(l.getPasswordPolicy().getWarningAttributeValue());
            accountHandler.setAttributesToErrorMap(l.getPasswordPolicy().getPolicyAttributes());
            cfg.setAccountStateHandler((AccountStateHandler)accountHandler);
        } else {
            DefaultAccountStateHandler accountHandler = new DefaultAccountStateHandler();
            accountHandler.setAttributesToErrorMap(l.getPasswordPolicy().getPolicyAttributes());
            cfg.setAccountStateHandler((AccountStateHandler)accountHandler);
        }
        return cfg;
    }

    private static Authenticator getAuthenticator(LdapAuthenticationProperties l) {
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AD) {
            LOGGER.debug("Creating active directory authenticator for {}", (Object)l.getLdapUrl());
            return LdapAuthenticationConfiguration.getActiveDirectoryAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.DIRECT) {
            LOGGER.debug("Creating direct-bind authenticator for {}", (Object)l.getLdapUrl());
            return LdapAuthenticationConfiguration.getDirectBindAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.SASL) {
            LOGGER.debug("Creating SASL authenticator for {}", (Object)l.getLdapUrl());
            return LdapAuthenticationConfiguration.getSaslAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AUTHENTICATED) {
            LOGGER.debug("Creating authenticated authenticator for {}", (Object)l.getLdapUrl());
            return LdapAuthenticationConfiguration.getAuthenticatedOrAnonSearchAuthenticator(l);
        }
        LOGGER.debug("Creating anonymous authenticator for {}", (Object)l.getLdapUrl());
        return LdapAuthenticationConfiguration.getAuthenticatedOrAnonSearchAuthenticator(l);
    }

    private static Authenticator getSaslAuthenticator(LdapAuthenticationProperties l) {
        PooledSearchDnResolver resolver = new PooledSearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory(Beans.newPooledConnectionFactory((AbstractLdapProperties)l));
        resolver.setUserFilter(l.getUserFilter());
        return new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdapAuthenticationConfiguration.getPooledBindAuthenticationHandler(l));
    }

    private static Authenticator getAuthenticatedOrAnonSearchAuthenticator(LdapAuthenticationProperties l) {
        PooledSearchDnResolver resolver = new PooledSearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory(Beans.newPooledConnectionFactory((AbstractLdapProperties)l));
        resolver.setUserFilter(l.getUserFilter());
        Authenticator auth = StringUtils.isBlank((CharSequence)l.getPrincipalAttributePassword()) ? new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdapAuthenticationConfiguration.getPooledBindAuthenticationHandler(l)) : new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdapAuthenticationConfiguration.getPooledCompareAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            auth.setEntryResolver(Beans.newSearchEntryResolver((LdapAuthenticationProperties)l));
        }
        return auth;
    }

    private static Authenticator getDirectBindAuthenticator(LdapAuthenticationProperties l) {
        if (StringUtils.isBlank((CharSequence)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for direct bind authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authenticator = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdapAuthenticationConfiguration.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authenticator.setEntryResolver(Beans.newSearchEntryResolver((LdapAuthenticationProperties)l));
        }
        return authenticator;
    }

    private static Authenticator getActiveDirectoryAuthenticator(LdapAuthenticationProperties l) {
        if (StringUtils.isBlank((CharSequence)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for active directory authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authn = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdapAuthenticationConfiguration.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authn.setEntryResolver(Beans.newSearchEntryResolver((LdapAuthenticationProperties)l));
        }
        return authn;
    }

    private static PooledBindAuthenticationHandler getPooledBindAuthenticationHandler(LdapAuthenticationProperties l) {
        PooledBindAuthenticationHandler handler = new PooledBindAuthenticationHandler(Beans.newPooledConnectionFactory((AbstractLdapProperties)l));
        handler.setAuthenticationControls(new RequestControl[]{new PasswordPolicyControl()});
        return handler;
    }

    private static PooledCompareAuthenticationHandler getPooledCompareAuthenticationHandler(LdapAuthenticationProperties l) {
        PooledCompareAuthenticationHandler handler = new PooledCompareAuthenticationHandler(Beans.newPooledConnectionFactory((AbstractLdapProperties)l));
        handler.setPasswordAttribute(l.getPrincipalAttributePassword());
        return handler;
    }
}

