/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.support;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true, transactionManager="ticketTransactionManager")
public class JpaLockingStrategy
implements LockingStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaLockingStrategy.class);
    @PersistenceContext(unitName="ticketEntityManagerFactory")
    protected EntityManager entityManager;
    private String applicationId;
    private String uniqueId;
    private int lockTimeout;

    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }

    public void setLockTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Lock timeout must be non-negative.");
        }
        this.lockTimeout = seconds;
    }

    public boolean acquire() {
        Lock lock;
        try {
            lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.OPTIMISTIC);
        }
        catch (Exception e) {
            LOGGER.debug("{} failed querying for {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            return false;
        }
        boolean result = false;
        if (lock != null) {
            ZonedDateTime expDate = lock.getExpirationDate();
            if (lock.getUniqueId() == null) {
                LOGGER.debug("{} trying to acquire {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(lock);
            } else if (expDate == null || ZonedDateTime.now(ZoneOffset.UTC).isAfter(expDate)) {
                LOGGER.debug("{} trying to acquire expired {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(lock);
            }
        } else {
            LOGGER.debug("Creating {} lock initially held by {}.", (Object)this.applicationId, (Object)this.uniqueId);
            result = this.acquire(new Lock());
        }
        return result;
    }

    public void release() {
        Lock lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.OPTIMISTIC);
        if (lock == null) {
            return;
        }
        String owner = lock.getUniqueId();
        if (!this.uniqueId.equals(owner)) {
            throw new IllegalStateException("Cannot release lock owned by " + owner);
        }
        lock.setUniqueId(null);
        lock.setExpirationDate(null);
        LOGGER.debug("Releasing {} lock held by {}.", (Object)this.applicationId, (Object)this.uniqueId);
        this.entityManager.persist((Object)lock);
    }

    public String toString() {
        return this.uniqueId;
    }

    public boolean acquire(Lock lock) {
        boolean success;
        lock.setUniqueId(this.uniqueId);
        if (this.lockTimeout > 0) {
            lock.setExpirationDate(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.lockTimeout));
        } else {
            lock.setExpirationDate(null);
        }
        try {
            if (lock.getApplicationId() != null) {
                this.entityManager.merge((Object)lock);
            } else {
                lock.setApplicationId(this.applicationId);
                this.entityManager.persist((Object)lock);
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} could not obtain {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            }
            LOGGER.info("{} could not obtain {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
        }
        return success;
    }

    @Entity
    @Table(name="locks")
    private static class Lock
    implements Serializable {
        @Id
        @Column(name="application_id")
        private String applicationId;
        @Column(name="unique_id")
        private String uniqueId;
        @Column(name="expiration_date")
        private ZonedDateTime expirationDate;
        @Version
        @Column(name="lockVer", columnDefinition="integer DEFAULT 0", nullable=false)
        private Long version = 0L;

        private Lock() {
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public ZonedDateTime getExpirationDate() {
            return this.expirationDate == null ? null : ZonedDateTime.from(this.expirationDate);
        }

        public void setExpirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
        }
    }
}

