/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketImpl;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.code.OAuthCodeImpl;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="ticketTransactionManager", readOnly=false)
public class JpaTicketRegistry
extends AbstractTicketRegistry {
    private static final String TABLE_OAUTH_TICKETS = OAuthCodeImpl.class.getSimpleName();
    private static final String TABLE_SERVICE_TICKETS = ServiceTicketImpl.class.getSimpleName();
    private static final String TABLE_TICKET_GRANTING_TICKETS = TicketGrantingTicketImpl.class.getSimpleName();
    private boolean lockTgt = true;
    @PersistenceContext(unitName="ticketEntityManagerFactory")
    private EntityManager entityManager;

    public void setLockTgt(boolean lockTgt) {
        this.lockTgt = lockTgt;
    }

    public void updateTicket(Ticket ticket) {
        this.entityManager.merge((Object)ticket);
        this.logger.debug("Updated ticket [{}].", (Object)ticket);
    }

    public void addTicket(Ticket ticket) {
        this.entityManager.persist((Object)ticket);
        this.logger.debug("Added ticket [{}] to registry.", (Object)ticket);
    }

    public boolean removeTicket(Ticket ticket) {
        try {
            ZonedDateTime creationDate = ticket.getCreationTime();
            this.logger.debug("Removing Ticket [{}] created: {}", (Object)ticket, (Object)creationDate.toString());
            this.entityManager.remove((Object)ticket);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Error removing {} from registry.", (Object)ticket.getId(), (Object)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        return this.getRawTicket(ticketId);
    }

    public Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith("TGT") || ticketId.startsWith("PGT")) {
                return (Ticket)this.entityManager.find(TicketGrantingTicketImpl.class, (Object)ticketId, (LockModeType)(this.lockTgt ? LockModeType.PESSIMISTIC_WRITE : null));
            }
            if (ticketId.startsWith("OC") || ticketId.startsWith("AT") || ticketId.startsWith("RT")) {
                return (Ticket)this.entityManager.find(OAuthCodeImpl.class, (Object)ticketId);
            }
            return (Ticket)this.entityManager.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.logger.error("Error getting ticket {} from registry.", (Object)ticketId, (Object)e);
            return null;
        }
    }

    public Collection<Ticket> getTickets() {
        List tgts = this.entityManager.createQuery("select t from " + TABLE_TICKET_GRANTING_TICKETS + " t", TicketGrantingTicketImpl.class).getResultList();
        List sts = this.entityManager.createQuery("select s from " + TABLE_SERVICE_TICKETS + " s", ServiceTicketImpl.class).getResultList();
        List ots = this.entityManager.createQuery("select s from " + TABLE_OAUTH_TICKETS + " s", OAuthCodeImpl.class).getResultList();
        ArrayList<Ticket> tickets = new ArrayList<Ticket>(tgts);
        tickets.addAll(sts);
        tickets.addAll(ots);
        return tickets;
    }

    public long sessionCount() {
        return JpaTicketRegistry.countToLong(this.entityManager.createQuery("select count(t) from " + TABLE_TICKET_GRANTING_TICKETS + " t").getSingleResult());
    }

    public long serviceTicketCount() {
        return JpaTicketRegistry.countToLong(this.entityManager.createQuery("select count(t) from " + TABLE_SERVICE_TICKETS + " t").getSingleResult());
    }

    public boolean deleteSingleTicket(String ticketId) {
        int failureCount;
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return true;
        }
        if (ticket instanceof OAuthToken) {
            failureCount = this.deleteOAuthTokens(ticketId);
        } else if (ticket instanceof ServiceTicket) {
            failureCount = this.deleteServiceTickets(ticketId);
        } else if (ticket instanceof TicketGrantingTicket) {
            failureCount = this.deleteTicketGrantingTickets(ticketId);
        } else {
            throw new IllegalArgumentException("Invalid ticket type with id " + ticketId);
        }
        return failureCount == 0;
    }

    public <T extends Ticket> List<T> getTicketQueryResultList(String ticketId, String query, Class<T> clazz) {
        return this.entityManager.createQuery(query, clazz).setParameter("id", (Object)ticketId).getResultList();
    }

    public int deleteOAuthTokens(String ticketId) {
        List<OAuthCodeImpl> oAuthCodeImpls = this.getTicketQueryResultList(ticketId, "select o from " + TABLE_OAUTH_TICKETS + " o where o.id = :id", OAuthCodeImpl.class);
        return this.deleteTicketsFromResultList(oAuthCodeImpls);
    }

    public int deleteServiceTickets(String ticketId) {
        List<ServiceTicketImpl> serviceTicketImpls = this.getTicketQueryResultList(ticketId, "select s from " + TABLE_SERVICE_TICKETS + " s where s.id = :id", ServiceTicketImpl.class);
        return this.deleteTicketsFromResultList(serviceTicketImpls);
    }

    public int deleteTicketsFromResultList(List<? extends Ticket> serviceTicketImpls) {
        int failureCount = 0;
        for (Ticket ticket : serviceTicketImpls) {
            if (this.removeTicket(ticket)) continue;
            ++failureCount;
        }
        return failureCount;
    }

    public int deleteTicketGrantingTickets(String ticketId) {
        int failureCount = 0;
        List<ServiceTicketImpl> serviceTicketImpls = this.getTicketQueryResultList(ticketId, "select s from " + TABLE_SERVICE_TICKETS + " s where s.ticketGrantingTicket.id = :id", ServiceTicketImpl.class);
        failureCount += this.deleteTicketsFromResultList(serviceTicketImpls);
        List<TicketGrantingTicketImpl> ticketGrantingTicketImpls = this.getTicketQueryResultList(ticketId, "select t from " + TABLE_TICKET_GRANTING_TICKETS + " t where t.ticketGrantingTicket.id = :id", TicketGrantingTicketImpl.class);
        failureCount += this.deleteTicketsFromResultList(ticketGrantingTicketImpls);
        ticketGrantingTicketImpls = this.getTicketQueryResultList(ticketId, "select t from " + TABLE_TICKET_GRANTING_TICKETS + " t where t.id = :id", TicketGrantingTicketImpl.class);
        return failureCount += this.deleteTicketsFromResultList(ticketGrantingTicketImpls);
    }

    private static long countToLong(Object result) {
        return ((Number)result).longValue();
    }
}

