/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.CryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.registry.JpaTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.support.JpaLockingStrategy;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.apereo.cas.util.InetAddressUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="jpaTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
public class JpaTicketRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public String[] ticketPackagesToScan() {
        return new String[]{"org.apereo.cas.ticket", "org.apereo.cas.adaptors.jdbc"};
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean ticketEntityManagerFactory() {
        return Beans.newEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)Beans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc()), "jpaTicketRegistryContext", this.ticketPackagesToScan(), this.dataSourceTicket()), (AbstractJpaProperties)this.casProperties.getTicket().getRegistry().getJpa());
    }

    @Bean
    public PlatformTransactionManager ticketTransactionManager(@Qualifier(value="ticketEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @RefreshScope
    @Bean
    public DataSource dataSourceTicket() {
        return Beans.newHickariDataSource((AbstractJpaProperties)this.casProperties.getTicket().getRegistry().getJpa());
    }

    @Bean(name={"jpaTicketRegistry", "ticketRegistry"})
    @RefreshScope
    public TicketRegistry jpaTicketRegistry() {
        JpaTicketRegistry bean = new JpaTicketRegistry();
        bean.setLockTgt(this.casProperties.getTicket().getRegistry().getJpa().isJpaLockingTgtEnabled());
        bean.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((CryptographyProperties)this.casProperties.getTicket().getRegistry().getJpa().getCrypto()));
        return bean;
    }

    @Bean
    public LockingStrategy lockingStrategy() {
        JpaLockingStrategy bean = new JpaLockingStrategy();
        bean.setApplicationId(this.casProperties.getTicket().getRegistry().getCleaner().getAppId());
        bean.setUniqueId((String)StringUtils.defaultIfEmpty((CharSequence)this.casProperties.getHost().getName(), (CharSequence)InetAddressUtils.getCasServerHostName()));
        bean.setLockTimeout(this.casProperties.getTicket().getRegistry().getJpa().getJpaLockingTimeout());
        return bean;
    }
}

