/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerServiceReg", readOnly=false)
public class JpaServiceRegistryDaoImpl
implements ServiceRegistryDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaServiceRegistryDaoImpl.class);
    @PersistenceContext(unitName="serviceEntityManagerFactory")
    private EntityManager entityManager;

    public boolean delete(RegisteredService registeredService) {
        if (this.entityManager.contains((Object)registeredService)) {
            this.entityManager.remove((Object)registeredService);
        } else {
            this.entityManager.remove(this.entityManager.merge((Object)registeredService));
        }
        return true;
    }

    public List<RegisteredService> load() {
        return this.entityManager.createQuery("select r from AbstractRegisteredService r", RegisteredService.class).getResultList();
    }

    public RegisteredService save(RegisteredService registeredService) {
        boolean isNew = registeredService.getId() == -9223372036854775807L;
        RegisteredService r = (RegisteredService)this.entityManager.merge((Object)registeredService);
        if (!isNew) {
            this.entityManager.persist((Object)r);
        }
        return r;
    }

    public RegisteredService findServiceById(long id) {
        return (RegisteredService)this.entityManager.find(AbstractRegisteredService.class, (Object)id);
    }

    public long size() {
        return (Long)this.entityManager.createQuery("select count(r) from AbstractRegisteredService r", Long.class).getSingleResult();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

