/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private String sql;

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template is found.");
        }
        String username = credential.getUsername();
        String password = credential.getPassword();
        try {
            String dbPassword = (String)this.getJdbcTemplate().queryForObject(this.sql, String.class, new Object[]{username});
            if (StringUtils.isNotBlank((CharSequence)originalPassword) && !this.matches(originalPassword, dbPassword) || StringUtils.isBlank((CharSequence)originalPassword) && !StringUtils.equals((CharSequence)password, (CharSequence)dbPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        return this.authenticateUsernamePasswordInternal(credential, null);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

