/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryAndEncodeDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    protected String algorithmName;
    protected String sql;
    protected String passwordFieldName = "password";
    protected String saltFieldName = "salt";
    protected String numberOfIterationsFieldName;
    protected long numberOfIterations;
    protected String staticSalt;

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || StringUtils.isBlank((CharSequence)this.algorithmName) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly");
        }
        String username = transformedCredential.getUsername();
        try {
            Map values = this.getJdbcTemplate().queryForMap(this.sql, new Object[]{username});
            String digestedPassword = this.digestEncodedPassword(transformedCredential.getPassword(), values);
            if (!values.get(this.passwordFieldName).equals(digestedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            return this.createHandlerResult((Credential)transformedCredential, this.principalFactory.createPrincipal(username), null);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }

    protected String digestEncodedPassword(String encodedPassword, Map<String, Object> values) {
        DefaultHashService hashService = new DefaultHashService();
        if (StringUtils.isNotBlank((CharSequence)this.staticSalt)) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)this.staticSalt));
        }
        hashService.setHashAlgorithmName(this.algorithmName);
        Long numOfIterations = this.numberOfIterations;
        if (values.containsKey(this.numberOfIterationsFieldName)) {
            String longAsStr = values.get(this.numberOfIterationsFieldName).toString();
            numOfIterations = Long.valueOf(longAsStr);
        }
        hashService.setHashIterations(numOfIterations.intValue());
        if (!values.containsKey(this.saltFieldName)) {
            throw new RuntimeException("Specified field name for salt does not exist in the results");
        }
        String dynaSalt = values.get(this.saltFieldName).toString();
        HashRequest request = new HashRequest.Builder().setSalt((Object)dynaSalt).setSource((Object)encodedPassword).build();
        return hashService.computeHash(request).toHex();
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setStaticSalt(String staticSalt) {
        this.staticSalt = staticSalt;
    }

    public void setPasswordFieldName(String passwordFieldName) {
        this.passwordFieldName = passwordFieldName;
    }

    public void setSaltFieldName(String saltFieldName) {
        this.saltFieldName = saltFieldName;
    }

    public void setNumberOfIterationsFieldName(String numberOfIterationsFieldName) {
        this.numberOfIterationsFieldName = numberOfIterationsFieldName;
    }

    public void setNumberOfIterations(long numberOfIterations) {
        this.numberOfIterations = numberOfIterations;
    }
}

