/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.util.cipher.NoOpCipherExecutor;
import org.apereo.cas.util.cipher.TicketGrantingCookieCipherExecutor;
import org.apereo.cas.web.WarningCookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.NoOpCookieValueManager;
import org.apereo.cas.web.support.TGCCookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCookieConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCookieConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCookieConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public CookieRetrievingCookieGenerator warnCookieGenerator() {
        return CasCookieConfiguration.configureCookieGenerator(new WarningCookieRetrievingCookieGenerator(), (CookieProperties)this.casProperties.getWarningCookie());
    }

    @Bean(name={"defaultCookieValueManager", "cookieValueManager"})
    public CookieValueManager defaultCookieValueManager() {
        if (this.casProperties.getTgc().isCipherEnabled()) {
            return new DefaultCasCookieValueManager(this.tgcCipherExecutor());
        }
        return new NoOpCookieValueManager();
    }

    @RefreshScope
    @Bean(name={"tgcCipherExecutor", "cookieCipherExecutor"})
    public CipherExecutor tgcCipherExecutor() {
        if (this.casProperties.getTgc().isCipherEnabled()) {
            return new TicketGrantingCookieCipherExecutor(this.casProperties.getTgc().getEncryptionKey(), this.casProperties.getTgc().getSigningKey());
        }
        LOGGER.info("Ticket-granting cookie encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of ticket-granting cookies.");
        return new NoOpCipherExecutor();
    }

    @Bean
    @RefreshScope
    public CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator() {
        CookieRetrievingCookieGenerator bean = CasCookieConfiguration.configureCookieGenerator(new TGCCookieRetrievingCookieGenerator(this.defaultCookieValueManager()), (CookieProperties)this.casProperties.getTgc());
        bean.setCookieDomain(this.casProperties.getTgc().getDomain());
        bean.setRememberMeMaxAge(this.casProperties.getTgc().getRememberMeMaxAge());
        return bean;
    }

    private static CookieRetrievingCookieGenerator configureCookieGenerator(CookieRetrievingCookieGenerator cookieGenerator, CookieProperties props) {
        cookieGenerator.setCookieName(props.getName());
        cookieGenerator.setCookiePath(props.getPath());
        cookieGenerator.setCookieMaxAge(props.getMaxAge());
        cookieGenerator.setCookieSecure(props.isSecure());
        cookieGenerator.setCookieHttpOnly(props.isHttpOnly());
        return cookieGenerator;
    }
}

