/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.SimpleTestDAG;
import org.apache.tez.test.SimpleTestDAG3Vertices;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;
import org.apache.tez.test.dag.SimpleReverseVTestDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.apache.tez.test.dag.SixLevelsFailingDAG;
import org.apache.tez.test.dag.ThreeLevelsFailingDAG;
import org.apache.tez.test.dag.TwoLevelsFailingDAG;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFaultTolerance {
    private static final Logger LOG = LoggerFactory.getLogger(TestFaultTolerance.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster;
    private static String TEST_ROOT_DIR;
    protected static MiniDFSCluster dfsCluster;
    private static TezClient tezSession;

    @BeforeClass
    public static void setup() throws Exception {
        LOG.info("Starting mini clusters");
        DistributedFileSystem remoteFs = null;
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestFaultTolerance.class.getName(), 3, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
            Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
            TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
            TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
            tezConf.setDouble("tez.task.max.allowed.output.failures.fraction", 0.4);
            tezConf.setInt("tez.am.max.allowed.time-sec.for-read-error", 3);
            tezConf.setInt("tez.task.am.heartbeat.interval-ms.max", 100);
            tezSession = TezClient.create((String)"TestFaultTolerance", (TezConfiguration)tezConf, (boolean)true);
            tezSession.start();
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("Stopping mini clusters");
        if (tezSession != null) {
            tezSession.stop();
        }
        if (miniTezCluster != null) {
            miniTezCluster.stop();
            miniTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState) throws Exception {
        this.runDAGAndVerify(dag, finalState, -1);
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState, int checkFailedAttempts) throws Exception {
        this.runDAGAndVerify(dag, finalState, checkFailedAttempts, null);
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState, int checkFailedAttempts, String diagnostics) throws Exception {
        tezSession.waitTillReady();
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appContext: " + dagClient.getExecutionContext() + " Current state: " + dagStatus.getState());
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
        if (checkFailedAttempts > 0) {
            Assert.assertEquals((long)checkFailedAttempts, (long)dagStatus.getDAGProgress().getFailedTaskAttemptCount());
        }
        if (diagnostics != null) {
            Assert.assertNotNull((Object)dagStatus.getDiagnostics());
            Assert.assertTrue((boolean)Joiner.on((String)":").join((Iterable)dagStatus.getDiagnostics()).contains(diagnostics));
        }
    }

    @Test(timeout=60000L)
    public void testBasicSuccessScatterGather() throws Exception {
        DAG dag = SimpleTestDAG.createDAG("testBasicSuccessScatterGather", null);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicSuccessBroadcast() throws Exception {
        DAG dag = DAG.create((String)"testBasicSuccessBroadcast");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)TestProcessor.getProcDesc(null), (int)2, (Resource)SimpleTestDAG.defaultResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)TestProcessor.getProcDesc(null), (int)2, (Resource)SimpleTestDAG.defaultResource);
        dag.addVertex(v1).addVertex(v2).addEdge(Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)TestOutput.getOutputDesc(null), (InputDescriptor)TestInput.getInputDesc(null))));
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicTaskFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 0);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 4);
        DAG dag = SimpleTestDAG.createDAG("testBasicTaskFailure", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED, 1);
    }

    @Test(timeout=60000L)
    public void testTaskMultipleFailures() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 7);
        DAG dag = SimpleTestDAG.createDAG("testTaskMultipleFailures", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED, 4);
    }

    @Test(timeout=60000L)
    public void testTaskMultipleFailuresDAGFail() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), -1);
        DAG dag = SimpleTestDAG.createDAG("testTaskMultipleFailuresDAGFail", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED);
    }

    @Test(timeout=60000L)
    public void testBasicInputFailureWithExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        DAG dag = SimpleTestDAG.createDAG("testBasicInputFailureWithExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 4);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 3);
        DAG dag = SimpleTestDAG.createDAG("testBasicInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicInputFailureWithoutExitDeadline() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 3);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "2");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        DAG dag = SimpleTestDAG.createDAG("testBasicInputFailureWithoutExitDeadline", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testMultipleInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "-1");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        DAG dag = SimpleTestDAG.createDAG("testMultipleInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testMultiVersionInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 3);
        DAG dag = SimpleTestDAG.createDAG("testMultiVersionInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTwoLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = TwoLevelsFailingDAG.createDAG("testTwoLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testThreeLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = ThreeLevelsFailingDAG.createDAG("testThreeLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testSixLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = SixLevelsFailingDAG.createDAG("testSixLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testThreeLevelsFailingDAG2VerticesHaveFailedAttemptsDAGSucceeds() throws Exception {
        Configuration testConf = new Configuration();
        testConf.setInt("tez.am.task.max.failed.attempts", 4);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "l2v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "l2v1"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "l2v1"), 2);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "l3v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "l3v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "l3v1"), 2);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "l3v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "l3v1", 0), 15);
        DAG dag = ThreeLevelsFailingDAG.createDAG("testThreeLevelsFailingDAG2VerticesHaveFailedAttemptsDAGSucceeds", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureCausesRerunAttemptWithinMaxAttemptSuccess() throws Exception {
        Configuration testConf = new Configuration();
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 0);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "1");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        DAG dag = SimpleTestDAG.createDAG("testInputFailureCausesRerunAttemptWithinMaxAttemptSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    private void setCascadingInputFailureConfig(Configuration testConf, boolean failAndExit) {
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), failAndExit);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 0);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), failAndExit);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), 0);
    }

    @Test(timeout=60000L)
    public void testCascadingInputFailureWithoutExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, false);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 9);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 9);
        DAG dag = SimpleTestDAG3Vertices.createDAG("testCascadingInputFailureWithoutExitSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testCascadingInputFailureWithExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 11);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 11);
        DAG dag = SimpleTestDAG3Vertices.createDAG("testCascadingInputFailureWithExitSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureCausesRerunOfTwoVerticesWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), "1");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 13);
        DAG dag = SimpleVTestDAG.createDAG("testInputFailureCausesRerunOfTwoVerticesWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v3"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v3"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 7);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 7);
        DAG dag = SimpleVTestDAG.createDAG("testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureRerunCanSendOutputToTwoDownstreamVertices() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), "0");
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 5);
        DAG dag = SimpleReverseVTestDAG.createDAG("testInputFailureRerunCanSendOutputToTwoDownstreamVertices", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTwoTasksHaveInputFailuresSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        DAG dag = SimpleTestDAG.createDAG("testTwoTasksHaveInputFailuresSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=240000L)
    public void testRandomFailingTasks() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.TEZ_FAILING_PROCESSOR_DO_RANDOM_FAIL, true);
        testConf.setFloat(TestProcessor.TEZ_FAILING_PROCESSOR_RANDOM_FAIL_PROBABILITY, 0.5f);
        DAG dag = SixLevelsFailingDAG.createDAG("testRandomFailingTasks", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=240000L)
    public void testRandomFailingInputs() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.TEZ_FAILING_INPUT_DO_RANDOM_FAIL, true);
        testConf.setFloat(TestInput.TEZ_FAILING_INPUT_RANDOM_FAIL_PROBABILITY, 0.5f);
        DAG dag = SixLevelsFailingDAG.createDAG("testRandomFailingInputs", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=240000L)
    public void testNoProgress() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(TestProcessor.TEZ_FAILING_PROCESSOR_SLEEP_MS, 100000);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        DAG dag = SimpleTestDAG.createDAG(testConf);
        Vertex hung = dag.getVertex("v1");
        hung.setConf("tez.task.progress.stuck.interval-ms", Long.toString(1000L));
        hung.setConf("tez.am.task.max.failed.attempts", Integer.toString(2));
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED, 2, "no progress");
    }

    static {
        TEST_ROOT_DIR = "target/" + TestFaultTolerance.class.getName() + "-tmpDir";
        tezSession = null;
    }
}

