/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.JavaOptsChecker;
import org.apache.tez.common.RPCUtil;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DAGSubmissionTimedOut;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.SessionNotReady;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TezClient {
    private static final Logger LOG = LoggerFactory.getLogger(TezClient.class);
    @VisibleForTesting
    static final String NO_CLUSTER_DIAGNOSTICS_MSG = "No cluster diagnostics found.";
    @VisibleForTesting
    final String clientName;
    private ApplicationId sessionAppId;
    private ApplicationId lastSubmittedAppId;
    @VisibleForTesting
    final AMConfiguration amConfig;
    private FrameworkClient frameworkClient;
    private String diagnostics;
    @VisibleForTesting
    final boolean isSession;
    private final AtomicBoolean sessionStarted = new AtomicBoolean(false);
    private final AtomicBoolean sessionStopped = new AtomicBoolean(false);
    private Credentials sessionCredentials = new Credentials();
    private long clientTimeout;
    Map<String, LocalResource> cachedTezJarResources;
    boolean usingTezArchiveDeploy = false;
    private static final long SLEEP_FOR_READY = 500L;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private final Map<String, LocalResource> additionalLocalResources = Maps.newHashMap();
    @VisibleForTesting
    final TezApiVersionInfo apiVersionInfo;
    @VisibleForTesting
    final ServicePluginsDescriptor servicePluginsDescriptor;
    private JavaOptsChecker javaOptsChecker = null;
    private int preWarmDAGCounter = 0;
    private int maxSubmitDAGRequestSizeThroughIPC;
    private AtomicInteger serializedSubmitDAGPlanRequestCounter = new AtomicInteger(0);
    private FileSystem stagingFs = null;
    private ScheduledExecutorService amKeepAliveService;
    private static final char SEPARATOR = '_';
    public static final String DAG = "dag";
    static final ThreadLocal<NumberFormat> tezAppIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };
    static final ThreadLocal<NumberFormat> tezDagIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(1);
            return fmt;
        }
    };

    private TezClient(String name, TezConfiguration tezConf) {
        this(name, tezConf, tezConf.getBoolean("tez.am.mode.session", false));
    }

    @InterfaceAudience.Private
    TezClient(String name, TezConfiguration tezConf, @Nullable Map<String, LocalResource> localResources, @Nullable Credentials credentials) {
        this(name, tezConf, tezConf.getBoolean("tez.am.mode.session", false), localResources, credentials);
    }

    private TezClient(String name, TezConfiguration tezConf, boolean isSession) {
        this(name, tezConf, isSession, null, null);
    }

    @InterfaceAudience.Private
    protected TezClient(String name, TezConfiguration tezConf, boolean isSession, @Nullable Map<String, LocalResource> localResources, @Nullable Credentials credentials) {
        this(name, tezConf, isSession, localResources, credentials, null);
    }

    @InterfaceAudience.Private
    protected TezClient(String name, TezConfiguration tezConf, boolean isSession, @Nullable Map<String, LocalResource> localResources, @Nullable Credentials credentials, ServicePluginsDescriptor servicePluginsDescriptor) {
        this.clientName = name;
        this.isSession = isSession;
        tezConf.setBoolean("tez.am.mode.session", isSession);
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (ip != null) {
                tezConf.set("tez.submit.host", ip.getCanonicalHostName());
                tezConf.set("tez.submit.host.address", ip.getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            LOG.warn("The host name of the client the tez application was submitted from was unable to be retrieved", (Throwable)e);
        }
        this.amConfig = new AMConfiguration(tezConf, localResources, credentials);
        this.apiVersionInfo = new TezApiVersionInfo();
        this.servicePluginsDescriptor = servicePluginsDescriptor;
        this.maxSubmitDAGRequestSizeThroughIPC = tezConf.getInt("ipc.maximum.data.length", 0x4000000) - tezConf.getInt("tez.ipc.payload.reserved.bytes", 0x500000);
        Limits.setConfiguration(tezConf);
        LOG.info("Tez Client Version: " + this.apiVersionInfo.toString());
    }

    public static TezClientBuilder newBuilder(String name, TezConfiguration tezConf) {
        return new TezClientBuilder(name, tezConf);
    }

    public static TezClient create(String name, TezConfiguration tezConf) {
        return new TezClient(name, tezConf);
    }

    public static TezClient create(String name, TezConfiguration tezConf, @Nullable Map<String, LocalResource> localFiles, @Nullable Credentials credentials) {
        return new TezClient(name, tezConf, localFiles, credentials);
    }

    public static TezClient create(String name, TezConfiguration tezConf, boolean isSession) {
        return new TezClient(name, tezConf, isSession);
    }

    public static TezClient create(String name, TezConfiguration tezConf, boolean isSession, @Nullable Map<String, LocalResource> localFiles, @Nullable Credentials credentials) {
        return new TezClient(name, tezConf, isSession, localFiles, credentials);
    }

    public synchronized void addAppMasterLocalFiles(Map<String, LocalResource> localFiles) {
        Preconditions.checkNotNull(localFiles);
        if (this.isSession && this.sessionStarted.get()) {
            this.additionalLocalResources.putAll(localFiles);
        }
        this.amConfig.addAMLocalResources(localFiles);
    }

    public synchronized void clearAppMasterLocalFiles() {
        this.amConfig.clearAMLocalResources();
    }

    public synchronized void setAppMasterCredentials(Credentials credentials) {
        Preconditions.checkState((!this.sessionStarted.get() ? 1 : 0) != 0, (Object)"Credentials cannot be set after the session App Master has been started");
        this.amConfig.setCredentials(credentials);
    }

    public synchronized void setHistoryLogLevel(HistoryLogLevel historyLogLevel) {
        this.amConfig.getTezConfiguration().setEnum("tez.history.logging.log.level", historyLogLevel);
    }

    public synchronized void start() throws TezException, IOException {
        this.amConfig.setYarnConfiguration(new YarnConfiguration((Configuration)this.amConfig.getTezConfiguration()));
        this.frameworkClient = this.createFrameworkClient();
        this.frameworkClient.init(this.amConfig.getTezConfiguration(), this.amConfig.getYarnConfiguration());
        this.frameworkClient.start();
        if (this.amConfig.getTezConfiguration().getBoolean("tez.java.opts.checker.enabled", true)) {
            String javaOptsCheckerClassName = this.amConfig.getTezConfiguration().get("tez.java.opts.checker.class", "");
            if (!javaOptsCheckerClassName.isEmpty()) {
                try {
                    this.javaOptsChecker = (JavaOptsChecker)ReflectionUtils.createClazzInstance(javaOptsCheckerClassName);
                }
                catch (Exception e) {
                    LOG.warn("Failed to initialize configured Java Opts Checker (tez.java.opts.checker.class) , checkerClass=" + javaOptsCheckerClassName + ". Disabling checker.", (Throwable)e);
                    this.javaOptsChecker = null;
                }
            } else {
                this.javaOptsChecker = new JavaOptsChecker();
            }
        }
        if (this.isSession) {
            LOG.info("Session mode. Starting session.");
            TezClientUtils.processTezLocalCredentialsFile(this.sessionCredentials, this.amConfig.getTezConfiguration());
            Map<String, LocalResource> tezJarResources = this.getTezJarResources(this.sessionCredentials);
            this.clientTimeout = this.amConfig.getTezConfiguration().getInt("tez.session.client.timeout.secs", 120);
            try {
                if (this.sessionAppId == null) {
                    this.sessionAppId = this.createApplication();
                }
                TezClientUtils.createSessionToken(this.sessionAppId.toString(), this.jobTokenSecretManager, this.sessionCredentials);
                ApplicationSubmissionContext appContext = TezClientUtils.createApplicationSubmissionContext(this.sessionAppId, null, this.clientName, this.amConfig, tezJarResources, this.sessionCredentials, this.usingTezArchiveDeploy, this.apiVersionInfo, this.servicePluginsDescriptor, this.javaOptsChecker);
                if (!this.amConfig.getTezConfiguration().getBoolean("tez.dag.recovery.enabled", true)) {
                    appContext.setMaxAppAttempts(1);
                }
                this.frameworkClient.submitApplication(appContext);
                ApplicationReport appReport = this.frameworkClient.getApplicationReport(this.sessionAppId);
                LOG.info("The url to track the Tez Session: " + appReport.getTrackingUrl());
                this.sessionStarted.set(true);
            }
            catch (YarnException e) {
                throw new TezException(e);
            }
            long amClientKeepAliveTimeoutIntervalMillis = TezCommonUtils.getAMClientHeartBeatTimeoutMillis(this.amConfig.getTezConfiguration());
            long pollPeriod = TezCommonUtils.getAMClientHeartBeatPollIntervalMillis(this.amConfig.getTezConfiguration(), amClientKeepAliveTimeoutIntervalMillis, 10);
            boolean isLocal = this.amConfig.getTezConfiguration().getBoolean("tez.local.mode", false);
            if (!isLocal && amClientKeepAliveTimeoutIntervalMillis > 0L) {
                this.amKeepAliveService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AMKeepAliveThread #%d").build());
                this.amKeepAliveService.scheduleWithFixedDelay(new Runnable(){
                    private DAGClientAMProtocolBlockingPB proxy;

                    @Override
                    public void run() {
                        this.proxy = TezClient.this.sendAMHeartbeat(this.proxy);
                    }
                }, pollPeriod, pollPeriod, TimeUnit.MILLISECONDS);
            }
            this.stagingFs = FileSystem.get((Configuration)this.amConfig.getTezConfiguration());
        }
    }

    public DAGClientAMProtocolBlockingPB sendAMHeartbeat(DAGClientAMProtocolBlockingPB proxy) {
        if (this.sessionStopped.get()) {
            return null;
        }
        try {
            if (proxy == null) {
                try {
                    proxy = this.waitForProxy();
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted while trying to create a connection to the AM", (Throwable)e);
                }
                catch (SessionNotRunning e) {
                    LOG.error("Cannot create a connection to the AM, stopping heartbeat to AM", (Throwable)e);
                    this.cancelAMKeepAlive(false);
                }
            }
            if (proxy != null) {
                LOG.debug("Sending heartbeat to AM");
                proxy.getAMStatus(null, DAGClientAMProtocolRPC.GetAMStatusRequestProto.newBuilder().build());
            }
            return proxy;
        }
        catch (Exception e) {
            LOG.info("Exception when sending heartbeat to AM for app {}: {}", (Object)this.sessionAppId, (Object)e.getMessage());
            LOG.debug("Error when sending heartbeat ping to AM. Resetting AM proxy for app: {} due to exception :", (Object)this.sessionAppId, (Object)e);
            return null;
        }
    }

    public synchronized DAGClient submitDAG(DAG dag) throws TezException, IOException {
        if (this.isSession) {
            return this.submitDAGSession(dag);
        }
        return this.submitDAGApplication(dag);
    }

    private DAGClient submitDAGSession(DAG dag) throws TezException, IOException {
        Preconditions.checkState((this.isSession ? 1 : 0) != 0, (Object)"submitDAG with additional resources applies to only session mode. In non-session mode please specify all resources in the initial configuration");
        this.verifySessionStateForSubmission();
        String dagId = null;
        String callerContextStr = "";
        if (dag.getCallerContext() != null) {
            callerContextStr = ", callerContext=" + dag.getCallerContext().contextAsSimpleString();
        }
        LOG.info("Submitting dag to TezSession, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId + ", dagName=" + dag.getName() + callerContextStr);
        if (!this.additionalLocalResources.isEmpty()) {
            for (LocalResource lr : this.additionalLocalResources.values()) {
                Preconditions.checkArgument((lr.getType() == LocalResourceType.FILE ? 1 : 0) != 0, (Object)("LocalResourceType: " + lr.getType() + " is not supported, only " + LocalResourceType.FILE + " is supported"));
            }
        }
        Map<String, LocalResource> tezJarResources = this.getTezJarResources(this.sessionCredentials);
        DAGProtos.DAGPlan dagPlan = TezClientUtils.prepareAndCreateDAGPlan(dag, this.amConfig, tezJarResources, this.usingTezArchiveDeploy, this.sessionCredentials, this.servicePluginsDescriptor, this.javaOptsChecker);
        DAGClientAMProtocolRPC.SubmitDAGRequestProto.Builder requestBuilder = DAGClientAMProtocolRPC.SubmitDAGRequestProto.newBuilder();
        requestBuilder.setDAGPlan(dagPlan);
        if (!this.additionalLocalResources.isEmpty()) {
            requestBuilder.setAdditionalAmResources(DagTypeConverters.convertFromLocalResources(this.additionalLocalResources));
        }
        this.additionalLocalResources.clear();
        DAGClientAMProtocolRPC.SubmitDAGRequestProto request = requestBuilder.build();
        if (request.getSerializedSize() > this.maxSubmitDAGRequestSizeThroughIPC) {
            Path dagPlanPath = new Path(TezCommonUtils.getTezSystemStagingPath(this.amConfig.getTezConfiguration(), this.sessionAppId.toString()), "tez-dag.pb" + this.serializedSubmitDAGPlanRequestCounter.incrementAndGet());
            try (FSDataOutputStream fsDataOutputStream = this.stagingFs.create(dagPlanPath, false);){
                LOG.info("Send dag plan using YARN local resources since it's too large, dag plan size=" + request.getSerializedSize() + ", max dag plan size through IPC=" + this.maxSubmitDAGRequestSizeThroughIPC + ", max IPC message size= " + this.amConfig.getTezConfiguration().getInt("ipc.maximum.data.length", 0x4000000));
                request.writeTo((OutputStream)fsDataOutputStream);
                request = requestBuilder.clear().setSerializedRequestPath(this.stagingFs.resolvePath(dagPlanPath).toString()).build();
            }
        }
        DAGClientAMProtocolBlockingPB proxy = null;
        try {
            proxy = this.waitForProxy();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while trying to create a connection to the AM", e);
        }
        if (proxy == null) {
            try {
                LOG.warn("DAG submission to session timed out, stopping session");
                this.stop();
            }
            catch (Throwable t) {
                LOG.info("Got an exception when trying to stop session", t);
            }
            throw new DAGSubmissionTimedOut("Could not submit DAG to Tez Session, timed out after " + this.clientTimeout + " seconds");
        }
        try {
            DAGClientAMProtocolRPC.SubmitDAGResponseProto response = proxy.submitDAG(null, request);
            if (response != null) {
                dagId = response.getDagId();
            }
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
        }
        LOG.info("Submitted dag to TezSession, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId + ", dagId=" + dagId + ", dagName=" + dag.getName());
        return new DAGClientImpl(this.sessionAppId, dagId, this.amConfig.getTezConfiguration(), this.amConfig.getYarnConfiguration(), this.frameworkClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws TezException, IOException {
        block17: {
            try {
                boolean sessionShutdownSuccessful;
                block18: {
                    if (this.amKeepAliveService != null) {
                        this.amKeepAliveService.shutdownNow();
                    }
                    if (!this.sessionStarted.get()) break block17;
                    LOG.info("Shutting down Tez Session, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId);
                    this.sessionStopped.set(true);
                    sessionShutdownSuccessful = false;
                    try {
                        long currentTimeMillis;
                        DAGClientAMProtocolBlockingPB proxy = this.getAMProxy(this.sessionAppId);
                        if (proxy == null) break block18;
                        DAGClientAMProtocolRPC.ShutdownSessionRequestProto request = DAGClientAMProtocolRPC.ShutdownSessionRequestProto.newBuilder().build();
                        proxy.shutdownSession(null, request);
                        sessionShutdownSuccessful = true;
                        boolean asynchronousStop = this.amConfig.getTezConfiguration().getBoolean("tez.client.asynchronous-stop", true);
                        if (asynchronousStop) break block18;
                        LOG.info("Waiting until application is in a final state");
                        long timeKillIssued = currentTimeMillis = System.currentTimeMillis();
                        long killTimeOut = this.amConfig.getTezConfiguration().getLong("tez.client.timeout-ms", 30000L);
                        ApplicationReport appReport = this.frameworkClient.getApplicationReport(this.sessionAppId);
                        while (currentTimeMillis < timeKillIssued + killTimeOut && !this.isJobInTerminalState(appReport.getYarnApplicationState())) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ie) {
                                break;
                            }
                            currentTimeMillis = System.currentTimeMillis();
                            appReport = this.frameworkClient.getApplicationReport(this.sessionAppId);
                        }
                        if (!this.isJobInTerminalState(appReport.getYarnApplicationState())) {
                            this.frameworkClient.killApplication(this.sessionAppId);
                        }
                    }
                    catch (TezException e) {
                        LOG.info("Failed to shutdown Tez Session via proxy", (Throwable)e);
                    }
                    catch (ServiceException e) {
                        LOG.info("Failed to shutdown Tez Session via proxy", (Throwable)e);
                    }
                    catch (ApplicationNotFoundException e) {
                        LOG.info("Failed to kill nonexistent application " + this.sessionAppId, (Throwable)e);
                    }
                    catch (YarnException e) {
                        throw new TezException(e);
                    }
                }
                if (sessionShutdownSuccessful) break block17;
                LOG.info("Could not connect to AM, killing session via YARN, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId);
                try {
                    this.frameworkClient.killApplication(this.sessionAppId);
                }
                catch (ApplicationNotFoundException e) {
                    LOG.info("Failed to kill nonexistent application " + this.sessionAppId, (Throwable)e);
                }
                catch (YarnException e) {
                    throw new TezException(e);
                }
            }
            finally {
                if (this.frameworkClient != null) {
                    this.frameworkClient.close();
                }
            }
        }
    }

    private boolean isJobInTerminalState(YarnApplicationState yarnApplicationState) {
        return yarnApplicationState == YarnApplicationState.FINISHED || yarnApplicationState == YarnApplicationState.FAILED || yarnApplicationState == YarnApplicationState.KILLED;
    }

    public String getClientName() {
        return this.clientName;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized ApplicationId getAppMasterApplicationId() {
        if (this.isSession) {
            return this.sessionAppId;
        }
        return this.lastSubmittedAppId;
    }

    public synchronized TezAppMasterStatus getAppMasterStatus() throws TezException, IOException {
        ApplicationId appId = null;
        appId = this.isSession ? this.sessionAppId : this.lastSubmittedAppId;
        Preconditions.checkState((appId != null ? 1 : 0) != 0, (Object)"Cannot get status without starting an application");
        try {
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(appId);
            switch (appReport.getYarnApplicationState()) {
                case NEW: 
                case NEW_SAVING: 
                case ACCEPTED: 
                case SUBMITTED: {
                    return TezAppMasterStatus.INITIALIZING;
                }
                case FAILED: 
                case KILLED: {
                    this.diagnostics = appReport.getDiagnostics();
                    LOG.info("App did not succeed. Diagnostics: " + (appReport.getDiagnostics() != null ? appReport.getDiagnostics() : NO_CLUSTER_DIAGNOSTICS_MSG));
                    return TezAppMasterStatus.SHUTDOWN;
                }
                case FINISHED: {
                    return TezAppMasterStatus.SHUTDOWN;
                }
                case RUNNING: {
                    try {
                        DAGClientAMProtocolBlockingPB proxy = this.getAMProxy(appId);
                        if (proxy == null) {
                            return TezAppMasterStatus.INITIALIZING;
                        }
                        DAGClientAMProtocolRPC.GetAMStatusResponseProto response = proxy.getAMStatus(null, DAGClientAMProtocolRPC.GetAMStatusRequestProto.newBuilder().build());
                        return DagTypeConverters.convertTezAppMasterStatusFromProto(response.getStatus());
                    }
                    catch (TezException e) {
                        LOG.info("Failed to retrieve AM Status via proxy", (Throwable)e);
                        break;
                    }
                    catch (ServiceException e) {
                        LOG.info("Failed to retrieve AM Status via proxy", (Throwable)e);
                    }
                }
            }
        }
        catch (ApplicationNotFoundException e) {
            return TezAppMasterStatus.SHUTDOWN;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return TezAppMasterStatus.INITIALIZING;
    }

    @InterfaceStability.Unstable
    public synchronized void preWarm(PreWarmVertex preWarmVertex) throws TezException, IOException {
        this.preWarm(preWarmVertex, 0L, TimeUnit.MILLISECONDS);
    }

    @InterfaceStability.Unstable
    public synchronized void preWarm(PreWarmVertex preWarmVertex, long timeout, TimeUnit unit) throws TezException, IOException {
        boolean isReady;
        if (!this.isSession) {
            LOG.warn("preWarm is not supported in non-session mode,please use session-mode of TezClient");
            return;
        }
        this.verifySessionStateForSubmission();
        DAG dag = org.apache.tez.dag.api.DAG.create("TezPreWarmDAG_" + this.preWarmDAGCounter++);
        dag.addVertex(preWarmVertex);
        try {
            isReady = this.waitTillReady(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for AM to become available", e);
        }
        if (!isReady) {
            throw new SessionNotReady("Tez AM not ready, could not submit DAG");
        }
        this.submitDAG(dag);
    }

    @InterfaceStability.Evolving
    public synchronized void waitTillReady() throws IOException, TezException, InterruptedException {
        this.waitTillReady(0L, TimeUnit.MILLISECONDS);
    }

    @InterfaceStability.Evolving
    public synchronized boolean waitTillReady(long timeout, TimeUnit unit) throws IOException, TezException, InterruptedException {
        timeout = unit.toMillis(timeout);
        if (!this.isSession) {
            return true;
        }
        this.verifySessionStateForSubmission();
        long startTime = Time.monotonicNow();
        long timeLimit = startTime + timeout;
        while (true) {
            TezAppMasterStatus status;
            if ((status = this.getAppMasterStatus()).equals((Object)TezAppMasterStatus.SHUTDOWN)) {
                throw new SessionNotRunning("TezSession has already shutdown. " + (this.diagnostics != null ? this.diagnostics : NO_CLUSTER_DIAGNOSTICS_MSG));
            }
            if (status.equals((Object)TezAppMasterStatus.READY)) {
                return true;
            }
            if (timeout == 0L) {
                Thread.sleep(500L);
                continue;
            }
            long now = Time.monotonicNow();
            if (timeLimit <= now) break;
            long sleepTime = Math.min(500L, timeLimit - now);
            Thread.sleep(sleepTime);
        }
        return false;
    }

    private void waitNonSessionTillReady() throws IOException, TezException {
        Preconditions.checkArgument((!this.isSession ? 1 : 0) != 0, (Object)"It is supposed to be only called in non-session mode");
        TezAppMasterStatus status;
        while (!(status = this.getAppMasterStatus()).equals((Object)TezAppMasterStatus.RUNNING) && !status.equals((Object)TezAppMasterStatus.SHUTDOWN)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new TezException("TezClient is interrupted");
            }
        }
        return;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected FrameworkClient createFrameworkClient() {
        return FrameworkClient.createFrameworkClient(this.amConfig.getTezConfiguration());
    }

    @VisibleForTesting
    protected DAGClientAMProtocolBlockingPB getAMProxy(ApplicationId appId) throws TezException, IOException {
        return TezClientUtils.getAMProxy(this.frameworkClient, (Configuration)this.amConfig.getYarnConfiguration(), appId);
    }

    private DAGClientAMProtocolBlockingPB waitForProxy() throws IOException, TezException, InterruptedException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.clientTimeout * 1000L;
        DAGClientAMProtocolBlockingPB proxy = null;
        while ((proxy = this.getAMProxy(this.sessionAppId)) == null) {
            Thread.sleep(100L);
            if (this.clientTimeout == -1L || System.currentTimeMillis() <= endTime) continue;
            break;
        }
        return proxy;
    }

    private void verifySessionStateForSubmission() throws SessionNotRunning {
        Preconditions.checkState((boolean)this.isSession, (Object)"Invalid without session mode");
        if (!this.sessionStarted.get()) {
            throw new SessionNotRunning("Session not started");
        }
        if (this.sessionStopped.get()) {
            throw new SessionNotRunning("Session stopped by user");
        }
    }

    private DAGClient submitDAGApplication(DAG dag) throws TezException, IOException {
        ApplicationId appId = this.createApplication();
        return this.submitDAGApplication(appId, dag);
    }

    @InterfaceAudience.Private
    DAGClient submitDAGApplication(ApplicationId appId, DAG dag) throws TezException, IOException {
        LOG.info("Submitting DAG application with id: " + appId);
        try {
            Credentials credentials = this.amConfig.getCredentials();
            if (credentials == null) {
                credentials = new Credentials();
            }
            TezClientUtils.processTezLocalCredentialsFile(credentials, this.amConfig.getTezConfiguration());
            TezClientUtils.createSessionToken(appId.toString(), this.jobTokenSecretManager, credentials);
            Map<String, LocalResource> tezJarResources = this.getTezJarResources(credentials);
            ApplicationSubmissionContext appContext = TezClientUtils.createApplicationSubmissionContext(appId, dag, dag.getName(), this.amConfig, tezJarResources, credentials, this.usingTezArchiveDeploy, this.apiVersionInfo, this.servicePluginsDescriptor, this.javaOptsChecker);
            String callerContextStr = "";
            if (dag.getCallerContext() != null) {
                callerContextStr = ", callerContext=" + dag.getCallerContext().contextAsSimpleString();
            }
            LOG.info("Submitting DAG to YARN, applicationId=" + appId + ", dagName=" + dag.getName() + callerContextStr);
            this.frameworkClient.submitApplication(appContext);
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(appId);
            LOG.info("The url to track the Tez AM: " + appReport.getTrackingUrl());
            this.lastSubmittedAppId = appId;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        this.waitNonSessionTillReady();
        return TezClient.getDAGClient(appId, this.amConfig.getTezConfiguration(), this.amConfig.getYarnConfiguration(), this.frameworkClient);
    }

    private ApplicationId createApplication() throws TezException, IOException {
        try {
            return this.frameworkClient.createApplication().getNewApplicationResponse().getApplicationId();
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    private synchronized Map<String, LocalResource> getTezJarResources(Credentials credentials) throws IOException {
        if (this.cachedTezJarResources == null) {
            this.cachedTezJarResources = new HashMap<String, LocalResource>();
            this.usingTezArchiveDeploy = TezClientUtils.setupTezJarsLocalResources(this.amConfig.getTezConfiguration(), credentials, this.cachedTezJarResources);
        }
        return this.cachedTezJarResources;
    }

    @InterfaceAudience.Private
    static DAGClient getDAGClient(ApplicationId appId, TezConfiguration tezConf, YarnConfiguration yarnConf, FrameworkClient frameworkClient) throws IOException, TezException {
        return new DAGClientImpl(appId, TezClient.getDefaultTezDAGID(appId), tezConf, yarnConf, frameworkClient);
    }

    @InterfaceAudience.Private
    static DAGClient getDAGClient(ApplicationId appId, TezConfiguration tezConf, FrameworkClient frameworkClient) throws IOException, TezException {
        return TezClient.getDAGClient(appId, tezConf, new YarnConfiguration((Configuration)tezConf), frameworkClient);
    }

    private static String getDefaultTezDAGID(ApplicationId applicationId) {
        return DAG + '_' + applicationId.getClusterTimestamp() + '_' + tezAppIdFormat.get().format(applicationId.getId()) + '_' + tezDagIdFormat.get().format(1L);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void cancelAMKeepAlive(boolean shutdownNow) {
        if (this.amKeepAliveService != null) {
            if (shutdownNow) {
                this.amKeepAliveService.shutdownNow();
            } else {
                this.amKeepAliveService.shutdown();
            }
        }
    }

    @VisibleForTesting
    protected synchronized ScheduledExecutorService getAMKeepAliveService() {
        return this.amKeepAliveService;
    }

    @InterfaceAudience.Public
    public static class TezClientBuilder {
        final String name;
        final TezConfiguration tezConf;
        boolean isSession;
        private Map<String, LocalResource> localResourceMap;
        private Credentials credentials;
        ServicePluginsDescriptor servicePluginsDescriptor;

        private TezClientBuilder(String name, TezConfiguration tezConf) {
            this.name = name;
            this.tezConf = tezConf;
            this.isSession = tezConf.getBoolean("tez.am.mode.session", false);
        }

        public TezClientBuilder setIsSession(boolean isSession) {
            this.isSession = isSession;
            return this;
        }

        public TezClientBuilder setLocalResources(Map<String, LocalResource> localResources) {
            this.localResourceMap = localResources;
            return this;
        }

        public TezClientBuilder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public TezClientBuilder setServicePluginDescriptor(ServicePluginsDescriptor servicePluginsDescriptor) {
            this.servicePluginsDescriptor = servicePluginsDescriptor;
            return this;
        }

        public TezClient build() {
            return new TezClient(this.name, this.tezConf, this.isSession, this.localResourceMap, this.credentials, this.servicePluginsDescriptor);
        }
    }
}

