/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DAGSubmissionTimedOut;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Public
public class TezClient {
    private static final Log LOG = LogFactory.getLog(TezClient.class);
    private final String clientName;
    private ApplicationId sessionAppId;
    private ApplicationId lastSubmittedAppId;
    private AMConfiguration amConfig;
    private FrameworkClient frameworkClient;
    private boolean isSession;
    private boolean sessionStarted = false;
    private boolean sessionStopped = false;
    private Credentials sessionCredentials = new Credentials();
    private long clientTimeout;
    Map<String, LocalResource> cachedTezJarResources;
    boolean usingTezArchiveDeploy = false;
    private static final long SLEEP_FOR_READY = 500L;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private Map<String, LocalResource> additionalLocalResources = Maps.newHashMap();
    private TezApiVersionInfo apiVersionInfo;
    private int preWarmDAGCounter = 0;
    private static final char SEPARATOR = '_';
    public static final String DAG = "dag";
    static final ThreadLocal<NumberFormat> tezAppIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };
    static final ThreadLocal<NumberFormat> tezDagIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(1);
            return fmt;
        }
    };

    private TezClient(String name, TezConfiguration tezConf) {
        this(name, tezConf, tezConf.getBoolean("tez.am.mode.session", TezConfiguration.TEZ_AM_SESSION_MODE_DEFAULT));
    }

    @InterfaceAudience.Private
    TezClient(String name, TezConfiguration tezConf, @Nullable Map<String, LocalResource> localResources, @Nullable Credentials credentials) {
        this(name, tezConf, tezConf.getBoolean("tez.am.mode.session", TezConfiguration.TEZ_AM_SESSION_MODE_DEFAULT), localResources, credentials);
    }

    private TezClient(String name, TezConfiguration tezConf, boolean isSession) {
        this(name, tezConf, isSession, null, null);
    }

    @InterfaceAudience.Private
    protected TezClient(String name, TezConfiguration tezConf, boolean isSession, @Nullable Map<String, LocalResource> localResources, @Nullable Credentials credentials) {
        this.clientName = name;
        this.isSession = isSession;
        tezConf.setBoolean("tez.am.mode.session", isSession);
        this.amConfig = new AMConfiguration(tezConf, localResources, credentials);
        this.apiVersionInfo = new TezApiVersionInfo();
        LOG.info((Object)("Tez Client Version: " + this.apiVersionInfo.toString()));
    }

    public static TezClient create(String name, TezConfiguration tezConf) {
        return new TezClient(name, tezConf);
    }

    public static TezClient create(String name, TezConfiguration tezConf, @Nullable Map<String, LocalResource> localFiles, @Nullable Credentials credentials) {
        return new TezClient(name, tezConf, localFiles, credentials);
    }

    public static TezClient create(String name, TezConfiguration tezConf, boolean isSession) {
        return new TezClient(name, tezConf, isSession);
    }

    public static TezClient create(String name, TezConfiguration tezConf, boolean isSession, @Nullable Map<String, LocalResource> localFiles, @Nullable Credentials credentials) {
        return new TezClient(name, tezConf, isSession, localFiles, credentials);
    }

    public synchronized void addAppMasterLocalFiles(Map<String, LocalResource> localFiles) {
        Preconditions.checkNotNull(localFiles);
        if (this.isSession && this.sessionStarted) {
            this.additionalLocalResources.putAll(localFiles);
        }
        this.amConfig.addAMLocalResources(localFiles);
    }

    public synchronized void clearAppMasterLocalFiles() {
        this.amConfig.clearAMLocalResources();
    }

    public synchronized void setAppMasterCredentials(Credentials credentials) {
        Preconditions.checkState((!this.sessionStarted ? 1 : 0) != 0, (Object)"Credentials cannot be set after the session App Master has been started");
        this.amConfig.setCredentials(credentials);
    }

    public synchronized void start() throws TezException, IOException {
        this.amConfig.setYarnConfiguration(new YarnConfiguration((Configuration)this.amConfig.getTezConfiguration()));
        this.frameworkClient = this.createFrameworkClient();
        this.frameworkClient.init(this.amConfig.getTezConfiguration(), this.amConfig.getYarnConfiguration());
        this.frameworkClient.start();
        if (this.isSession) {
            LOG.info((Object)"Session mode. Starting session.");
            TezClientUtils.processTezLocalCredentialsFile(this.sessionCredentials, this.amConfig.getTezConfiguration());
            Map<String, LocalResource> tezJarResources = this.getTezJarResources(this.sessionCredentials);
            this.clientTimeout = this.amConfig.getTezConfiguration().getInt("tez.session.client.timeout.secs", 120);
            try {
                if (this.sessionAppId == null) {
                    this.sessionAppId = this.createApplication();
                }
                TezClientUtils.createSessionToken(this.sessionAppId.toString(), this.jobTokenSecretManager, this.sessionCredentials);
                ApplicationSubmissionContext appContext = TezClientUtils.createApplicationSubmissionContext(this.sessionAppId, null, this.clientName, this.amConfig, tezJarResources, this.sessionCredentials, this.usingTezArchiveDeploy, this.apiVersionInfo);
                if (!this.amConfig.getTezConfiguration().getBoolean("tez.dag.recovery.enabled", true)) {
                    appContext.setMaxAppAttempts(1);
                }
                this.frameworkClient.submitApplication(appContext);
                ApplicationReport appReport = this.frameworkClient.getApplicationReport(this.sessionAppId);
                LOG.info((Object)("The url to track the Tez Session: " + appReport.getTrackingUrl()));
                this.sessionStarted = true;
            }
            catch (YarnException e) {
                throw new TezException(e);
            }
        }
    }

    public synchronized DAGClient submitDAG(DAG dag) throws TezException, IOException {
        if (this.isSession) {
            return this.submitDAGSession(dag);
        }
        return this.submitDAGApplication(dag);
    }

    private DAGClient submitDAGSession(DAG dag) throws TezException, IOException {
        Preconditions.checkState((this.isSession ? 1 : 0) != 0, (Object)"submitDAG with additional resources applies to only session mode. In non-session mode please specify all resources in the initial configuration");
        this.verifySessionStateForSubmission();
        String dagId = null;
        LOG.info((Object)("Submitting dag to TezSession, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId + ", dagName=" + dag.getName()));
        if (!this.additionalLocalResources.isEmpty()) {
            for (LocalResource lr : this.additionalLocalResources.values()) {
                Preconditions.checkArgument((lr.getType() == LocalResourceType.FILE ? 1 : 0) != 0, (Object)("LocalResourceType: " + lr.getType() + " is not supported, only " + LocalResourceType.FILE + " is supported"));
            }
        }
        Map<String, LocalResource> tezJarResources = this.getTezJarResources(this.sessionCredentials);
        DAGProtos.DAGPlan dagPlan = TezClientUtils.prepareAndCreateDAGPlan(dag, this.amConfig, tezJarResources, this.usingTezArchiveDeploy, this.sessionCredentials);
        DAGClientAMProtocolRPC.SubmitDAGRequestProto.Builder requestBuilder = DAGClientAMProtocolRPC.SubmitDAGRequestProto.newBuilder();
        requestBuilder.setDAGPlan(dagPlan).build();
        if (!this.additionalLocalResources.isEmpty()) {
            requestBuilder.setAdditionalAmResources(DagTypeConverters.convertFromLocalResources(this.additionalLocalResources));
        }
        this.additionalLocalResources.clear();
        DAGClientAMProtocolBlockingPB proxy = null;
        try {
            proxy = this.waitForProxy();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while trying to create a connection to the AM", e);
        }
        if (proxy == null) {
            try {
                LOG.warn((Object)"DAG submission to session timed out, stopping session");
                this.stop();
            }
            catch (Throwable t) {
                LOG.info((Object)"Got an exception when trying to stop session", t);
            }
            throw new DAGSubmissionTimedOut("Could not submit DAG to Tez Session, timed out after " + this.clientTimeout + " seconds");
        }
        try {
            DAGClientAMProtocolRPC.SubmitDAGResponseProto response = proxy.submitDAG(null, requestBuilder.build());
            if (response != null) {
                dagId = response.getDagId();
            }
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
        LOG.info((Object)("Submitted dag to TezSession, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId + ", dagName=" + dag.getName()));
        return new DAGClientImpl(this.sessionAppId, dagId, this.amConfig.getTezConfiguration(), this.frameworkClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws TezException, IOException {
        block10: {
            try {
                if (!this.sessionStarted) break block10;
                LOG.info((Object)("Shutting down Tez Session, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId));
                this.sessionStopped = true;
                boolean sessionShutdownSuccessful = false;
                try {
                    DAGClientAMProtocolBlockingPB proxy = this.getSessionAMProxy(this.sessionAppId);
                    if (proxy != null) {
                        DAGClientAMProtocolRPC.ShutdownSessionRequestProto request = DAGClientAMProtocolRPC.ShutdownSessionRequestProto.newBuilder().build();
                        proxy.shutdownSession(null, request);
                        sessionShutdownSuccessful = true;
                    }
                }
                catch (TezException e) {
                    LOG.info((Object)"Failed to shutdown Tez Session via proxy", (Throwable)e);
                }
                catch (ServiceException e) {
                    LOG.info((Object)"Failed to shutdown Tez Session via proxy", (Throwable)e);
                }
                if (sessionShutdownSuccessful) break block10;
                LOG.info((Object)("Could not connect to AM, killing session via YARN, sessionName=" + this.clientName + ", applicationId=" + this.sessionAppId));
                try {
                    this.frameworkClient.killApplication(this.sessionAppId);
                }
                catch (YarnException e) {
                    throw new TezException(e);
                }
            }
            finally {
                if (this.frameworkClient != null) {
                    this.frameworkClient.close();
                }
            }
        }
    }

    public String getClientName() {
        return this.clientName;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized ApplicationId getAppMasterApplicationId() {
        if (this.isSession) {
            return this.sessionAppId;
        }
        return this.lastSubmittedAppId;
    }

    public synchronized TezAppMasterStatus getAppMasterStatus() throws TezException, IOException {
        ApplicationId appId = null;
        appId = this.isSession ? this.sessionAppId : this.lastSubmittedAppId;
        Preconditions.checkState((appId != null ? 1 : 0) != 0, (Object)"Cannot get status without starting an application");
        try {
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(appId);
            switch (appReport.getYarnApplicationState()) {
                case NEW: 
                case NEW_SAVING: 
                case ACCEPTED: 
                case SUBMITTED: {
                    return TezAppMasterStatus.INITIALIZING;
                }
                case FINISHED: 
                case FAILED: 
                case KILLED: {
                    return TezAppMasterStatus.SHUTDOWN;
                }
                case RUNNING: {
                    if (!this.isSession) {
                        return TezAppMasterStatus.RUNNING;
                    }
                    try {
                        DAGClientAMProtocolBlockingPB proxy = this.getSessionAMProxy(appId);
                        if (proxy == null) {
                            return TezAppMasterStatus.INITIALIZING;
                        }
                        DAGClientAMProtocolRPC.GetAMStatusResponseProto response = proxy.getAMStatus(null, DAGClientAMProtocolRPC.GetAMStatusRequestProto.newBuilder().build());
                        return DagTypeConverters.convertTezSessionStatusFromProto(response.getStatus());
                    }
                    catch (TezException e) {
                        LOG.info((Object)"Failed to retrieve AM Status via proxy", (Throwable)e);
                        break;
                    }
                    catch (ServiceException e) {
                        LOG.info((Object)"Failed to retrieve AM Status via proxy", (Throwable)e);
                    }
                }
            }
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return TezAppMasterStatus.INITIALIZING;
    }

    @InterfaceStability.Unstable
    public synchronized void preWarm(PreWarmVertex preWarmVertex) throws TezException, IOException {
        if (!this.isSession) {
            return;
        }
        this.verifySessionStateForSubmission();
        DAG dag = org.apache.tez.dag.api.DAG.create("TezPreWarmDAG_" + this.preWarmDAGCounter++);
        dag.addVertex(preWarmVertex);
        try {
            this.waitTillReady();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for AM to become available", e);
        }
        this.submitDAG(dag);
    }

    @InterfaceStability.Evolving
    public synchronized void waitTillReady() throws IOException, TezException, InterruptedException {
        if (!this.isSession) {
            return;
        }
        this.verifySessionStateForSubmission();
        while (true) {
            TezAppMasterStatus status;
            if ((status = this.getAppMasterStatus()).equals((Object)TezAppMasterStatus.SHUTDOWN)) {
                throw new SessionNotRunning("TezSession has already shutdown");
            }
            if (status.equals((Object)TezAppMasterStatus.READY)) {
                return;
            }
            Thread.sleep(500L);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected FrameworkClient createFrameworkClient() {
        return FrameworkClient.createFrameworkClient(this.amConfig.getTezConfiguration());
    }

    @VisibleForTesting
    protected DAGClientAMProtocolBlockingPB getSessionAMProxy(ApplicationId appId) throws TezException, IOException {
        return TezClientUtils.getSessionAMProxy(this.frameworkClient, (Configuration)this.amConfig.getYarnConfiguration(), appId);
    }

    private DAGClientAMProtocolBlockingPB waitForProxy() throws IOException, TezException, InterruptedException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.clientTimeout * 1000L;
        DAGClientAMProtocolBlockingPB proxy = null;
        while ((proxy = this.getSessionAMProxy(this.sessionAppId)) == null) {
            Thread.sleep(100L);
            if (this.clientTimeout == -1L || System.currentTimeMillis() <= endTime) continue;
            break;
        }
        return proxy;
    }

    private void verifySessionStateForSubmission() throws SessionNotRunning {
        Preconditions.checkState((boolean)this.isSession, (Object)"Invalid without session mode");
        if (!this.sessionStarted) {
            throw new SessionNotRunning("Session not started");
        }
        if (this.sessionStopped) {
            throw new SessionNotRunning("Session stopped");
        }
    }

    private DAGClient submitDAGApplication(DAG dag) throws TezException, IOException {
        ApplicationId appId = this.createApplication();
        return this.submitDAGApplication(appId, dag);
    }

    @InterfaceAudience.Private
    DAGClient submitDAGApplication(ApplicationId appId, DAG dag) throws TezException, IOException {
        LOG.info((Object)("Submitting DAG application with id: " + appId));
        try {
            Credentials credentials = this.amConfig.getCredentials();
            if (credentials == null) {
                credentials = new Credentials();
            }
            TezClientUtils.processTezLocalCredentialsFile(credentials, this.amConfig.getTezConfiguration());
            TezClientUtils.createSessionToken(appId.toString(), this.jobTokenSecretManager, credentials);
            Map<String, LocalResource> tezJarResources = this.getTezJarResources(credentials);
            ApplicationSubmissionContext appContext = TezClientUtils.createApplicationSubmissionContext(appId, dag, dag.getName(), this.amConfig, tezJarResources, credentials, this.usingTezArchiveDeploy, this.apiVersionInfo);
            LOG.info((Object)("Submitting DAG to YARN, applicationId=" + appId + ", dagName=" + dag.getName()));
            this.frameworkClient.submitApplication(appContext);
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(appId);
            LOG.info((Object)("The url to track the Tez AM: " + appReport.getTrackingUrl()));
            this.lastSubmittedAppId = appId;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return TezClient.getDAGClient(appId, this.amConfig.getTezConfiguration(), this.frameworkClient);
    }

    private ApplicationId createApplication() throws TezException, IOException {
        try {
            return this.frameworkClient.createApplication().getNewApplicationResponse().getApplicationId();
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    private synchronized Map<String, LocalResource> getTezJarResources(Credentials credentials) throws IOException {
        if (this.cachedTezJarResources == null) {
            this.cachedTezJarResources = new HashMap<String, LocalResource>();
            this.usingTezArchiveDeploy = TezClientUtils.setupTezJarsLocalResources(this.amConfig.getTezConfiguration(), credentials, this.cachedTezJarResources);
        }
        return this.cachedTezJarResources;
    }

    @InterfaceAudience.Private
    static DAGClient getDAGClient(ApplicationId appId, TezConfiguration tezConf, FrameworkClient frameworkClient) throws IOException, TezException {
        return new DAGClientImpl(appId, TezClient.getDefaultTezDAGID(appId), tezConf, frameworkClient);
    }

    private static String getDefaultTezDAGID(ApplicationId applicationId) {
        return DAG + '_' + applicationId.getClusterTimestamp() + '_' + tezAppIdFormat.get().format(applicationId.getId()) + '_' + tezDagIdFormat.get().format(1L);
    }
}

