/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.TezYarnClient;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezConfiguration;

@InterfaceAudience.Private
public abstract class FrameworkClient {
    public static FrameworkClient createFrameworkClient(TezConfiguration tezConf) {
        boolean isLocal = tezConf.getBoolean("tez.local.mode", false);
        if (isLocal) {
            return (FrameworkClient)ReflectionUtils.createClazzInstance("org.apache.tez.client.LocalClient");
        }
        return new TezYarnClient(YarnClient.createYarnClient());
    }

    public abstract void init(TezConfiguration var1, YarnConfiguration var2);

    public abstract void start();

    public abstract void stop();

    public abstract void close() throws IOException;

    public abstract YarnClientApplication createApplication() throws YarnException, IOException;

    public abstract ApplicationId submitApplication(ApplicationSubmissionContext var1) throws YarnException, IOException;

    public abstract void killApplication(ApplicationId var1) throws YarnException, IOException;

    public abstract ApplicationReport getApplicationReport(ApplicationId var1) throws YarnException, IOException;
}

