/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.BatchInfo;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobSet$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;

@ScalaSignature(bytes="\u0006\u0001\t\u001da!B\u0001\u0003\u0001\u0012a!A\u0002&pEN+GO\u0003\u0002\u0004\t\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014-A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"A\u0004\u000b\n\u0005Uy!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001d]I!\u0001G\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011i\u0001!Q3A\u0005\u0002q\tA\u0001^5nK\u000e\u0001Q#A\u000f\u0011\u0005yyR\"\u0001\u0003\n\u0005\u0001\"!\u0001\u0002+j[\u0016D\u0001B\t\u0001\u0003\u0012\u0003\u0006I!H\u0001\u0006i&lW\r\t\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005!!n\u001c2t+\u00051\u0003cA\u00140e9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003Wm\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u00059z\u0011a\u00029bG.\fw-Z\u0005\u0003aE\u00121aU3r\u0015\tqs\u0002\u0005\u00024i5\t!!\u0003\u00026\u0005\t\u0019!j\u001c2\t\u0011]\u0002!\u0011#Q\u0001\n\u0019\nQA[8cg\u0002B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tAO\u0001\u0014gR\u0014X-Y7JIR{\u0017J\u001c9vi&sgm\\\u000b\u0002wA!Ah\u0010\"F\u001d\tqQ(\u0003\u0002?\u001f\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\u00075\u000b\u0007O\u0003\u0002?\u001fA\u0011abQ\u0005\u0003\t>\u00111!\u00138u!\t\u0019d)\u0003\u0002H\u0005\ty1\u000b\u001e:fC6Le\u000e];u\u0013:4w\u000e\u0003\u0005J\u0001\tE\t\u0015!\u0003<\u0003Q\u0019HO]3b[&#Gk\\%oaV$\u0018J\u001c4pA!)1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"B!\u0014(P!B\u00111\u0007\u0001\u0005\u00065)\u0003\r!\b\u0005\u0006I)\u0003\rA\n\u0005\bs)\u0003\n\u00111\u0001<\u0011\u001d\u0011\u0006A1A\u0005\nM\u000ba\"\u001b8d_6\u0004H.\u001a;f\u0015>\u00147/F\u0001U!\r)&LM\u0007\u0002-*\u0011q\u000bW\u0001\b[V$\u0018M\u00197f\u0015\tIv\"\u0001\u0006d_2dWm\u0019;j_:L!a\u0017,\u0003\u000f!\u000b7\u000f[*fi\"1Q\f\u0001Q\u0001\nQ\u000bq\"\u001b8d_6\u0004H.\u001a;f\u0015>\u00147\u000f\t\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u00039\u0019XOY7jgNLwN\u001c+j[\u0016,\u0012!\u0019\t\u0003\u001d\tL!aY\b\u0003\t1{gn\u001a\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002\u001fM,(-\\5tg&|g\u000eV5nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001-A\nqe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lW\rC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002/A\u0014xnY3tg&twm\u0015;beR$\u0016.\\3`I\u0015\fHCA6o!\tqA.\u0003\u0002n\u001f\t!QK\\5u\u0011\u001dy\u0007.!AA\u0002\u0005\f1\u0001\u001f\u00132\u0011\u0019\t\b\u0001)Q\u0005C\u0006!\u0002O]8dKN\u001c\u0018N\\4Ti\u0006\u0014H\u000fV5nK\u0002Bqa\u001d\u0001A\u0002\u0013%\u0001-A\tqe>\u001cWm]:j]\u001e,e\u000e\u001a+j[\u0016Dq!\u001e\u0001A\u0002\u0013%a/A\u000bqe>\u001cWm]:j]\u001e,e\u000e\u001a+j[\u0016|F%Z9\u0015\u0005-<\bbB8u\u0003\u0003\u0005\r!\u0019\u0005\u0007s\u0002\u0001\u000b\u0015B1\u0002%A\u0014xnY3tg&tw-\u00128e)&lW\r\t\u0005\u0006w\u0002!\t\u0001`\u0001\u000fQ\u0006tG\r\\3K_\n\u001cF/\u0019:u)\tYW\u0010C\u0003\u007fu\u0002\u0007!'A\u0002k_\nDq!!\u0001\u0001\t\u0003\t\u0019!A\niC:$G.\u001a&pE\u000e{W\u000e\u001d7fi&|g\u000eF\u0002l\u0003\u000bAQA`@A\u0002IBq!!\u0003\u0001\t\u0003\tY!\u0001\u0006iCN\u001cF/\u0019:uK\u0012,\"!!\u0004\u0011\u00079\ty!C\u0002\u0002\u0012=\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0016\u0001!\t!a\u0003\u0002\u0019!\f7oQ8na2,G/\u001a3\t\r\u0005e\u0001\u0001\"\u0001a\u0003=\u0001(o\\2fgNLgn\u001a#fY\u0006L\bBBA\u000f\u0001\u0011\u0005\u0001-\u0001\u0006u_R\fG\u000eR3mCfDq!!\t\u0001\t\u0003\t\u0019#A\u0006u_\n\u000bGo\u00195J]\u001a|WCAA\u0013!\r\u0019\u0014qE\u0005\u0004\u0003S\u0011!!\u0003\"bi\u000eD\u0017J\u001c4p\u0011%\ti\u0003AA\u0001\n\u0003\ty#\u0001\u0003d_BLHcB'\u00022\u0005M\u0012Q\u0007\u0005\t5\u0005-\u0002\u0013!a\u0001;!AA%a\u000b\u0011\u0002\u0003\u0007a\u0005\u0003\u0005:\u0003W\u0001\n\u00111\u0001<\u0011%\tI\u0004AI\u0001\n\u0003\tY$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u\"fA\u000f\u0002@-\u0012\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003%)hn\u00195fG.,GMC\u0002\u0002L=\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty%!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002T\u0001\t\n\u0011\"\u0001\u0002V\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA,U\r1\u0013q\b\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0003;\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002`)\u001a1(a\u0010\t\u0013\u0005\r\u0004!!A\u0005B\u0005\u0015\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014\u0001\u00027b]\u001eT!!!\u001d\u0002\t)\fg/Y\u0005\u0005\u0003k\nYG\u0001\u0004TiJLgn\u001a\u0005\n\u0003s\u0002\u0011\u0011!C\u0001\u0003w\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u0011\u0005\n\u0003\u007f\u0002\u0011\u0011!C\u0001\u0003\u0003\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0006%\u0005c\u0001\b\u0002\u0006&\u0019\u0011qQ\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005p\u0003{\n\t\u00111\u0001C\u0011%\ti\tAA\u0001\n\u0003\ny)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\n\u0005\u0004\u0002\u0014\u0006U\u00151Q\u0007\u00021&\u0019\u0011q\u0013-\u0003\u0011%#XM]1u_JD\u0011\"a'\u0001\u0003\u0003%\t!!(\u0002\u0011\r\fg.R9vC2$B!!\u0004\u0002 \"Iq.!'\u0002\u0002\u0003\u0007\u00111\u0011\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003K\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u0005\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00131V\u0001\ti>\u001cFO]5oOR\u0011\u0011q\r\u0005\n\u0003_\u0003\u0011\u0011!C!\u0003c\u000ba!Z9vC2\u001cH\u0003BA\u0007\u0003gC\u0011b\\AW\u0003\u0003\u0005\r!a!\b\u0015\u0005]&!!A\t\u0002\u0011\tI,\u0001\u0004K_\n\u001cV\r\u001e\t\u0004g\u0005mf!C\u0001\u0003\u0003\u0003E\t\u0001BA_'\u0015\tY,a0\u0017!!\t\t-a2\u001eMmjUBAAb\u0015\r\t)mD\u0001\beVtG/[7f\u0013\u0011\tI-a1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004L\u0003w#\t!!4\u0015\u0005\u0005e\u0006BCAU\u0003w\u000b\t\u0011\"\u0012\u0002,\"Q\u00111[A^\u0003\u0003%\t)!6\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f5\u000b9.!7\u0002\\\"1!$!5A\u0002uAa\u0001JAi\u0001\u00041\u0003\u0002C\u001d\u0002RB\u0005\t\u0019A\u001e\t\u0015\u0005}\u00171XA\u0001\n\u0003\u000b\t/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0018q\u001e\t\u0006\u001d\u0005\u0015\u0018\u0011^\u0005\u0004\u0003O|!AB(qi&|g\u000e\u0005\u0004\u000f\u0003WlbeO\u0005\u0004\u0003[|!A\u0002+va2,7\u0007C\u0005\u0002r\u0006u\u0017\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005U\u00181XI\u0001\n\u0003\ti&A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\tI0a/\u0012\u0002\u0013\u0005\u0011QL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005u\u00181XA\u0001\n\u0013\ty0A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0001!\u0011\tIGa\u0001\n\t\t\u0015\u00111\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class JobSet
implements Product,
Serializable {
    private final Time time;
    private final Seq<Job> jobs;
    private final Map<Object, StreamInputInfo> streamIdToInputInfo;
    private final HashSet<Job> incompleteJobs;
    private final long submissionTime;
    private long processingStartTime;
    private long processingEndTime;

    public static Map<Object, StreamInputInfo> $lessinit$greater$default$3() {
        return JobSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<Object, StreamInputInfo> apply$default$3() {
        return JobSet$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Time, Seq<Job>, Map<Object, StreamInputInfo>>, JobSet> tupled() {
        return JobSet$.MODULE$.tupled();
    }

    public static Function1<Time, Function1<Seq<Job>, Function1<Map<Object, StreamInputInfo>, JobSet>>> curried() {
        return JobSet$.MODULE$.curried();
    }

    public Time time() {
        return this.time;
    }

    public Seq<Job> jobs() {
        return this.jobs;
    }

    public Map<Object, StreamInputInfo> streamIdToInputInfo() {
        return this.streamIdToInputInfo;
    }

    private HashSet<Job> incompleteJobs() {
        return this.incompleteJobs;
    }

    private long submissionTime() {
        return this.submissionTime;
    }

    private long processingStartTime() {
        return this.processingStartTime;
    }

    private void processingStartTime_$eq(long x$1) {
        this.processingStartTime = x$1;
    }

    private long processingEndTime() {
        return this.processingEndTime;
    }

    private void processingEndTime_$eq(long x$1) {
        this.processingEndTime = x$1;
    }

    public void handleJobStart(Job job) {
        if (this.processingStartTime() < 0L) {
            this.processingStartTime_$eq(System.currentTimeMillis());
        }
    }

    public void handleJobCompletion(Job job) {
        this.incompleteJobs().$minus$eq((Object)job);
        if (this.hasCompleted()) {
            this.processingEndTime_$eq(System.currentTimeMillis());
        }
    }

    public boolean hasStarted() {
        return this.processingStartTime() > 0L;
    }

    public boolean hasCompleted() {
        return this.incompleteJobs().isEmpty();
    }

    public long processingDelay() {
        return this.processingEndTime() - this.processingStartTime();
    }

    public long totalDelay() {
        return this.processingEndTime() - this.time().milliseconds();
    }

    /*
     * WARNING - void declaration
     */
    public BatchInfo toBatchInfo() {
        void var2_2;
        Map failureReasons = this.hasCompleted() ? ((TraversableOnce)((TraversableLike)this.jobs().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Job x$1) {
                return x$1.result().isFailure();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Job job) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)job.outputOpId()), (Object)Utils$.MODULE$.exceptionString(((Failure)job.result()).exception()));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()) : Predef$.MODULE$.Map().empty();
        BatchInfo binfo = new BatchInfo(this.time(), this.streamIdToInputInfo(), this.submissionTime(), (Option<Object>)(this.processingStartTime() >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)this.processingStartTime())) : None$.MODULE$), (Option<Object>)(this.processingEndTime() >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)this.processingEndTime())) : None$.MODULE$));
        binfo.setFailureReason((Map<Object, String>)failureReasons);
        return var2_2;
    }

    public JobSet copy(Time time, Seq<Job> jobs, Map<Object, StreamInputInfo> streamIdToInputInfo) {
        return new JobSet(time, jobs, streamIdToInputInfo);
    }

    public Time copy$default$1() {
        return this.time();
    }

    public Seq<Job> copy$default$2() {
        return this.jobs();
    }

    public Map<Object, StreamInputInfo> copy$default$3() {
        return this.streamIdToInputInfo();
    }

    public String productPrefix() {
        return "JobSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.streamIdToInputInfo();
                break;
            }
            case 1: {
                object = this.jobs();
                break;
            }
            case 0: {
                object = this.time();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JobSet;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JobSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        JobSet jobSet = (JobSet)x$1;
        Time time = this.time();
        Time time2 = jobSet.time();
        if (time == null) {
            if (time2 != null) {
                return false;
            }
        } else if (!((Object)time).equals(time2)) return false;
        Seq<Job> seq = this.jobs();
        Seq<Job> seq2 = jobSet.jobs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Map<Object, StreamInputInfo> map2 = this.streamIdToInputInfo();
        Map<Object, StreamInputInfo> map3 = jobSet.streamIdToInputInfo();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        if (!jobSet.canEqual(this)) return false;
        return true;
    }

    public JobSet(Time time, Seq<Job> jobs, Map<Object, StreamInputInfo> streamIdToInputInfo) {
        this.time = time;
        this.jobs = jobs;
        this.streamIdToInputInfo = streamIdToInputInfo;
        Product.class.$init$((Product)this);
        this.incompleteJobs = new HashSet();
        this.submissionTime = System.currentTimeMillis();
        this.processingStartTime = -1L;
        this.processingEndTime = -1L;
        ((IterableLike)jobs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Job, Object> x0$1) {
                Tuple2<Job, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Job job = (Job)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    job.setOutputOpId(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.incompleteJobs().$plus$plus$eq(jobs);
    }
}

