/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$ReceiverState$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%eAB\u0001\u0003\u0003\u0003!AB\u0001\nSK\u000e,\u0017N^3s'V\u0004XM\u001d<jg>\u0014(BA\u0002\u0005\u0003!\u0011XmY3jm\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q)R\"\u0001\u0004\n\u0005Y1!a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u00053\r\u0001\u0001G\u0001\u000e!!\rYBDH\u0007\u0002\u0005%\u0011QD\u0001\u0002\t%\u0016\u001cW-\u001b<feB\u0011q\u0004\t\u0007\u0001\t%\ts#!A\u0001\u0002\u000b\u0005!EA\u0002`IE\n\"a\t\u0014\u0011\u00059!\u0013BA\u0013\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0014\n\u0005!z!aA!os\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0003d_:4\u0007C\u0001\u000b-\u0013\ticAA\u0005Ta\u0006\u00148nQ8oM\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!\r\u001a8!\tY\u0002\u0001C\u0003\u0004]\u0001\u00071\u0007\r\u00025mA\u00191\u0004H\u001b\u0011\u0005}1D!C\u00113\u0003\u0003\u0005\tQ!\u0001#\u0011\u0015Qc\u00061\u0001,\u000f\u0015I\u0004\u0001#\u0001;\u00035\u0011VmY3jm\u0016\u00148\u000b^1uKB\u00111\bP\u0007\u0002\u0001\u0019)Q\b\u0001E\u0001}\ti!+Z2fSZ,'o\u0015;bi\u0016\u001c\"\u0001P \u0011\u00059\u0001\u0015BA!\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b=bD\u0011A\"\u0015\u0003i*A!\u0012\u001f\u0001\r\ny1\t[3dWB|\u0017N\u001c;Ti\u0006$X\r\u0005\u0002H\u00116\tA(\u0003\u0002J\u0001\n)a+\u00197vK\"91\n\u0010b\u0001\n\u0003a\u0015aC%oSRL\u0017\r\\5{K\u0012,\u0012A\u0012\u0005\u0007\u001dr\u0002\u000b\u0011\u0002$\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u000fAc$\u0019!C\u0001\u0019\u000691\u000b^1si\u0016$\u0007B\u0002*=A\u0003%a)\u0001\u0005Ti\u0006\u0014H/\u001a3!\u0011\u001d!FH1A\u0005\u00021\u000bqa\u0015;paB,G\r\u0003\u0004Wy\u0001\u0006IAR\u0001\t'R|\u0007\u000f]3eA!9\u0001\f\u0001b\u0001\n\u0013I\u0016A\u00064viV\u0014X-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!X\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002`9\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\r\u0005\u0004\u0001\u0015!\u0003[\u0003]1W\u000f^;sK\u0016CXmY;uS>t7i\u001c8uKb$\b\u0005C\u0004d\u0001\t\u0007I\u0011\u00033\u0002\u0011M$(/Z1n\u0013\u0012,\u0012!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\u0007%sG\u000f\u0003\u0004j\u0001\u0001\u0006I!Z\u0001\ngR\u0014X-Y7JI\u0002Bqa\u001b\u0001C\u0002\u0013%A.A\u0005ti>\u0004H*\u0019;dQV\tQ\u000e\u0005\u0002oi6\tqN\u0003\u0002^a*\u0011\u0011O]\u0001\u0005kRLGNC\u0001t\u0003\u0011Q\u0017M^1\n\u0005U|'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\u0007o\u0002\u0001\u000b\u0011B7\u0002\u0015M$x\u000e\u001d'bi\u000eD\u0007\u0005C\u0004z\u0001\t\u0007I\u0011\u00023\u0002'\u0011,g-Y;miJ+7\u000f^1si\u0012+G.Y=\t\rm\u0004\u0001\u0015!\u0003f\u0003Q!WMZ1vYR\u0014Vm\u001d;beR$U\r\\1zA!1Q\u0010\u0001C\u0001\ty\f1cZ3u\u0007V\u0014(/\u001a8u%\u0006$X\rT5nSR,\u0012a \t\u0004\u001d\u0005\u0005\u0011bAA\u0002\u001f\t!Aj\u001c8h\u0011%\t9\u0001\u0001a\u0001\n#\tI!A\u0007ti>\u0004\b/\u001b8h\u000bJ\u0014xN]\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u001e9!\u0011qBA\r\u001d\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b1\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u00037y\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003?\t\tCA\u0005UQJ|w/\u00192mK*\u0019\u00111D\b\t\u0013\u0005\u0015\u0002\u00011A\u0005\u0012\u0005\u001d\u0012!E:u_B\u0004\u0018N\\4FeJ|'o\u0018\u0013fcR!\u0011\u0011FA\u0018!\rq\u00111F\u0005\u0004\u0003[y!\u0001B+oSRD!\"!\r\u0002$\u0005\u0005\t\u0019AA\u0006\u0003\rAH%\r\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\f\u0005q1\u000f^8qa&tw-\u0012:s_J\u0004\u0003\u0006BA\u001a\u0003s\u00012ADA\u001e\u0013\r\tid\u0004\u0002\tm>d\u0017\r^5mK\"Q\u0011\u0011\t\u0001A\u0002\u0013\u0005A!a\u0011\u0002\u001bI,7-Z5wKJ\u001cF/\u0019;f+\t\t)\u0005E\u0002\u0002H!s!a\u000f\u001d\t\u0015\u0005-\u0003\u00011A\u0005\u0002\u0011\ti%A\tsK\u000e,\u0017N^3s'R\fG/Z0%KF$B!!\u000b\u0002P!Q\u0011\u0011GA%\u0003\u0003\u0005\r!!\u0012\t\u0011\u0005M\u0003\u0001)Q\u0005\u0003\u000b\naB]3dK&4XM]*uCR,\u0007\u0005\u000b\u0003\u0002R\u0005e\u0002bBA-\u0001\u0019\u0005\u00111L\u0001\u000baV\u001c\bnU5oO2,G\u0003BA\u0015\u0003;Bq!a\u0018\u0002X\u0001\u0007a%\u0001\u0003eCR\f\u0007bBA2\u0001\u0019\u0005\u0011QM\u0001\naV\u001c\bNQ=uKN$\u0002\"!\u000b\u0002h\u0005]\u0014\u0011\u0011\u0005\t\u0003S\n\t\u00071\u0001\u0002l\u0005)!-\u001f;fgB!\u0011QNA:\u001b\t\tyGC\u0002\u0002rI\f1A\\5p\u0013\u0011\t)(a\u001c\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0005\u0002z\u0005\u0005\u0004\u0019AA>\u0003Ay\u0007\u000f^5p]\u0006dW*\u001a;bI\u0006$\u0018\r\u0005\u0003\u000f\u0003{2\u0013bAA@\u001f\t1q\n\u001d;j_:D\u0001\"a!\u0002b\u0001\u0007\u0011QQ\u0001\u0010_B$\u0018n\u001c8bY\ncwnY6JIB)a\"! \u0002\bB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e\u001a\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u0012\u0006-%!D*ue\u0016\fWN\u00117pG.LE\rC\u0004\u0002\u0016\u00021\t!a&\u0002\u0019A,8\u000f[%uKJ\fGo\u001c:\u0015\u0011\u0005%\u0012\u0011TAV\u0003[C\u0001\"a'\u0002\u0014\u0002\u0007\u0011QT\u0001\tSR,'/\u0019;peB\"\u0011qTAT!\u0019\ti!!)\u0002&&!\u00111UA\u0011\u0005!IE/\u001a:bi>\u0014\bcA\u0010\u0002(\u0012Y\u0011\u0011VAM\u0003\u0003\u0005\tQ!\u0001#\u0005\ryFE\r\u0005\t\u0003s\n\u0019\n1\u0001\u0002|!A\u00111QAJ\u0001\u0004\t)\tC\u0004\u00022\u00021\t!a-\u0002\u001fA,8\u000f[!se\u0006L()\u001e4gKJ$\u0002\"!\u000b\u00026\u0006E\u00171\u001b\u0005\t\u0003o\u000by\u000b1\u0001\u0002:\u0006Y\u0011M\u001d:bs\n+hMZ3sa\u0011\tY,!4\u0011\r\u0005u\u0016qYAf\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b|\u0011AC2pY2,7\r^5p]&!\u0011\u0011ZA`\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007}\ti\rB\u0006\u0002P\u0006U\u0016\u0011!A\u0001\u0006\u0003\u0011#aA0%g!A\u0011\u0011PAX\u0001\u0004\tY\b\u0003\u0005\u0002\u0004\u0006=\u0006\u0019AAC\u0011\u001d\t9\u000e\u0001D\u0001\u00033\fAc\u0019:fCR,'\t\\8dW\u001e+g.\u001a:bi>\u0014H\u0003BAn\u0003C\u00042aGAo\u0013\r\tyN\u0001\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0011!\t\u0019/!6A\u0002\u0005\u0015\u0018A\u00062m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\u0011\u0007m\t9/C\u0002\u0002j\n\u0011aC\u00117pG.<UM\\3sCR|'\u000fT5ti\u0016tWM\u001d\u0005\b\u0003[\u0004a\u0011AAx\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\r\u0005%\u0012\u0011\u001fB\u0002\u0011!\t\u00190a;A\u0002\u0005U\u0018aB7fgN\fw-\u001a\t\u0005\u0003o\fiPD\u0002\u000f\u0003sL1!a?\u0010\u0003\u0019\u0001&/\u001a3fM&!\u0011q B\u0001\u0005\u0019\u0019FO]5oO*\u0019\u00111`\b\t\u0011\t\u0015\u00111\u001ea\u0001\u0003\u0017\t\u0011\u0002\u001e5s_^\f'\r\\3\t\u000f\t%\u0001\u0001\"\u0005\u0003\f\u00059qN\\*uCJ$HCAA\u0015\u0011\u001d\u0011y\u0001\u0001C\t\u0005#\taa\u001c8Ti>\u0004HCBA\u0015\u0005'\u0011)\u0002\u0003\u0005\u0002t\n5\u0001\u0019AA{\u0011!\u00119B!\u0004A\u0002\te\u0011!B3se>\u0014\b#\u0002\b\u0002~\u0005-\u0001b\u0002B\u000f\u0001\u0019E!qD\u0001\u0010_:\u0014VmY3jm\u0016\u00148\u000b^1siR\u0011!\u0011\u0005\t\u0004\u001d\t\r\u0012b\u0001B\u0013\u001f\t9!i\\8mK\u0006t\u0007b\u0002B\u0015\u0001\u0011E!1F\u0001\u000f_:\u0014VmY3jm\u0016\u00148\u000b^8q)\u0019\tIC!\f\u00030!A\u00111\u001fB\u0014\u0001\u0004\t)\u0010\u0003\u0005\u0003\u0018\t\u001d\u0002\u0019\u0001B\r\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005\u0017\tQa\u001d;beRDqAa\u000e\u0001\t\u0003\u0011I$\u0001\u0003ti>\u0004HCBA\u0015\u0005w\u0011i\u0004\u0003\u0005\u0002t\nU\u0002\u0019AA{\u0011!\u00119B!\u000eA\u0002\te\u0001b\u0002B!\u0001\u0011\u0005!1B\u0001\u000egR\f'\u000f\u001e*fG\u0016Lg/\u001a:\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H\u0005a1\u000f^8q%\u0016\u001cW-\u001b<feR1\u0011\u0011\u0006B%\u0005\u0017B\u0001\"a=\u0003D\u0001\u0007\u0011Q\u001f\u0005\t\u0005/\u0011\u0019\u00051\u0001\u0003\u001a!9!q\n\u0001\u0005\u0002\tE\u0013a\u0004:fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:\u0015\r\u0005%\"1\u000bB+\u0011!\t\u0019P!\u0014A\u0002\u0005U\bB\u0003B\f\u0005\u001b\u0002\n\u00111\u0001\u0003\u001a!9!q\n\u0001\u0005\u0002\teC\u0003CA\u0015\u00057\u0012iFa\u0018\t\u0011\u0005M(q\u000ba\u0001\u0003kD\u0001Ba\u0006\u0003X\u0001\u0007!\u0011\u0004\u0005\b\u0005C\u00129\u00061\u0001f\u0003\u0015!W\r\\1z\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005?\t\u0011#[:SK\u000e,\u0017N^3s'R\f'\u000f^3e\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005?\t\u0011#[:SK\u000e,\u0017N^3s'R|\u0007\u000f]3e\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005\u0017\t\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\t\u0013\tE\u0004!%A\u0005\u0002\tM\u0014!\u0007:fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:%I\u00164\u0017-\u001e7uII*\"A!\u001e+\t\te!qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u0019!1Q\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\nu$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public abstract class ReceiverSupervisor
implements Logging {
    private final Receiver<?> receiver;
    private final ExecutionContextExecutorService futureExecutionContext;
    private final int streamId;
    private final CountDownLatch stopLatch;
    private final int defaultRestartDelay;
    private volatile Throwable stoppingError;
    private volatile Enumeration.Value receiverState;
    private volatile ReceiverSupervisor$ReceiverState$ ReceiverState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverSupervisor$ReceiverState$ ReceiverState$lzycompute() {
        ReceiverSupervisor receiverSupervisor = this;
        synchronized (receiverSupervisor) {
            if (this.ReceiverState$module != null) return this.ReceiverState$module;
            this.ReceiverState$module = new ReceiverSupervisor$ReceiverState$(this);
            return this.ReceiverState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverSupervisor$ReceiverState$ ReceiverState() {
        return this.ReceiverState$module == null ? this.ReceiverState$lzycompute() : this.ReceiverState$module;
    }

    private ExecutionContextExecutorService futureExecutionContext() {
        return this.futureExecutionContext;
    }

    public int streamId() {
        return this.streamId;
    }

    private CountDownLatch stopLatch() {
        return this.stopLatch;
    }

    private int defaultRestartDelay() {
        return this.defaultRestartDelay;
    }

    public long getCurrentRateLimit() {
        return Long.MAX_VALUE;
    }

    public Throwable stoppingError() {
        return this.stoppingError;
    }

    public void stoppingError_$eq(Throwable x$1) {
        this.stoppingError = x$1;
    }

    public Enumeration.Value receiverState() {
        return this.receiverState;
    }

    public void receiverState_$eq(Enumeration.Value x$1) {
        this.receiverState = x$1;
    }

    public abstract void pushSingle(Object var1);

    public abstract void pushBytes(ByteBuffer var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushIterator(Iterator<Object> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushArrayBuffer(ArrayBuffer<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract BlockGenerator createBlockGenerator(BlockGeneratorListener var1);

    public abstract void reportError(String var1, Throwable var2);

    public void onStart() {
    }

    public void onStop(String message, Option<Throwable> error) {
    }

    public abstract boolean onReceiverStart();

    public void onReceiverStop(String message, Option<Throwable> error) {
    }

    public void start() {
        this.onStart();
        this.startReceiver();
    }

    public void stop(String message, Option<Throwable> error) {
        this.stoppingError_$eq((Throwable)error.orNull(Predef$.MODULE$.conforms()));
        this.stopReceiver(message, error);
        this.onStop(message, error);
        this.futureExecutionContext().shutdownNow();
        this.stopLatch().countDown();
    }

    public synchronized void startReceiver() {
        try {
            if (this.onReceiverStart()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting receiver";
                    }
                });
                this.receiverState_$eq(this.ReceiverState().Started());
                this.receiver.onStart();
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Called receiver onStart";
                    }
                });
            } else {
                this.stop(new StringBuilder().append((Object)"Registered unsuccessfully because Driver refused to start receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)None$.MODULE$);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.stop(new StringBuilder().append((Object)"Error starting receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)new Some((Object)t));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public synchronized void stopReceiver(String message, Option<Throwable> error) {
        block6: {
            try {
                this.logInfo((Function0<String>)new Serializable(this, message, error){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;
                    private final Option error$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Stopping receiver with message: ").append((Object)this.message$2).append((Object)": ").append(this.error$2.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString();
                    }
                    {
                        this.message$2 = message$2;
                        this.error$2 = error$2;
                    }
                });
                Enumeration.Value value = this.receiverState();
                Enumeration.Value value2 = this.ReceiverState().Initialized();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Skip stopping receiver because it has not yet stared";
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                Enumeration.Value value4 = this.ReceiverState().Started();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    this.receiverState_$eq(this.ReceiverState().Stopped());
                    this.receiver.onStop();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Called receiver onStop";
                        }
                    });
                    this.onReceiverStop(message, error);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                Enumeration.Value value6 = this.ReceiverState().Stopped();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Receiver has been stopped";
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                this.logError((Function0<String>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverSupervisor $outer;
                    private final Throwable t$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Error stopping receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).append((Object)Predef$.MODULE$.exceptionWrapper(this.t$1).getStackTraceString()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.t$1 = t$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void restartReceiver(String message, Option<Throwable> error) {
        this.restartReceiver(message, error, this.defaultRestartDelay());
    }

    public void restartReceiver(String message, Option<Throwable> error, int delay) {
        Future$.MODULE$.apply((Function0)new Serializable(this, message, error, delay){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;
            public final String message$1;
            private final Option error$1;
            public final int delay$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).append((Object)" ms: ").append((Object)this.$outer.message$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Throwable)this.error$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                this.$outer.stopReceiver(new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.delay$1)).append((Object)"ms: ").append((Object)this.message$1).toString(), (Option<Throwable>)this.error$1);
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sleeping for ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Thread.sleep(this.delay$1);
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting receiver again";
                    }
                });
                this.$outer.startReceiver();
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Receiver started again";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.error$1 = error$1;
                this.delay$1 = delay$1;
            }
        }, (ExecutionContext)this.futureExecutionContext());
    }

    public Option<Throwable> restartReceiver$default$2() {
        return None$.MODULE$;
    }

    public boolean isReceiverStarted() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isReceiverStopped() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void awaitTermination() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for receiver to be stopped";
            }
        });
        this.stopLatch().await();
        if (this.stoppingError() == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped receiver without error";
                }
            });
        } else {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped receiver with error: ").append((Object)this.$outer.stoppingError()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.stoppingError() == null) {
            return;
        }
        throw this.stoppingError();
    }

    public ReceiverSupervisor(Receiver<?> receiver, SparkConf conf) {
        this.receiver = receiver;
        Logging.class.$init$((Logging)this);
        receiver.attachSupervisor(this);
        this.futureExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("receiver-supervisor-future", 128));
        this.streamId = receiver.streamId();
        this.stopLatch = new CountDownLatch(1);
        this.defaultRestartDelay = conf.getInt("spark.streaming.receiverRestartDelay", 2000);
        this.stoppingError = null;
        this.receiverState = this.ReceiverState().Initialized();
    }
}

