/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.mkdir;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.mkdir.AbstractMkdirCommand;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.mkdir.SvnMkdirConsumer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnMkdirCommand
extends AbstractMkdirCommand
implements SvnCommand {
    protected MkdirScmResult executeMkdirCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean createInLocal) throws ScmException {
        int exitCode;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new MkdirScmResult(null, "Error while making a temporary file for the mkdir message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnMkdirCommand.createCommandLine((SvnScmProviderRepository)repository, fileSet, messageFile, createInLocal);
        SvnMkdirConsumer consumer = new SvnMkdirConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
        if (exitCode != 0) {
            return new MkdirScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        if (createInLocal) {
            return new MkdirScmResult(cl.toString(), consumer.getCreatedDirs());
        }
        return new MkdirScmResult(cl.toString(), Integer.toString(consumer.getRevision()));
    }

    protected static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, File messageFile, boolean createInLocal) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet.getBasedir(), repository);
        cl.createArg().setValue("mkdir");
        Iterator it = fileSet.getFileList().iterator();
        String dirPath = ((File)it.next()).getPath();
        if (dirPath != null && Os.isFamily((String)"dos")) {
            dirPath = StringUtils.replace((String)dirPath, (String)"\\", (String)"/");
        }
        if (!createInLocal) {
            cl.createArg().setValue(repository.getUrl() + "/" + dirPath);
            if (messageFile != null) {
                cl.createArg().setValue("--file");
                cl.createArg().setValue(messageFile.getAbsolutePath());
            }
        } else {
            cl.createArg().setValue(dirPath);
        }
        return cl;
    }
}

