/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.checkin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsCheckInCommand
extends AbstractCheckInCommand
implements CvsCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        File messageFile;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("commit", repository, fileSet, false);
        if (version != null && !StringUtils.isEmpty((String)version.getName())) {
            cl.createArg().setValue("-r" + version.getName());
        }
        cl.createArg().setValue("-R");
        cl.createArg().setValue("-F");
        try {
            messageFile = File.createTempFile("scm-commit-message", ".txt");
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            throw new ScmException("Error while making a temporary commit message file.");
        }
        cl.createArg().setValue(messageFile.getAbsolutePath());
        File[] files = fileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            cl.createArg().setValue(files[i].getPath().replace('\\', '/'));
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + cl);
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        CheckInScmResult result = this.executeCvsCommand(cl, repository, messageFile);
        try {
            FileUtils.forceDelete((File)messageFile);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return result;
    }

    protected abstract CheckInScmResult executeCvsCommand(Commandline var1, CvsScmProviderRepository var2, File var3) throws ScmException;
}

