/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.registries.pages;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassList;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistrySpi;
import org.apache.wicket.Page;

@Singleton
public class PageClassRegistryDefault
implements PageClassRegistry,
PageClassRegistrySpi {
    private static final long serialVersionUID = 1L;
    private final Map<PageType, Class<? extends Page>> pagesByType = Maps.newHashMap();
    private final PageClassList pageClassList;

    @Inject
    public PageClassRegistryDefault(PageClassList pageClassList) {
        this.pageClassList = pageClassList;
        pageClassList.registerPages((PageClassRegistrySpi)this);
        this.ensureAllPageTypesRegistered();
    }

    private void ensureAllPageTypesRegistered() {
        for (PageType pageType : PageType.values()) {
            if (this.getPageClass(pageType) != null) continue;
            throw new IllegalStateException("No page registered for " + pageType);
        }
    }

    public final Class<? extends Page> getPageClass(PageType pageType) {
        return this.pagesByType.get(pageType);
    }

    public final void registerPage(PageType pageType, Class<? extends Page> pageClass) {
        this.pagesByType.put(pageType, pageClass);
    }
}

