/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.RegionStateListener;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.master.AssignmentListener;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.NoSuchProcedureException;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureInMemoryChore;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AssignmentManager
implements ServerListener {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    public static final String BOOTSTRAP_THREAD_POOL_SIZE_CONF_KEY = "hbase.assignment.bootstrap.thread.pool.size";
    public static final String ASSIGN_DISPATCH_WAIT_MSEC_CONF_KEY = "hbase.assignment.dispatch.wait.msec";
    private static final int DEFAULT_ASSIGN_DISPATCH_WAIT_MSEC = 150;
    public static final String ASSIGN_DISPATCH_WAITQ_MAX_CONF_KEY = "hbase.assignment.dispatch.wait.queue.max.size";
    private static final int DEFAULT_ASSIGN_DISPATCH_WAITQ_MAX = 100;
    public static final String RIT_CHORE_INTERVAL_MSEC_CONF_KEY = "hbase.assignment.rit.chore.interval.msec";
    private static final int DEFAULT_RIT_CHORE_INTERVAL_MSEC = 5000;
    public static final String ASSIGN_MAX_ATTEMPTS = "hbase.assignment.maximum.attempts";
    private static final int DEFAULT_ASSIGN_MAX_ATTEMPTS = 10;
    public static final String METRICS_RIT_STUCK_WARNING_THRESHOLD = "hbase.metrics.rit.stuck.warning.threshold";
    private static final int DEFAULT_RIT_STUCK_WARNING_THRESHOLD = 60000;
    private final ProcedureEvent<?> metaInitializedEvent = new ProcedureEvent((Object)"meta initialized");
    private final ProcedureEvent<?> metaLoadEvent = new ProcedureEvent((Object)"meta load");
    private final ProcedureEvent<?> failoverCleanupDone = new ProcedureEvent((Object)"failover cleanup");
    private final CopyOnWriteArrayList<AssignmentListener> listeners = new CopyOnWriteArrayList();
    private RegionStateListener regionStateListener;
    private RegionNormalizer regionNormalizer;
    private final MetricsAssignmentManager metrics;
    private final RegionInTransitionChore ritChore;
    private final MasterServices master;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final RegionStates regionStates = new RegionStates();
    private final RegionStateStore regionStateStore;
    private final boolean shouldAssignRegionsWithFavoredNodes;
    private final int assignDispatchWaitQueueMaxSize;
    private final int assignDispatchWaitMillis;
    private final int assignMaxAttempts;
    private final Object checkIfShouldMoveSystemRegionLock = new Object();
    private Thread assignThread;
    private static final Set<RegionInfo> META_REGION_SET = Collections.singleton(RegionInfoBuilder.FIRST_META_REGIONINFO);
    private static final UnassignProcedure[] UNASSIGNED_PROCEDURE_FOR_TYPE_INFO = new UnassignProcedure[0];
    private final ArrayList<RegionStates.RegionStateNode> pendingAssignQueue = new ArrayList();
    private final ReentrantLock assignQueueLock = new ReentrantLock();
    private final Condition assignQueueFullCond = this.assignQueueLock.newCondition();

    public AssignmentManager(MasterServices master) {
        this(master, new RegionStateStore(master));
    }

    public AssignmentManager(MasterServices master, RegionStateStore stateStore) {
        this.master = master;
        this.regionStateStore = stateStore;
        this.metrics = new MetricsAssignmentManager();
        Configuration conf = master.getConfiguration();
        this.shouldAssignRegionsWithFavoredNodes = FavoredStochasticBalancer.class.isAssignableFrom(conf.getClass("hbase.master.loadbalancer.class", Object.class));
        this.assignDispatchWaitMillis = conf.getInt(ASSIGN_DISPATCH_WAIT_MSEC_CONF_KEY, 150);
        this.assignDispatchWaitQueueMaxSize = conf.getInt(ASSIGN_DISPATCH_WAITQ_MAX_CONF_KEY, 100);
        this.assignMaxAttempts = Math.max(1, conf.getInt(ASSIGN_MAX_ATTEMPTS, 10));
        int ritChoreInterval = conf.getInt(RIT_CHORE_INTERVAL_MSEC_CONF_KEY, 5000);
        this.ritChore = new RegionInTransitionChore(ritChoreInterval);
        this.setRegionNormalizer(master.getRegionNormalizer());
    }

    public void start() throws IOException {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        LOG.info((Object)"Starting assignment manager");
        this.master.getServerManager().registerListener(this);
        this.regionStateStore.start();
        this.startAssignmentThread();
    }

    public void stop() {
        boolean hasProcExecutor;
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        LOG.info((Object)"Stopping assignment manager");
        boolean bl = hasProcExecutor = this.master.getMasterProcedureExecutor() != null;
        if (hasProcExecutor) {
            this.master.getMasterProcedureExecutor().removeChore((ProcedureInMemoryChore)this.ritChore);
        }
        this.stopAssignmentThread();
        this.regionStates.clear();
        this.regionStateStore.stop();
        this.master.getServerManager().unregisterListener(this);
        if (hasProcExecutor) {
            this.getProcedureScheduler().suspendEvent(this.metaLoadEvent);
            this.setFailoverCleanupDone(false);
            for (RegionInfo hri : this.getMetaRegionSet()) {
                this.setMetaInitialized(hri, false);
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public Configuration getConfiguration() {
        return this.master.getConfiguration();
    }

    public MetricsAssignmentManager getAssignmentManagerMetrics() {
        return this.metrics;
    }

    private LoadBalancer getBalancer() {
        return this.master.getLoadBalancer();
    }

    private MasterProcedureEnv getProcedureEnvironment() {
        return (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
    }

    private MasterProcedureScheduler getProcedureScheduler() {
        return this.getProcedureEnvironment().getProcedureScheduler();
    }

    protected int getAssignMaxAttempts() {
        return this.assignMaxAttempts;
    }

    public void registerListener(AssignmentListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(AssignmentListener listener) {
        return this.listeners.remove(listener);
    }

    public void setRegionStateListener(RegionStateListener listener) {
        this.regionStateListener = listener;
    }

    public void setRegionNormalizer(RegionNormalizer normalizer) {
        this.regionNormalizer = normalizer;
    }

    public RegionNormalizer getRegionNormalizer() {
        return this.regionNormalizer;
    }

    public RegionStates getRegionStates() {
        return this.regionStates;
    }

    public RegionStateStore getRegionStateStore() {
        return this.regionStateStore;
    }

    public List<ServerName> getFavoredNodes(RegionInfo regionInfo) {
        return this.shouldAssignRegionsWithFavoredNodes ? ((FavoredStochasticBalancer)this.getBalancer()).getFavoredNodes(regionInfo) : ServerName.EMPTY_SERVER_LIST;
    }

    TableStateManager getTableStateManager() {
        return this.master.getTableStateManager();
    }

    public boolean isTableEnabled(TableName tableName) {
        return this.getTableStateManager().isTableState(tableName, TableState.State.ENABLED);
    }

    public boolean isTableDisabled(TableName tableName) {
        return this.getTableStateManager().isTableState(tableName, TableState.State.DISABLED, TableState.State.DISABLING);
    }

    private boolean isMetaRegion(RegionInfo regionInfo) {
        return regionInfo.isMetaRegion();
    }

    public boolean isMetaRegion(byte[] regionName) {
        return this.getMetaRegionFromName(regionName) != null;
    }

    public RegionInfo getMetaRegionFromName(byte[] regionName) {
        for (RegionInfo hri : this.getMetaRegionSet()) {
            if (!Bytes.equals((byte[])hri.getRegionName(), (byte[])regionName)) continue;
            return hri;
        }
        return null;
    }

    public boolean isCarryingMeta(ServerName serverName) {
        for (RegionInfo hri : this.getMetaRegionSet()) {
            if (!this.isCarryingRegion(serverName, hri)) continue;
            return true;
        }
        return false;
    }

    private boolean isCarryingRegion(ServerName serverName, RegionInfo regionInfo) {
        RegionStates.RegionStateNode node = this.regionStates.getRegionNode(regionInfo);
        return node != null && serverName.equals((Object)node.getRegionLocation());
    }

    private RegionInfo getMetaForRegion(RegionInfo regionInfo) {
        return RegionInfoBuilder.FIRST_META_REGIONINFO;
    }

    public Set<RegionInfo> getMetaRegionSet() {
        return META_REGION_SET;
    }

    public boolean isMetaInitialized() {
        return this.metaInitializedEvent.isReady();
    }

    public boolean isMetaRegionInTransition() {
        return !this.isMetaInitialized();
    }

    public boolean waitMetaInitialized(Procedure proc) {
        return this.waitMetaInitialized(proc, RegionInfoBuilder.FIRST_META_REGIONINFO);
    }

    public boolean waitMetaInitialized(Procedure proc, RegionInfo regionInfo) {
        return this.getProcedureScheduler().waitEvent(this.getMetaInitializedEvent(this.getMetaForRegion(regionInfo)), proc);
    }

    private void setMetaInitialized(RegionInfo metaRegionInfo, boolean isInitialized) {
        assert (this.isMetaRegion(metaRegionInfo)) : "unexpected non-meta region " + metaRegionInfo;
        ProcedureEvent metaInitEvent = this.getMetaInitializedEvent(metaRegionInfo);
        if (isInitialized) {
            this.getProcedureScheduler().wakeEvent(metaInitEvent);
        } else {
            this.getProcedureScheduler().suspendEvent(metaInitEvent);
        }
    }

    private ProcedureEvent getMetaInitializedEvent(RegionInfo metaRegionInfo) {
        assert (this.isMetaRegion(metaRegionInfo)) : "unexpected non-meta region " + metaRegionInfo;
        return this.metaInitializedEvent;
    }

    public boolean waitMetaLoaded(Procedure proc) {
        return this.getProcedureScheduler().waitEvent(this.metaLoadEvent, proc);
    }

    protected void wakeMetaLoadedEvent() {
        this.getProcedureScheduler().wakeEvent(this.metaLoadEvent);
        assert (this.isMetaLoaded()) : "expected meta to be loaded";
    }

    public boolean isMetaLoaded() {
        return this.metaLoadEvent.isReady();
    }

    public void assignMeta(RegionInfo metaRegionInfo) throws IOException {
        this.assignMeta(metaRegionInfo, null);
    }

    public void assignMeta(RegionInfo metaRegionInfo, ServerName serverName) throws IOException {
        AssignProcedure proc;
        assert (this.isMetaRegion(metaRegionInfo)) : "unexpected non-meta region " + metaRegionInfo;
        if (serverName != null) {
            LOG.debug((Object)("Try assigning Meta " + metaRegionInfo + " to " + serverName));
            proc = this.createAssignProcedure(metaRegionInfo, serverName);
        } else {
            LOG.debug((Object)("Assigning " + metaRegionInfo.getRegionNameAsString()));
            proc = this.createAssignProcedure(metaRegionInfo, false);
        }
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    public void checkIfShouldMoveSystemRegionAsync() {
        new Thread(() -> {
            try {
                Object object = this.checkIfShouldMoveSystemRegionLock;
                synchronized (object) {
                    ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
                    for (ServerName server : this.getExcludedServersForSystemTable()) {
                        if (this.master.getServerManager().isServerDead(server)) continue;
                        List<RegionInfo> regionsShouldMove = this.getCarryingSystemTables(server);
                        if (!regionsShouldMove.isEmpty()) {
                            for (RegionInfo regionInfo : regionsShouldMove) {
                                RegionPlan plan = new RegionPlan(regionInfo, server, null);
                                if (regionInfo.isMetaRegion()) {
                                    this.moveAsync(plan);
                                    continue;
                                }
                                plans.add(plan);
                            }
                        }
                        for (RegionPlan plan : plans) {
                            this.moveAsync(plan);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error((Object)t);
            }
        }).start();
    }

    private List<RegionInfo> getCarryingSystemTables(ServerName serverName) {
        Set<RegionStates.RegionStateNode> regions = this.getRegionStates().getServerNode(serverName).getRegions();
        if (regions == null) {
            return new ArrayList<RegionInfo>();
        }
        return regions.stream().map(RegionStates.RegionStateNode::getRegionInfo).filter(r -> r.getTable().isSystemTable()).collect(Collectors.toList());
    }

    public void assign(RegionInfo regionInfo) throws IOException {
        this.assign(regionInfo, true);
    }

    public void assign(RegionInfo regionInfo, boolean forceNewPlan) throws IOException {
        AssignProcedure proc = this.createAssignProcedure(regionInfo, forceNewPlan);
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    public void unassign(RegionInfo regionInfo) throws IOException {
        this.unassign(regionInfo, false);
    }

    public void unassign(RegionInfo regionInfo, boolean forceNewPlan) throws IOException {
        RegionStates.RegionStateNode node = this.regionStates.getRegionNode(regionInfo);
        ServerName destinationServer = node.getRegionLocation();
        if (destinationServer == null) {
            throw new UnexpectedStateException("DestinationServer is null; Assigned? " + node.toString());
        }
        assert (destinationServer != null);
        node.toString();
        UnassignProcedure proc = this.createUnassignProcedure(regionInfo, destinationServer, forceNewPlan);
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    public void move(RegionInfo regionInfo) throws IOException {
        RegionStates.RegionStateNode node = this.regionStates.getRegionNode(regionInfo);
        ServerName sourceServer = node.getRegionLocation();
        RegionPlan plan = new RegionPlan(regionInfo, sourceServer, null);
        MoveRegionProcedure proc = this.createMoveRegionProcedure(plan);
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    public Future<byte[]> moveAsync(RegionPlan regionPlan) {
        MoveRegionProcedure proc = this.createMoveRegionProcedure(regionPlan);
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    @VisibleForTesting
    public boolean waitForAssignment(RegionInfo regionInfo) throws IOException {
        return this.waitForAssignment(regionInfo, Long.MAX_VALUE);
    }

    @VisibleForTesting
    public boolean waitForAssignment(RegionInfo regionInfo, long timeout) throws IOException {
        RegionStates.RegionStateNode node = null;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 10000L;
        while ((node = this.regionStates.getRegionNode(regionInfo)) == null && this.isRunning() && System.currentTimeMillis() < endTime) {
            LOG.debug((Object)("Waiting on " + regionInfo + " to be added to regionStateMap"));
            Threads.sleep((long)10L);
        }
        if (node == null) {
            if (!this.isRunning()) {
                return false;
            }
            throw new RegionException(regionInfo.getRegionNameAsString() + " never registered with Assigment.");
        }
        RegionTransitionProcedure proc = node.getProcedure();
        if (proc == null) {
            throw new NoSuchProcedureException(node.toString());
        }
        ProcedureSyncWait.waitForProcedureToCompleteIOE(this.master.getMasterProcedureExecutor(), proc, timeout);
        return true;
    }

    public AssignProcedure[] createAssignProcedures(Collection<RegionInfo> regionInfo) {
        return this.createAssignProcedures(regionInfo, false);
    }

    public AssignProcedure[] createAssignProcedures(Collection<RegionInfo> regionInfo, boolean forceNewPlan) {
        if (regionInfo.isEmpty()) {
            return null;
        }
        AssignProcedure[] procs = new AssignProcedure[regionInfo.size()];
        int index = 0;
        for (RegionInfo hri : regionInfo) {
            procs[index++] = this.createAssignProcedure(hri, forceNewPlan);
        }
        return procs;
    }

    UnassignProcedure[] createUnassignProcedures(Collection<RegionStates.RegionStateNode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<UnassignProcedure> procs = new ArrayList<UnassignProcedure>(nodes.size());
        for (RegionStates.RegionStateNode node : nodes) {
            if (!this.regionStates.include(node, false) || this.regionStates.isRegionOffline(node.getRegionInfo())) continue;
            assert (node.getRegionLocation() != null) : node.toString();
            procs.add(this.createUnassignProcedure(node.getRegionInfo(), node.getRegionLocation(), false));
        }
        return procs.toArray(UNASSIGNED_PROCEDURE_FOR_TYPE_INFO);
    }

    public MoveRegionProcedure[] createReopenProcedures(Collection<RegionInfo> regionInfo) {
        MoveRegionProcedure[] procs = new MoveRegionProcedure[regionInfo.size()];
        int index = 0;
        for (RegionInfo hri : regionInfo) {
            ServerName serverName = this.regionStates.getRegionServerOfRegion(hri);
            RegionPlan plan = new RegionPlan(hri, serverName, serverName);
            procs[index++] = this.createMoveRegionProcedure(plan);
        }
        return procs;
    }

    public AssignProcedure[] createAssignProcedures(TableName tableName) {
        return this.createAssignProcedures(this.regionStates.getRegionsOfTable(tableName));
    }

    public UnassignProcedure[] createUnassignProcedures(TableName tableName) {
        return this.createUnassignProcedures(this.regionStates.getTableRegionStateNodes(tableName));
    }

    public MoveRegionProcedure[] createReopenProcedures(TableName tableName) {
        return this.createReopenProcedures(this.regionStates.getRegionsOfTable(tableName));
    }

    public AssignProcedure createAssignProcedure(RegionInfo regionInfo, boolean forceNewPlan) {
        AssignProcedure proc = new AssignProcedure(regionInfo, forceNewPlan);
        proc.setOwner(this.getProcedureEnvironment().getRequestUser().getShortName());
        return proc;
    }

    public AssignProcedure createAssignProcedure(RegionInfo regionInfo, ServerName targetServer) {
        AssignProcedure proc = new AssignProcedure(regionInfo, targetServer);
        proc.setOwner(this.getProcedureEnvironment().getRequestUser().getShortName());
        return proc;
    }

    public UnassignProcedure createUnassignProcedure(RegionInfo regionInfo, ServerName destinationServer, boolean force) {
        ServerName sn;
        ServerName serverName = sn = destinationServer != null ? destinationServer : this.getRegionStates().getRegionState(regionInfo).getServerName();
        assert (sn != null);
        UnassignProcedure proc = new UnassignProcedure(regionInfo, sn, force);
        proc.setOwner(this.getProcedureEnvironment().getRequestUser().getShortName());
        return proc;
    }

    public MoveRegionProcedure createMoveRegionProcedure(RegionPlan plan) {
        if (plan.getRegionInfo().getTable().isSystemTable()) {
            List<ServerName> exclude = this.getExcludedServersForSystemTable();
            if (plan.getDestination() != null && exclude.contains(plan.getDestination())) {
                try {
                    LOG.info((Object)("Can not move " + plan.getRegionInfo() + " to " + plan.getDestination() + " because the server is not with highest version"));
                    plan.setDestination(this.getBalancer().randomAssignment(plan.getRegionInfo(), this.master.getServerManager().createDestinationServersList(exclude)));
                }
                catch (HBaseIOException e) {
                    LOG.warn((Object)e);
                }
            }
        }
        return new MoveRegionProcedure(this.getProcedureEnvironment(), plan);
    }

    public SplitTableRegionProcedure createSplitProcedure(RegionInfo regionToSplit, byte[] splitKey) throws IOException {
        return new SplitTableRegionProcedure(this.getProcedureEnvironment(), regionToSplit, splitKey);
    }

    public MergeTableRegionsProcedure createMergeProcedure(RegionInfo regionToMergeA, RegionInfo regionToMergeB) throws IOException {
        return new MergeTableRegionsProcedure(this.getProcedureEnvironment(), regionToMergeA, regionToMergeB);
    }

    public void deleteTable(TableName tableName) throws IOException {
        ArrayList<RegionInfo> regions = this.regionStates.getTableRegionsInfo(tableName);
        this.regionStateStore.deleteRegions(regions);
        for (int i = 0; i < regions.size(); ++i) {
            RegionInfo regionInfo = regions.get(i);
            this.regionStates.removeFromOfflineRegions(regionInfo);
            this.regionStates.deleteRegion(regionInfo);
        }
    }

    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
        RegionServerStatusProtos.ReportRegionStateTransitionResponse.Builder builder = RegionServerStatusProtos.ReportRegionStateTransitionResponse.newBuilder();
        ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getServer());
        try {
            for (RegionServerStatusProtos.RegionStateTransition transition : req.getTransitionList()) {
                switch (transition.getTransitionCode()) {
                    case OPENED: 
                    case FAILED_OPEN: 
                    case CLOSED: {
                        assert (transition.getRegionInfoCount() == 1) : transition;
                        RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(0));
                        this.updateRegionTransition(serverName, transition.getTransitionCode(), hri, transition.hasOpenSeqNum() ? transition.getOpenSeqNum() : -1L);
                        break;
                    }
                    case READY_TO_SPLIT: 
                    case SPLIT: 
                    case SPLIT_REVERTED: {
                        assert (transition.getRegionInfoCount() == 3) : transition;
                        RegionInfo parent = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(0));
                        RegionInfo splitA = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
                        RegionInfo splitB = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
                        this.updateRegionSplitTransition(serverName, transition.getTransitionCode(), parent, splitA, splitB);
                        break;
                    }
                    case READY_TO_MERGE: 
                    case MERGED: 
                    case MERGE_REVERTED: {
                        assert (transition.getRegionInfoCount() == 3) : transition;
                        RegionInfo merged = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(0));
                        RegionInfo mergeA = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(1));
                        RegionInfo mergeB = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)transition.getRegionInfo(2));
                        this.updateRegionMergeTransition(serverName, transition.getTransitionCode(), merged, mergeA, mergeB);
                    }
                }
            }
        }
        catch (PleaseHoldException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Failed transition " + e.getMessage()));
            }
            throw e;
        }
        catch (IOException | UnsupportedOperationException e) {
            LOG.warn((Object)"Failed transition", (Throwable)e);
            builder.setErrorMessage("Failed transition " + e.getMessage());
        }
        return builder.build();
    }

    private void updateRegionTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo regionInfo, long seqId) throws PleaseHoldException, UnexpectedStateException {
        RegionStates.ServerStateNode serverNode;
        this.checkFailoverCleanupCompleted(regionInfo);
        RegionStates.RegionStateNode regionNode = this.regionStates.getRegionNode(regionInfo);
        if (regionNode == null) {
            throw new UnexpectedStateException(String.format("Server %s was trying to transition region %s to %s. but the region was removed.", serverName, regionInfo, state));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("Update region transition serverName=%s region=%s state=%s", serverName, regionNode, state));
        }
        if (!this.reportTransition(regionNode, serverNode = this.regionStates.getOrCreateServer(serverName), state, seqId)) {
            LOG.warn((Object)String.format("No procedure for %s. server=%s to transition to %s", regionNode, serverName, state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportTransition(RegionStates.RegionStateNode regionNode, RegionStates.ServerStateNode serverNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, long seqId) throws UnexpectedStateException {
        ServerName serverName = serverNode.getServerName();
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            RegionTransitionProcedure proc = regionNode.getProcedure();
            if (proc == null) {
                return false;
            }
            proc.reportTransition((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), serverName, state, seqId);
        }
        return true;
    }

    private void updateRegionSplitTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo parent, RegionInfo hriA, RegionInfo hriB) throws IOException {
        this.checkFailoverCleanupCompleted(parent);
        if (state != RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT) {
            throw new UnexpectedStateException("unsupported split state=" + state + " for parent region " + parent + " maybe an old RS (< 2.0) had the operation in progress");
        }
        if (!Bytes.equals((byte[])hriA.getEndKey(), (byte[])hriB.getStartKey())) {
            throw new UnsupportedOperationException("unsupported split request with bad keys: parent=" + parent + " hriA=" + hriA + " hriB=" + hriB);
        }
        byte[] splitKey = hriB.getStartKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Split request from " + serverName + ", parent=" + parent + " splitKey=" + Bytes.toStringBinary((byte[])splitKey)));
        }
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.createSplitProcedure(parent, splitKey));
        if (this.regionStates.getOrCreateServer(serverName).getVersionNumber() < 0x200000) {
            throw new UnsupportedOperationException(String.format("Split handled by the master: parent=%s hriA=%s hriB=%s", parent.getShortNameToLog(), hriA, hriB));
        }
    }

    private void updateRegionMergeTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo merged, RegionInfo hriA, RegionInfo hriB) throws IOException {
        this.checkFailoverCleanupCompleted(merged);
        if (state != RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE) {
            throw new UnexpectedStateException("Unsupported merge state=" + state + " for regionA=" + hriA + " regionB=" + hriB + " merged=" + merged + " maybe an old RS (< 2.0) had the operation in progress");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling merge request from RS=" + merged + ", merged=" + merged));
        }
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.createMergeProcedure(hriA, hriB));
        if (this.regionStates.getOrCreateServer(serverName).getVersionNumber() < 0x200000) {
            throw new UnsupportedOperationException(String.format("Merge not handled yet: state=%s merged=%s hriA=%s hriB=%s", state, merged, hriA, hriB));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOnlineRegions(ServerName serverName, int versionNumber, Set<byte[]> regionNames) throws YouAreDeadException {
        RegionStates.ServerStateNode serverNode;
        if (!this.isRunning()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ReportOnlineRegions " + serverName + " regionCount=" + regionNames.size() + ", metaLoaded=" + this.isMetaLoaded() + " " + regionNames.stream().map(element -> Bytes.toStringBinary((byte[])element)).collect(Collectors.toList())));
        }
        RegionStates.ServerStateNode serverStateNode = serverNode = this.regionStates.getOrCreateServer(serverName);
        synchronized (serverStateNode) {
            serverNode.setVersionNumber(versionNumber);
            if (serverNode.isInState(RegionStates.ServerState.SPLITTING, RegionStates.ServerState.OFFLINE)) {
                LOG.warn((Object)("Got a report from a server result in state " + (Object)((Object)serverNode.getState())));
                return;
            }
        }
        if (regionNames.isEmpty()) {
            LOG.trace((Object)("no online region found on " + serverName));
        } else if (!this.isMetaLoaded()) {
            this.checkOnlineRegionsReportForMeta(serverNode, regionNames);
        } else {
            this.checkOnlineRegionsReport(serverNode, regionNames);
        }
        this.wakeServerReportEvent(serverNode);
    }

    public void checkOnlineRegionsReportForMeta(RegionStates.ServerStateNode serverNode, Set<byte[]> regionNames) {
        try {
            for (byte[] regionName : regionNames) {
                RegionInfo hri = this.getMetaRegionFromName(regionName);
                if (hri == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Skip online report for region=" + Bytes.toStringBinary((byte[])regionName) + " while meta is loading"));
                    continue;
                }
                RegionStates.RegionStateNode regionNode = this.regionStates.getOrCreateRegionNode(hri);
                LOG.info((Object)("META REPORTED: " + regionNode));
                if (!this.reportTransition(regionNode, serverNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, 0L)) {
                    LOG.warn((Object)"META REPORTED but no procedure found");
                    regionNode.setRegionLocation(serverNode.getServerName());
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("META REPORTED: " + regionNode));
            }
        }
        catch (UnexpectedStateException e) {
            ServerName serverName = serverNode.getServerName();
            LOG.warn((Object)("KILLING " + serverName + ": " + e.getMessage()));
            this.killRegionServer(serverNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkOnlineRegionsReport(RegionStates.ServerStateNode serverNode, Set<byte[]> regionNames) throws YouAreDeadException {
        ServerName serverName = serverNode.getServerName();
        try {
            for (byte[] regionName : regionNames) {
                if (!this.isRunning()) {
                    return;
                }
                RegionStates.RegionStateNode regionNode = this.regionStates.getRegionNodeFromName(regionName);
                if (regionNode == null) {
                    throw new UnexpectedStateException("Not online: " + Bytes.toStringBinary((byte[])regionName));
                }
                RegionStates.RegionStateNode regionStateNode = regionNode;
                synchronized (regionStateNode) {
                    block13: {
                        long diff;
                        block14: {
                            if (!regionNode.isInState(RegionState.State.OPENING, RegionState.State.OPEN)) break block14;
                            if (!regionNode.getRegionLocation().equals((Object)serverName)) {
                                throw new UnexpectedStateException(regionNode.toString() + "reported OPEN on server=" + serverName + " but state has otherwise.");
                            }
                            if (regionNode.isInState(RegionState.State.OPENING)) {
                                try {
                                    if (!this.reportTransition(regionNode, serverNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, 0L)) {
                                        LOG.warn((Object)(regionNode.toString() + " reported OPEN on server=" + serverName + " but state has otherwise AND NO procedure is running"));
                                    }
                                    break block13;
                                }
                                catch (UnexpectedStateException e) {
                                    LOG.warn((Object)(regionNode.toString() + " reported unexpteced OPEN: " + e.getMessage()), (Throwable)e);
                                }
                            }
                            break block13;
                        }
                        if (!regionNode.isInState(RegionState.State.CLOSING, RegionState.State.SPLITTING) && (diff = regionNode.getLastUpdate() - EnvironmentEdgeManager.currentTime()) > 1000L) {
                            throw new UnexpectedStateException(regionNode.toString() + " reported an unexpected OPEN; time since last update=" + diff);
                        }
                    }
                }
            }
            return;
        }
        catch (UnexpectedStateException e) {
            LOG.warn((Object)("Killing " + serverName + ": " + e.getMessage()));
            this.killRegionServer(serverNode);
            throw (YouAreDeadException)new YouAreDeadException(e.getMessage()).initCause((Throwable)e);
        }
    }

    protected boolean waitServerReportEvent(ServerName serverName, Procedure proc) {
        RegionStates.ServerStateNode serverNode = this.regionStates.getOrCreateServer(serverName);
        return this.getProcedureScheduler().waitEvent(serverNode.getReportEvent(), proc);
    }

    protected void wakeServerReportEvent(RegionStates.ServerStateNode serverNode) {
        this.getProcedureScheduler().wakeEvent(serverNode.getReportEvent());
    }

    public RegionInTransitionStat computeRegionInTransitionStat() {
        RegionInTransitionStat rit = new RegionInTransitionStat(this.getConfiguration());
        rit.update(this);
        return rit;
    }

    private void updateRegionsInTransitionMetrics(RegionInTransitionStat ritStat) {
        this.metrics.updateRITOldestAge(ritStat.getOldestRITTime());
        this.metrics.updateRITCount(ritStat.getTotalRITs());
        this.metrics.updateRITCountOverThreshold(ritStat.getTotalRITsOverThreshold());
    }

    private void handleRegionOverStuckWarningThreshold(RegionInfo regionInfo) {
        RegionStates.RegionStateNode regionNode = this.regionStates.getRegionNode(regionInfo);
        LOG.warn((Object)("TODO Handle stuck in transition: " + regionNode));
    }

    public void joinCluster() throws IOException {
        long startTime = System.currentTimeMillis();
        LOG.info((Object)"Joining the cluster...");
        this.loadMeta();
        int i = 0;
        while (this.master.getServerManager().countOfRegionServers() < 1) {
            LOG.info((Object)"waiting for RS to join");
            Threads.sleep((long)250L);
            ++i;
        }
        LOG.info((Object)("RS joined " + this.master.getServerManager().countOfRegionServers()));
        boolean failover = this.processofflineServersWithOnlineRegions();
        this.master.getMasterProcedureExecutor().addChore((ProcedureInMemoryChore)this.ritChore);
        LOG.info((Object)String.format("Joined the cluster in %s, failover=%s", StringUtils.humanTimeDiff((long)(System.currentTimeMillis() - startTime)), failover));
    }

    private void loadMeta() throws IOException {
        this.regionStateStore.visitMeta(new RegionStateStore.RegionStateVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitRegionState(RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                RegionStates.RegionStateNode regionNode;
                RegionStates.RegionStateNode regionStateNode = regionNode = AssignmentManager.this.regionStates.getOrCreateRegionNode(regionInfo);
                synchronized (regionStateNode) {
                    if (!regionNode.isInTransition()) {
                        regionNode.setState(state, new RegionState.State[0]);
                        regionNode.setLastHost(lastHost);
                        regionNode.setRegionLocation(regionLocation);
                        regionNode.setOpenSeqNum(openSeqNum);
                        if (state == RegionState.State.OPEN) {
                            assert (regionLocation != null) : "found null region location for " + regionNode;
                            AssignmentManager.this.regionStates.addRegionToServer(regionLocation, regionNode);
                        } else if (state == RegionState.State.OFFLINE || regionInfo.isOffline()) {
                            AssignmentManager.this.regionStates.addToOfflineRegions(regionNode);
                        } else {
                            AssignmentManager.this.regionStates.addRegionInTransition(regionNode, null);
                        }
                    }
                }
            }
        });
        this.wakeMetaLoadedEvent();
    }

    private boolean processofflineServersWithOnlineRegions() {
        boolean failover = !this.master.getServerManager().getDeadServers().isEmpty();
        HashSet<ServerName> offlineServersWithOnlineRegions = new HashSet<ServerName>();
        ArrayList<RegionInfo> regionsToAssign = new ArrayList<RegionInfo>();
        long st = System.currentTimeMillis();
        for (RegionStates.RegionStateNode regionNode : this.regionStates.getRegionNodes()) {
            if (regionNode.getState() == RegionState.State.OPEN) {
                ServerName serverName = regionNode.getRegionLocation();
                if (this.master.getServerManager().isServerOnline(serverName)) continue;
                offlineServersWithOnlineRegions.add(serverName);
                continue;
            }
            if (regionNode.getState() != RegionState.State.OFFLINE || !this.isTableEnabled(regionNode.getTable())) continue;
            regionsToAssign.add(regionNode.getRegionInfo());
        }
        long et = System.currentTimeMillis();
        LOG.info((Object)("[STEP-1] " + StringUtils.humanTimeDiff((long)(et - st))));
        st = System.currentTimeMillis();
        for (ServerName serverName : offlineServersWithOnlineRegions) {
            if (this.master.getServerManager().isServerOnline(serverName)) continue;
            LOG.info((Object)("KILL RS hosting regions but not online " + serverName + " (master=" + this.master.getServerName() + ")"));
            this.killRegionServer(serverName);
        }
        et = System.currentTimeMillis();
        LOG.info((Object)("[STEP-2] " + StringUtils.humanTimeDiff((long)(et - st))));
        this.setFailoverCleanupDone(true);
        st = System.currentTimeMillis();
        for (RegionInfo regionInfo : this.getOrderedRegions(regionsToAssign)) {
            this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.createAssignProcedure(regionInfo, false));
        }
        et = System.currentTimeMillis();
        LOG.info((Object)("[STEP-3] " + StringUtils.humanTimeDiff((long)(et - st))));
        return failover;
    }

    public boolean isFailoverCleanupDone() {
        return this.failoverCleanupDone.isReady();
    }

    @VisibleForTesting
    public void setFailoverCleanupDone(boolean b) {
        ((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()).setEventReady(this.failoverCleanupDone, b);
    }

    public ProcedureEvent getFailoverCleanupEvent() {
        return this.failoverCleanupDone;
    }

    private void checkFailoverCleanupCompleted(RegionInfo hri) throws PleaseHoldException {
        if (!this.isRunning()) {
            throw new PleaseHoldException("AssignmentManager not running");
        }
        boolean meta = this.isMetaRegion(hri);
        boolean cleanup = this.isFailoverCleanupDone();
        if (!this.isMetaRegion(hri) && !this.isFailoverCleanupDone()) {
            String msg = "Master not fully online; hbase:meta=" + meta + ", failoverCleanup=" + cleanup;
            throw new PleaseHoldException(msg);
        }
    }

    public int getNumRegionsOpened() {
        return 0;
    }

    public void submitServerCrash(ServerName serverName, boolean shouldSplitWal) {
        boolean carryingMeta = this.master.getAssignmentManager().isCarryingMeta(serverName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        procExec.submitProcedure((Procedure)new ServerCrashProcedure((MasterProcedureEnv)procExec.getEnvironment(), serverName, shouldSplitWal, carryingMeta));
        LOG.debug((Object)("Added=" + serverName + " to dead servers, submitted shutdown handler to be executed meta=" + carryingMeta));
    }

    public void offlineRegion(RegionInfo regionInfo) {
        RegionStates.RegionStateNode node = this.regionStates.getRegionNode(regionInfo);
        if (node != null) {
            node.offline();
        }
    }

    public void onlineRegion(RegionInfo regionInfo, ServerName serverName) {
    }

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> regions) {
        return this.regionStates.getSnapShotOfAssignment(regions);
    }

    public Pair<Integer, Integer> getReopenStatus(TableName tableName) {
        if (this.isTableDisabled(tableName)) {
            return new Pair((Object)0, (Object)0);
        }
        ArrayList<RegionState> states = this.regionStates.getTableRegionStates(tableName);
        int ritCount = 0;
        for (RegionState regionState : states) {
            if (regionState.isOpened()) continue;
            ++ritCount;
        }
        return new Pair((Object)ritCount, (Object)states.size());
    }

    public List<RegionInfo> getOrderedRegions(List<RegionInfo> regions) {
        if (regions == null) {
            return Collections.emptyList();
        }
        ArrayList<RegionInfo> systemList = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> userList = new ArrayList<RegionInfo>();
        for (RegionInfo hri : regions) {
            if (hri.getTable().isSystemTable()) {
                systemList.add(hri);
                continue;
            }
            userList.add(hri);
        }
        systemList.addAll(userList);
        return systemList;
    }

    protected boolean addRegionInTransition(RegionStates.RegionStateNode regionNode, RegionTransitionProcedure procedure) {
        return this.regionStates.addRegionInTransition(regionNode, procedure);
    }

    protected void removeRegionInTransition(RegionStates.RegionStateNode regionNode, RegionTransitionProcedure procedure) {
        this.regionStates.removeRegionInTransition(regionNode, procedure);
    }

    public boolean hasRegionsInTransition() {
        return this.regionStates.hasRegionsInTransition();
    }

    public List<RegionStates.RegionStateNode> getRegionsInTransition() {
        return this.regionStates.getRegionsInTransition();
    }

    public List<RegionInfo> getAssignedRegions() {
        return this.regionStates.getAssignedRegions();
    }

    public RegionInfo getRegionInfo(byte[] regionName) {
        RegionStates.RegionStateNode regionState = this.regionStates.getRegionNodeFromName(regionName);
        return regionState != null ? regionState.getRegionInfo() : null;
    }

    private void sendRegionOpenedNotification(RegionInfo regionInfo, ServerName serverName) {
        this.getBalancer().regionOnline(regionInfo, serverName);
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionOpened(regionInfo, serverName);
            }
        }
    }

    private void sendRegionClosedNotification(RegionInfo regionInfo) {
        this.getBalancer().regionOffline(regionInfo);
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionClosed(regionInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRegionAsOpening(RegionStates.RegionStateNode regionNode) throws IOException {
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            RegionState.State state = regionNode.transitionState(RegionState.State.OPENING, RegionStates.STATES_EXPECTED_ON_OPEN);
            this.regionStates.addRegionToServer(regionNode.getRegionLocation(), regionNode);
            this.regionStateStore.updateRegionLocation(regionNode.getRegionInfo(), state, regionNode.getRegionLocation(), regionNode.getLastHost(), -1L, regionNode.getProcedure().getProcId());
        }
        this.metrics.incrementOperationCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoRegionAsOpening(RegionStates.RegionStateNode regionNode) {
        boolean opening = false;
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            if (regionNode.isInState(RegionState.State.OPENING)) {
                opening = true;
                this.regionStates.removeRegionFromServer(regionNode.getRegionLocation(), regionNode);
            }
        }
        if (opening) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRegionAsOpened(RegionStates.RegionStateNode regionNode) throws IOException {
        RegionInfo hri = regionNode.getRegionInfo();
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            RegionState.State state = regionNode.transitionState(RegionState.State.OPEN, RegionStates.STATES_EXPECTED_ON_OPEN);
            if (this.isMetaRegion(hri)) {
                this.master.getTableStateManager().setTableState(TableName.META_TABLE_NAME, TableState.State.ENABLED);
                this.setMetaInitialized(hri, true);
            }
            this.regionStates.addRegionToServer(regionNode.getRegionLocation(), regionNode);
            this.regionStateStore.updateRegionLocation(regionNode.getRegionInfo(), state, regionNode.getRegionLocation(), regionNode.getLastHost(), regionNode.getOpenSeqNum(), regionNode.getProcedure().getProcId());
            this.sendRegionOpenedNotification(hri, regionNode.getRegionLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRegionAsClosing(RegionStates.RegionStateNode regionNode) throws IOException {
        RegionInfo hri = regionNode.getRegionInfo();
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            RegionState.State state = regionNode.transitionState(RegionState.State.CLOSING, RegionStates.STATES_EXPECTED_ON_CLOSE);
            if (this.isMetaRegion(hri)) {
                this.setMetaInitialized(hri, false);
            }
            this.regionStates.addRegionToServer(regionNode.getRegionLocation(), regionNode);
            this.regionStateStore.updateRegionLocation(regionNode.getRegionInfo(), state, regionNode.getRegionLocation(), regionNode.getLastHost(), -1L, regionNode.getProcedure().getProcId());
        }
        this.metrics.incrementOperationCounter();
    }

    public void undoRegionAsClosing(RegionStates.RegionStateNode regionNode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRegionAsClosed(RegionStates.RegionStateNode regionNode) throws IOException {
        RegionInfo hri = regionNode.getRegionInfo();
        RegionStates.RegionStateNode regionStateNode = regionNode;
        synchronized (regionStateNode) {
            RegionState.State state = regionNode.transitionState(RegionState.State.CLOSED, RegionStates.STATES_EXPECTED_ON_CLOSE);
            this.regionStates.removeRegionFromServer(regionNode.getRegionLocation(), regionNode);
            regionNode.setLastHost(regionNode.getRegionLocation());
            regionNode.setRegionLocation(null);
            this.regionStateStore.updateRegionLocation(regionNode.getRegionInfo(), state, regionNode.getRegionLocation(), regionNode.getLastHost(), -1L, regionNode.getProcedure().getProcId());
            this.sendRegionClosedNotification(hri);
        }
    }

    public void markRegionAsSplit(RegionInfo parent, ServerName serverName, RegionInfo daughterA, RegionInfo daughterB) throws IOException {
        RegionStates.RegionStateNode node = this.regionStates.getOrCreateRegionNode(parent);
        node.setState(RegionState.State.SPLIT, new RegionState.State[0]);
        this.regionStateStore.splitRegion(parent, daughterA, daughterB, serverName);
        if (this.shouldAssignFavoredNodes(parent)) {
            List<ServerName> onlineServers = this.master.getServerManager().getOnlineServersList();
            ((FavoredNodesPromoter)((Object)this.getBalancer())).generateFavoredNodesForDaughter(onlineServers, parent, daughterA, daughterB);
        }
    }

    public void markRegionAsMerged(RegionInfo child, ServerName serverName, RegionInfo mother, RegionInfo father) throws IOException {
        RegionStates.RegionStateNode node = this.regionStates.getOrCreateRegionNode(child);
        node.setState(RegionState.State.MERGED, new RegionState.State[0]);
        this.regionStates.deleteRegion(mother);
        this.regionStates.deleteRegion(father);
        this.regionStateStore.mergeRegions(child, mother, father, serverName);
        if (this.shouldAssignFavoredNodes(child)) {
            ((FavoredNodesPromoter)((Object)this.getBalancer())).generateFavoredNodesForMergedRegion(child, mother, father);
        }
    }

    private boolean shouldAssignFavoredNodes(RegionInfo region) {
        return this.shouldAssignRegionsWithFavoredNodes && FavoredNodesManager.isFavoredNodeApplicable(region);
    }

    protected void queueAssign(RegionStates.RegionStateNode regionNode) {
        this.getProcedureScheduler().suspendEvent(regionNode.getProcedureEvent());
        this.assignQueueLock.lock();
        try {
            this.pendingAssignQueue.add(regionNode);
            if (regionNode.isSystemTable() || this.pendingAssignQueue.size() == 1 || this.pendingAssignQueue.size() >= this.assignDispatchWaitQueueMaxSize) {
                this.assignQueueFullCond.signal();
            }
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    private void startAssignmentThread() {
        this.assignThread = new Thread("AssignmentThread"){

            @Override
            public void run() {
                while (AssignmentManager.this.isRunning()) {
                    AssignmentManager.this.processAssignQueue();
                }
                AssignmentManager.this.pendingAssignQueue.clear();
            }
        };
        this.assignThread.start();
    }

    private void stopAssignmentThread() {
        this.assignQueueSignal();
        try {
            while (this.assignThread.isAlive()) {
                this.assignQueueSignal();
                this.assignThread.join(250L);
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"join interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void assignQueueSignal() {
        this.assignQueueLock.lock();
        try {
            this.assignQueueFullCond.signal();
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    private HashMap<RegionInfo, RegionStates.RegionStateNode> waitOnAssignQueue() {
        HashMap<RegionInfo, RegionStates.RegionStateNode> regions = null;
        this.assignQueueLock.lock();
        try {
            if (this.pendingAssignQueue.isEmpty() && this.isRunning()) {
                this.assignQueueFullCond.await();
            }
            if (!this.isRunning()) {
                HashMap<RegionInfo, RegionStates.RegionStateNode> hashMap = null;
                return hashMap;
            }
            this.assignQueueFullCond.await(this.assignDispatchWaitMillis, TimeUnit.MILLISECONDS);
            regions = new HashMap<RegionInfo, RegionStates.RegionStateNode>(this.pendingAssignQueue.size());
            for (RegionStates.RegionStateNode regionNode : this.pendingAssignQueue) {
                regions.put(regionNode.getRegionInfo(), regionNode);
            }
            this.pendingAssignQueue.clear();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"got interrupted ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.assignQueueLock.unlock();
        }
        return regions;
    }

    private void processAssignQueue() {
        HashMap<RegionInfo, RegionStates.RegionStateNode> regions = this.waitOnAssignQueue();
        if (regions == null || regions.size() == 0 || !this.isRunning()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("PROCESS ASSIGN QUEUE regionCount=" + regions.size()));
        }
        HashMap<RegionInfo, ServerName> retainMap = new HashMap<RegionInfo, ServerName>();
        ArrayList<RegionInfo> userRRList = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> sysRRList = new ArrayList<RegionInfo>();
        for (RegionStates.RegionStateNode regionNode : regions.values()) {
            ArrayList<RegionInfo> rrList;
            boolean sysTable = regionNode.isSystemTable();
            ArrayList<RegionInfo> arrayList = rrList = sysTable ? sysRRList : userRRList;
            if (regionNode.getRegionLocation() != null) {
                retainMap.put(regionNode.getRegionInfo(), regionNode.getRegionLocation());
                continue;
            }
            rrList.add(regionNode.getRegionInfo());
        }
        List<ServerName> servers = this.master.getServerManager().createDestinationServersList();
        int i = 0;
        while (servers.size() < 1) {
            if (i % 4 == 0) {
                LOG.warn((Object)("no server available, unable to find a location for " + regions.size() + " unassigned regions. waiting"));
            }
            if (!this.isRunning()) {
                LOG.debug((Object)("aborting assignment-queue with " + regions.size() + " not assigned"));
                return;
            }
            Threads.sleep((long)250L);
            servers = this.master.getServerManager().createDestinationServersList();
            ++i;
        }
        if (!sysRRList.isEmpty()) {
            List<ServerName> excludeServers = this.getExcludedServersForSystemTable();
            List serversForSysTables = servers.stream().filter(s -> !excludeServers.contains(s)).collect(Collectors.toList());
            if (serversForSysTables.isEmpty()) {
                LOG.warn((Object)"No servers available for system table regions, considering all servers!");
            }
            LOG.debug((Object)("Processing assignment plans for System tables sysServersCount=" + serversForSysTables.size() + ", allServersCount=" + servers.size()));
            this.processAssignmentPlans(regions, null, sysRRList, serversForSysTables.isEmpty() ? servers : serversForSysTables);
        }
        this.processAssignmentPlans(regions, retainMap, userRRList, servers);
    }

    private void processAssignmentPlans(HashMap<RegionInfo, RegionStates.RegionStateNode> regions, HashMap<RegionInfo, ServerName> retainMap, List<RegionInfo> rrList, List<ServerName> servers) {
        boolean isTraceEnabled = LOG.isTraceEnabled();
        if (isTraceEnabled) {
            LOG.trace((Object)("available servers count=" + servers.size() + ": " + servers));
        }
        LoadBalancer balancer = this.getBalancer();
        if (retainMap != null && !retainMap.isEmpty()) {
            if (isTraceEnabled) {
                LOG.trace((Object)("retain assign regions=" + retainMap));
            }
            try {
                this.acceptPlan(regions, balancer.retainAssignment(retainMap, servers));
            }
            catch (HBaseIOException e) {
                LOG.warn((Object)"unable to retain assignment", (Throwable)e);
                this.addToPendingAssignment(regions, retainMap.keySet());
            }
        }
        if (!rrList.isEmpty()) {
            Collections.sort(rrList, RegionInfo.COMPARATOR);
            if (isTraceEnabled) {
                LOG.trace((Object)("round robin regions=" + rrList));
            }
            try {
                this.acceptPlan(regions, balancer.roundRobinAssignment(rrList, servers));
            }
            catch (HBaseIOException e) {
                LOG.warn((Object)"unable to round-robin assignment", (Throwable)e);
                this.addToPendingAssignment(regions, rrList);
            }
        }
    }

    private void acceptPlan(HashMap<RegionInfo, RegionStates.RegionStateNode> regions, Map<ServerName, List<RegionInfo>> plan) throws HBaseIOException {
        ProcedureEvent[] events = new ProcedureEvent[regions.size()];
        long st = System.currentTimeMillis();
        if (plan == null) {
            throw new HBaseIOException("unable to compute plans for regions=" + regions.size());
        }
        if (plan.isEmpty()) {
            return;
        }
        int evcount = 0;
        for (Map.Entry<ServerName, List<RegionInfo>> entry : plan.entrySet()) {
            ServerName server = entry.getKey();
            for (RegionInfo hri : entry.getValue()) {
                RegionStates.RegionStateNode regionNode = regions.get(hri);
                regionNode.setRegionLocation(server);
                events[evcount++] = regionNode.getProcedureEvent();
            }
        }
        this.getProcedureScheduler().wakeEvents(evcount, events);
        long et = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ASSIGN ACCEPT " + events.length + " -> " + StringUtils.humanTimeDiff((long)(et - st))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingAssignment(HashMap<RegionInfo, RegionStates.RegionStateNode> regions, Collection<RegionInfo> pendingRegions) {
        this.assignQueueLock.lock();
        try {
            for (RegionInfo hri : pendingRegions) {
                this.pendingAssignQueue.add(regions.get(hri));
            }
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    public List<ServerName> getExcludedServersForSystemTable() {
        List serverList = this.master.getServerManager().getOnlineServersList().stream().map(s -> new Pair(s, (Object)this.master.getRegionServerVersion((ServerName)s))).collect(Collectors.toList());
        if (serverList.isEmpty()) {
            return new ArrayList<ServerName>();
        }
        String highestVersion = (String)((Pair)Collections.max(serverList, (o1, o2) -> VersionInfo.compareVersion((String)((String)o1.getSecond()), (String)((String)o2.getSecond())))).getSecond();
        return serverList.stream().filter(p -> !((String)p.getSecond()).equals(highestVersion)).map(Pair::getFirst).collect(Collectors.toList());
    }

    @Override
    public void serverAdded(ServerName serverName) {
    }

    @Override
    public void serverRemoved(ServerName serverName) {
        RegionStates.ServerStateNode serverNode = this.regionStates.getServerNode(serverName);
        if (serverNode == null) {
            return;
        }
        this.wakeServerReportEvent(serverNode);
    }

    public int getServerVersion(ServerName serverName) {
        RegionStates.ServerStateNode node = this.regionStates.getServerNode(serverName);
        return node != null ? node.getVersionNumber() : 0;
    }

    public void killRegionServer(ServerName serverName) {
        RegionStates.ServerStateNode serverNode = this.regionStates.getServerNode(serverName);
        this.killRegionServer(serverNode);
    }

    public void killRegionServer(RegionStates.ServerStateNode serverNode) {
        this.master.getServerManager().expireServer(serverNode.getServerName());
    }

    public static class RegionInTransitionStat {
        private final int ritThreshold;
        private HashMap<String, RegionState> ritsOverThreshold = null;
        private long statTimestamp;
        private long oldestRITTime = 0L;
        private int totalRITsTwiceThreshold = 0;
        private int totalRITs = 0;

        @VisibleForTesting
        public RegionInTransitionStat(Configuration conf) {
            this.ritThreshold = conf.getInt(AssignmentManager.METRICS_RIT_STUCK_WARNING_THRESHOLD, 60000);
        }

        public int getRITThreshold() {
            return this.ritThreshold;
        }

        public long getTimestamp() {
            return this.statTimestamp;
        }

        public int getTotalRITs() {
            return this.totalRITs;
        }

        public long getOldestRITTime() {
            return this.oldestRITTime;
        }

        public int getTotalRITsOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null ? m.size() : 0;
        }

        public boolean hasRegionsTwiceOverThreshold() {
            return this.totalRITsTwiceThreshold > 0;
        }

        public boolean hasRegionsOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null && !m.isEmpty();
        }

        public Collection<RegionState> getRegionOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null ? m.values() : Collections.EMPTY_SET;
        }

        public boolean isRegionOverThreshold(RegionInfo regionInfo) {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null && m.containsKey(regionInfo.getEncodedName());
        }

        public boolean isRegionTwiceOverThreshold(RegionInfo regionInfo) {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            if (m == null) {
                return false;
            }
            RegionState state = (RegionState)m.get(regionInfo.getEncodedName());
            if (state == null) {
                return false;
            }
            return this.statTimestamp - state.getStamp() > (long)(this.ritThreshold * 2);
        }

        protected void update(AssignmentManager am) {
            RegionStates regionStates = am.getRegionStates();
            this.statTimestamp = EnvironmentEdgeManager.currentTime();
            this.update(regionStates.getRegionsStateInTransition(), this.statTimestamp);
            this.update(regionStates.getRegionFailedOpen(), this.statTimestamp);
        }

        private void update(Collection<RegionState> regions, long currentTime) {
            for (RegionState state : regions) {
                ++this.totalRITs;
                long ritTime = currentTime - state.getStamp();
                if (ritTime > (long)this.ritThreshold) {
                    if (this.ritsOverThreshold == null) {
                        this.ritsOverThreshold = new HashMap();
                    }
                    this.ritsOverThreshold.put(state.getRegion().getEncodedName(), state);
                    this.totalRITsTwiceThreshold += ritTime > (long)(this.ritThreshold * 2) ? 1 : 0;
                }
                if (this.oldestRITTime >= ritTime) continue;
                this.oldestRITTime = ritTime;
            }
        }
    }

    private static class RegionInTransitionChore
    extends ProcedureInMemoryChore<MasterProcedureEnv> {
        public RegionInTransitionChore(int timeoutMsec) {
            super(timeoutMsec);
        }

        protected void periodicExecute(MasterProcedureEnv env) {
            AssignmentManager am = env.getAssignmentManager();
            RegionInTransitionStat ritStat = am.computeRegionInTransitionStat();
            if (ritStat.hasRegionsOverThreshold()) {
                for (RegionState hri : ritStat.getRegionOverThreshold()) {
                    am.handleRegionOverStuckWarningThreshold(hri.getRegion());
                }
            }
            am.updateRegionsInTransitionMetrics(ritStat);
        }
    }
}

