/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AssignProcedure
extends RegionTransitionProcedure {
    private static final Log LOG = LogFactory.getLog(AssignProcedure.class);
    private boolean forceNewPlan = false;
    protected volatile ServerName targetServer;

    public AssignProcedure() {
    }

    public AssignProcedure(RegionInfo regionInfo) {
        this(regionInfo, false);
    }

    public AssignProcedure(RegionInfo regionInfo, boolean forceNewPlan) {
        super(regionInfo);
        this.forceNewPlan = forceNewPlan;
        this.targetServer = null;
    }

    public AssignProcedure(RegionInfo regionInfo, ServerName destinationServer) {
        super(regionInfo);
        this.forceNewPlan = false;
        this.targetServer = destinationServer;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_ASSIGN;
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState state) {
        switch (state) {
            case REGION_TRANSITION_QUEUE: {
                return true;
            }
        }
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.AssignRegionStateData.Builder state = MasterProcedureProtos.AssignRegionStateData.newBuilder().setTransitionState(this.getTransitionState()).setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.getRegionInfo()));
        if (this.forceNewPlan) {
            state.setForceNewPlan(true);
        }
        if (this.targetServer != null) {
            state.setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer));
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.AssignRegionStateData state = (MasterProcedureProtos.AssignRegionStateData)serializer.deserialize(MasterProcedureProtos.AssignRegionStateData.class);
        this.setTransitionState(state.getTransitionState());
        this.setRegionInfo(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)state.getRegionInfo()));
        this.forceNewPlan = state.getForceNewPlan();
        if (state.hasTargetServer()) {
            this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getTargetServer());
        }
    }

    @Override
    protected boolean startTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        TableName tn;
        if (regionNode.isInState(RegionState.State.OPEN) && this.isServerOnline(env, regionNode)) {
            LOG.info((Object)("Assigned, not reassigning; " + this + "; " + regionNode.toShortString()));
            return false;
        }
        TableStateManager tsm = env.getMasterServices().getTableStateManager();
        if (tsm.isTableState(tn = regionNode.getRegionInfo().getTable(), TableState.State.DISABLING, TableState.State.DISABLED)) {
            LOG.info((Object)("Table " + tn + " state=" + tsm.getTableState(tn) + ", skipping " + this));
            return false;
        }
        if (regionNode.isInState(RegionState.State.SPLIT) || regionNode.getRegionInfo().isOffline() && regionNode.getRegionInfo().isSplit()) {
            LOG.info((Object)("SPLIT, cannot be assigned; " + this + "; " + regionNode + "; hri=" + regionNode.getRegionInfo()));
            return false;
        }
        if (this.aborted.get() && regionNode.isInState(RegionState.State.CLOSED, RegionState.State.OFFLINE)) {
            if (this.incrementAndCheckMaxAttempts(env, regionNode)) {
                regionNode.setState(RegionState.State.FAILED_OPEN, new RegionState.State[0]);
                this.setFailure(this.getClass().getSimpleName(), (Throwable)new RetriesExhaustedException("Max attempts exceeded"));
            } else {
                this.setAbortFailure(this.getClass().getSimpleName(), "Abort requested");
            }
            return false;
        }
        ServerName lastRegionLocation = regionNode.offline();
        boolean retain = false;
        if (!this.forceNewPlan) {
            if (this.targetServer != null) {
                retain = this.targetServer.equals((Object)lastRegionLocation);
                regionNode.setRegionLocation(this.targetServer);
            } else if (lastRegionLocation != null) {
                retain = true;
                regionNode.setRegionLocation(lastRegionLocation);
            } else if (regionNode.getLastHost() != null) {
                retain = true;
                LOG.info((Object)("Setting lastHost as the region location " + regionNode.getLastHost()));
                regionNode.setRegionLocation(regionNode.getLastHost());
            }
        }
        LOG.info((Object)("Start " + this + "; " + regionNode.toShortString() + "; forceNewPlan=" + this.forceNewPlan + ", retain=" + retain));
        env.getAssignmentManager().queueAssign(regionNode);
        return true;
    }

    @Override
    protected boolean updateTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException, ProcedureSuspendedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Update " + this + "; " + regionNode.toShortString()));
        }
        if (regionNode.getRegionLocation() == null) {
            this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE);
            return true;
        }
        if (!this.isServerOnline(env, regionNode)) {
            LOG.info((Object)("Server not online, re-queuing " + this + "; " + regionNode.toShortString()));
            this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE);
            return true;
        }
        if (env.getAssignmentManager().waitServerReportEvent(regionNode.getRegionLocation(), this)) {
            LOG.info((Object)("Early suspend! " + this + "; " + regionNode.toShortString()));
            throw new ProcedureSuspendedException();
        }
        if (regionNode.isInState(RegionState.State.OPEN)) {
            LOG.info((Object)("Already assigned: " + this + "; " + regionNode.toShortString()));
            return false;
        }
        env.getAssignmentManager().markRegionAsOpening(regionNode);
        if (!this.addToRemoteDispatcher(env, regionNode.getRegionLocation())) {
            // empty if block
        }
        return true;
    }

    @Override
    protected void finishTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        env.getAssignmentManager().markRegionAsOpened(regionNode);
        env.getAssignmentManager().getRegionStates().removeFromFailedOpen(regionNode.getRegionInfo());
    }

    @Override
    protected void reportTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum) throws UnexpectedStateException {
        switch (code) {
            case OPENED: {
                if (openSeqNum < 0L) {
                    throw new UnexpectedStateException("Received report unexpected " + code + " transition openSeqNum=" + openSeqNum + ", " + regionNode);
                }
                if (openSeqNum < regionNode.getOpenSeqNum()) {
                    LOG.warn((Object)("Skipping update of open seqnum with " + openSeqNum + " because current seqnum=" + regionNode.getOpenSeqNum()));
                }
                regionNode.setOpenSeqNum(openSeqNum);
                this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_FINISH);
                break;
            }
            case FAILED_OPEN: {
                this.handleFailure(env, regionNode);
                break;
            }
            default: {
                throw new UnexpectedStateException("Received report unexpected " + code + " transition openSeqNum=" + openSeqNum + ", " + regionNode.toShortString() + ", " + this + ", expected OPENED or FAILED_OPEN.");
            }
        }
    }

    private void handleFailure(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        if (this.incrementAndCheckMaxAttempts(env, regionNode)) {
            this.aborted.set(true);
        }
        this.forceNewPlan = true;
        this.targetServer = null;
        regionNode.offline();
        env.getAssignmentManager().undoRegionAsOpening(regionNode);
        this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE);
    }

    private boolean incrementAndCheckMaxAttempts(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        int retries = env.getAssignmentManager().getRegionStates().addToFailedOpen(regionNode).incrementAndGetRetries();
        int max = env.getAssignmentManager().getAssignMaxAttempts();
        LOG.info((Object)("Retry=" + retries + " of max=" + max + "; " + this + "; " + regionNode.toShortString()));
        return retries >= max;
    }

    @Override
    public RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        assert (serverName.equals((Object)this.getRegionState(env).getRegionLocation()));
        return new RSProcedureDispatcher.RegionOpenOperation(this, this.getRegionInfo(), env.getAssignmentManager().getFavoredNodes(this.getRegionInfo()), false);
    }

    @Override
    protected boolean remoteCallFailed(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, IOException exception) {
        this.handleFailure(env, regionNode);
        return true;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        if (this.targetServer != null) {
            sb.append(", target=").append(this.targetServer);
        }
    }

    @Override
    public ServerName getServer(MasterProcedureEnv env) {
        RegionStates.RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionNode(this.getRegionInfo());
        if (node == null) {
            return null;
        }
        return node.getRegionLocation();
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getAssignProcMetrics();
    }
}

