/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");

    private static HTable getAclTable(Configuration conf) throws IOException {
        return new HTable(conf, ACL_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthorizationEnabled(Configuration conf) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            boolean bl = admin.getSecurityCapabilities().contains((Object)SecurityCapability.AUTHORIZATION);
            return bl;
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCellAuthorizationEnabled(Configuration conf) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            boolean bl = admin.getSecurityCapabilities().contains((Object)SecurityCapability.CELL_AUTHORIZATION);
            return bl;
        }
        finally {
            admin.close();
        }
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(HTable ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Configuration conf, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(ht), userName, tableName, family, qual, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(ht), userName, namespace, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grant(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(ht), userName, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessControllerRunning(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        HBaseAdmin ha = null;
        try {
            ha = new HBaseAdmin(conf);
            boolean bl = ha.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
        finally {
            if (ha != null) {
                ha.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revoke(Configuration conf, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(ht), username, tableName, family, qualifier, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revoke(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(ht), userName, namespace, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revoke(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            ht = AccessControlClient.getAclTable(conf);
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(ht), userName, actions);
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UserPermission> getUserPermissions(Configuration conf, String tableRegex) throws Throwable {
        ArrayList<UserPermission> permList = new ArrayList();
        HTable table = new HTable(conf, ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            HBaseAdmin admin = new HBaseAdmin(conf);
            try {
                HTableDescriptor[] htds = null;
                if (tableRegex == null || tableRegex.isEmpty()) {
                    permList = ProtobufUtil.getUserPermissions(protocol);
                } else if (tableRegex.charAt(0) == '@') {
                    String namespaceRegex = tableRegex.substring(1);
                    for (NamespaceDescriptor nsds : admin.listNamespaceDescriptors()) {
                        String namespace = nsds.getName();
                        if (!namespace.matches(namespaceRegex)) continue;
                        permList.addAll(ProtobufUtil.getUserPermissions(protocol, Bytes.toBytes((String)namespace)));
                    }
                } else {
                    for (HTableDescriptor hd : htds = admin.listTables(Pattern.compile(tableRegex))) {
                        permList.addAll(ProtobufUtil.getUserPermissions(protocol, hd.getTableName()));
                    }
                }
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
        return permList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AccessControlProtos.GrantResponse grant(Configuration conf, final TableName tableName, final String userName, final byte[] family, final byte[] qual, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.GrantResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.GrantResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.GrantRequest.Builder builder = AccessControlProtos.GrantRequest.newBuilder();
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    if (family != null) {
                        permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
                    }
                    if (qual != null) {
                        permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qual));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    builder.setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)userName)).setPermission(ret));
                    service.grant((RpcController)this.controller, builder.build(), this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.GrantResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.GrantResponse grantResponse = result.values().iterator().next();
            return grantResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AccessControlProtos.RevokeResponse revoke(Configuration conf, final String username, final TableName tableName, final byte[] family, final byte[] qualifier, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.RevokeResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.RevokeResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    if (tableName != null) {
                        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    }
                    if (family != null) {
                        permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
                    }
                    if (qualifier != null) {
                        permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qualifier));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    AccessControlProtos.RevokeRequest builder = AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
                    service.revoke((RpcController)this.controller, builder, this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.RevokeResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.RevokeResponse revokeResponse = result.values().iterator().next();
            return revokeResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }
}

