/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    protected final Configuration conf;
    private final long pause;
    private final int retries;
    private final int rpcTimeout;
    private final int startLogErrorsCnt;
    private final boolean enableBackPressure;
    private ServerStatisticTracker stats;

    public RpcRetryingCallerFactory(Configuration conf) {
        this(conf, null);
    }

    public RpcRetryingCallerFactory(Configuration conf, ServerStatisticTracker stats) {
        this.conf = conf;
        this.stats = stats;
        this.pause = conf.getLong("hbase.client.pause", 100L);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 9);
        this.enableBackPressure = conf.getBoolean("hbase.client.backpressure.enabled", false);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
    }

    public void setStatisticTracker(ServerStatisticTracker statisticTracker) {
        this.stats = statisticTracker;
    }

    public <T> RpcRetryingCaller<T> newCaller(int rpcTimeout) {
        RpcRetryingCaller caller = new RpcRetryingCaller(this.pause, this.retries, this.startLogErrorsCnt, rpcTimeout);
        return caller;
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        RpcRetryingCaller caller = new RpcRetryingCaller(this.pause, this.retries, this.startLogErrorsCnt, this.rpcTimeout);
        return caller;
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ServerStatisticTracker stats) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        if (rpcCallerFactoryClazz.equals(clazzName)) {
            return new RpcRetryingCallerFactory(configuration, stats);
        }
        try {
            return (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcCallerFactoryClazz, (Class[])new Class[]{Configuration.class, ServerStatisticTracker.class}, (Object[])new Object[]{configuration, stats});
        }
        catch (UnsupportedOperationException e) {
            return (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcCallerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
        }
    }
}

