/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public final class ResultStatsUtil {
    private ResultStatsUtil() {
    }

    public static <T> T updateStats(T r, ServerStatisticTracker serverStats, ServerName server, byte[] regionName) {
        if (!(r instanceof Result)) {
            return r;
        }
        Result result = (Result)r;
        ClientProtos.RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return r;
        }
        ResultStatsUtil.updateStats(serverStats, server, regionName, stats);
        return r;
    }

    public static void updateStats(StatisticTrackable tracker, ServerName server, byte[] regionName, ClientProtos.RegionLoadStats stats) {
        if (regionName != null && stats != null && tracker != null) {
            tracker.updateRegionStats(server, regionName, stats);
        }
    }
}

