/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;

public class DockerRunCommand
extends DockerCommand {
    private static final String RUN_COMMAND = "run";
    private final String image;
    private List<String> overrrideCommandWithArgs;

    public DockerRunCommand(String containerId, String user, String image) {
        super(RUN_COMMAND);
        super.addCommandArguments("--name=" + containerId, "--user=" + user);
        this.image = image;
    }

    public DockerRunCommand removeContainerOnExit() {
        super.addCommandArguments("--rm");
        return this;
    }

    public DockerRunCommand detachOnRun() {
        super.addCommandArguments("-d");
        return this;
    }

    public DockerRunCommand setContainerWorkDir(String workdir) {
        super.addCommandArguments("--workdir=" + workdir);
        return this;
    }

    public DockerRunCommand setNetworkType(String type) {
        super.addCommandArguments("--net=" + type);
        return this;
    }

    public DockerRunCommand addMountLocation(String sourcePath, String destinationPath, boolean createSource) {
        boolean sourceExists = new File(sourcePath).exists();
        if (!sourceExists && !createSource) {
            return this;
        }
        super.addCommandArguments("-v", sourcePath + ":" + destinationPath);
        return this;
    }

    public DockerRunCommand setCGroupParent(String parentPath) {
        super.addCommandArguments("--cgroup-parent=" + parentPath);
        return this;
    }

    public DockerRunCommand setPrivileged() {
        super.addCommandArguments("--privileged");
        return this;
    }

    public DockerRunCommand setCapabilities(Set<String> capabilties) {
        super.addCommandArguments("--cap-drop=ALL");
        for (String capability : capabilties) {
            super.addCommandArguments("--cap-add=" + capability);
        }
        return this;
    }

    public DockerRunCommand setHostname(String hostname) {
        super.addCommandArguments("--hostname=" + hostname);
        return this;
    }

    public DockerRunCommand addDevice(String sourceDevice, String destinationDevice) {
        super.addCommandArguments("--device=" + sourceDevice + ":" + destinationDevice);
        return this;
    }

    public DockerRunCommand enableDetach() {
        super.addCommandArguments("--detach=true");
        return this;
    }

    public DockerRunCommand disableDetach() {
        super.addCommandArguments("--detach=false");
        return this;
    }

    public DockerRunCommand groupAdd(String[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            super.addCommandArguments("--group-add " + groups[i]);
        }
        return this;
    }

    public DockerRunCommand setOverrideCommandWithArgs(List<String> overrideCommandWithArgs) {
        this.overrrideCommandWithArgs = overrideCommandWithArgs;
        return this;
    }

    @Override
    public String getCommandWithArguments() {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(super.getCommandWithArguments());
        argList.add(this.image);
        if (this.overrrideCommandWithArgs != null) {
            argList.addAll(this.overrrideCommandWithArgs);
        }
        return StringUtils.join((CharSequence)" ", argList);
    }
}

