/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ConfigurationException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerRelaunch
extends ContainerLaunch {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerRelaunch.class);

    public ContainerRelaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        super(context, configuration, dispatcher, exec, app, container, dirsHandler, containerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Path containerLogDir;
        if (!this.validateContainerState()) {
            return 0;
        }
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = containerId.toString();
        int ret = -1;
        try {
            Path containerWorkDir = this.getContainerWorkDir();
            this.cleanupPreviousContainerFiles(containerWorkDir);
            containerLogDir = this.getContainerLogDir();
            Map<Path, List<String>> localResources = this.getLocalizedResources();
            String appIdStr = this.app.getAppId().toString();
            Path nmPrivateContainerScriptPath = this.getNmPrivateContainerScriptPath(appIdStr, containerIdStr);
            Path nmPrivateTokensPath = this.getNmPrivateTokensPath(appIdStr, containerIdStr);
            this.pidFilePath = this.getPidFilePath(appIdStr, containerIdStr);
            LOG.info("Relaunch container with workDir = " + containerWorkDir.toString() + ", logDir = " + containerLogDir.toString() + ", nmPrivateContainerScriptPath = " + nmPrivateContainerScriptPath.toString() + ", nmPrivateTokensPath = " + nmPrivateTokensPath.toString() + ", pidFilePath = " + this.pidFilePath.toString());
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            List<String> containerLocalDirs = this.getContainerLocalDirs(localDirs);
            List<String> containerLogDirs = this.getContainerLogDirs(logDirs);
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport(false));
            }
            ret = this.launchContainer(new ContainerStartContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setNmPrivateContainerScriptPath(nmPrivateContainerScriptPath).setNmPrivateTokensPath(nmPrivateTokensPath).setUser(this.container.getUser()).setAppId(appIdStr).setContainerWorkDir(containerWorkDir).setLocalDirs(localDirs).setLogDirs(logDirs).setContainerLocalDirs(containerLocalDirs).setContainerLogDirs(containerLogDirs).build());
        }
        catch (ConfigurationException e) {
            LOG.error("Failed to launch container due to configuration error.", (Throwable)e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            this.getContext().getNodeStatusUpdater().reportException((Exception)((Object)e));
            Integer n = ret;
            return n;
        }
        catch (Throwable e) {
            LOG.warn("Failed to relaunch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.setContainerCompletedStatus(ret);
        }
        this.handleContainerExitCode(ret, containerLogDir);
        return ret;
    }

    private Path getContainerWorkDir() throws IOException {
        String containerWorkDir = this.container.getWorkDir();
        if (containerWorkDir == null || !this.dirsHandler.isGoodLocalDir(containerWorkDir)) {
            throw new IOException("Could not find a good work dir " + containerWorkDir + " for container " + this.container);
        }
        return new Path(containerWorkDir);
    }

    private Path getContainerLogDir() throws IOException {
        String containerLogDir = this.container.getLogDir();
        if (containerLogDir == null || !this.dirsHandler.isGoodLogDir(containerLogDir)) {
            throw new IOException("Could not find a good log dir " + containerLogDir + " for container " + this.container);
        }
        return new Path(containerLogDir);
    }

    private Path getNmPrivateContainerScriptPath(String appIdStr, String containerIdStr) throws IOException {
        return this.dirsHandler.getLocalPathForRead(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
    }

    private Path getNmPrivateTokensPath(String appIdStr, String containerIdStr) throws IOException {
        return this.dirsHandler.getLocalPathForRead(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
    }

    private Path getPidFilePath(String appIdStr, String containerIdStr) throws IOException {
        return this.dirsHandler.getLocalPathForRead(this.getPidFileSubpath(appIdStr, containerIdStr));
    }

    private void cleanupPreviousContainerFiles(Path containerWorkDir) {
        this.deleteAsUser(new Path(containerWorkDir, CONTAINER_SCRIPT));
        this.deleteAsUser(new Path(containerWorkDir, "container_tokens"));
    }

    private void deleteAsUser(Path path) {
        try {
            this.exec.deleteAsUser(new DeletionAsUserContext.Builder().setUser(this.container.getUser()).setSubDir(path).build());
        }
        catch (Exception e) {
            LOG.warn("Failed to delete " + path, (Throwable)e);
        }
    }
}

