/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ConfigurationException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.WindowsSecureContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerPrepareContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLaunch
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLaunch.class);
    public static final String CONTAINER_SCRIPT = Shell.appendScriptExtension((String)"launch_container");
    public static final String FINAL_CONTAINER_TOKENS_FILE = "container_tokens";
    private static final String PID_FILE_NAME_FMT = "%s.pid";
    private static final String EXIT_CODE_FILE_SUFFIX = ".exitcode";
    protected final Dispatcher dispatcher;
    protected final ContainerExecutor exec;
    protected final Application app;
    protected final Container container;
    private final Configuration conf;
    private final Context context;
    private final ContainerManagerImpl containerManager;
    protected AtomicBoolean containerAlreadyLaunched = new AtomicBoolean(false);
    protected AtomicBoolean completed = new AtomicBoolean(false);
    private volatile boolean killedBeforeStart = false;
    private long sleepDelayBeforeSigKill = 250L;
    private long maxKillWaitTime = 2000L;
    protected Path pidFilePath = null;
    protected final LocalDirsHandlerService dirsHandler;

    public ContainerLaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        this.context = context;
        this.conf = configuration;
        this.app = app;
        this.exec = exec;
        this.container = container;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.containerManager = containerManager;
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
        this.maxKillWaitTime = this.conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L);
    }

    @VisibleForTesting
    public static String expandEnvironment(String var, Path containerLogDir) {
        var = var.replace("<LOG_DIR>", containerLogDir.toString());
        var = var.replace("<CPS>", File.pathSeparator);
        if (Shell.WINDOWS) {
            var = var.replaceAll("(\\{\\{)|(\\}\\})", "%");
        } else {
            var = var.replace("{{", "$");
            var = var.replace("}}", "");
        }
        return var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Path containerLogDir;
        if (!this.validateContainerState()) {
            return 0;
        }
        ContainerLaunchContext launchContext = this.container.getLaunchContext();
        ContainerId containerID = this.container.getContainerId();
        String containerIdStr = containerID.toString();
        List command = launchContext.getCommands();
        int ret = -1;
        try {
            Map<Path, List<String>> localResources = this.getLocalizedResources();
            String user = this.container.getUser();
            ArrayList<String> newCmds = new ArrayList<String>(command.size());
            String appIdStr = this.app.getAppId().toString();
            String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
            containerLogDir = this.dirsHandler.getLogPathForWrite(relativeContainerLogDir, false);
            this.recordContainerLogDir(containerID, containerLogDir.toString());
            for (Object str : command) {
                newCmds.add(ContainerLaunch.expandEnvironment((String)str, containerLogDir));
            }
            launchContext.setCommands(newCmds);
            Map environment = launchContext.getEnvironment();
            for (Map.Entry entry : environment.entrySet()) {
                String value = (String)entry.getValue();
                value = ContainerLaunch.expandEnvironment(value, containerLogDir);
                entry.setValue(value);
            }
            FileContext lfs = FileContext.getLocalFSFileContext();
            Path path = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
            Path nmPrivateTokensPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
            Path nmPrivateClasspathJarDir = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr));
            FSDataOutputStream containerScriptOutStream = null;
            FSDataOutputStream tokensOutStream = null;
            Path containerWorkDir = this.deriveContainerWorkDir();
            this.recordContainerWorkDir(containerID, containerWorkDir.toString());
            String pidFileSubpath = this.getPidFileSubpath(appIdStr, containerIdStr);
            this.pidFilePath = this.dirsHandler.getLocalPathForWrite(pidFileSubpath);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            List<String> filecacheDirs = this.getNMFilecacheDirs(localDirs);
            List<String> userLocalDirs = this.getUserLocalDirs(localDirs);
            List<String> containerLocalDirs = this.getContainerLocalDirs(localDirs);
            List<String> containerLogDirs = this.getContainerLogDirs(logDirs);
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport(false));
            }
            try {
                ArrayList<Path> appDirs = new ArrayList<Path>(localDirs.size());
                for (String localDir : localDirs) {
                    Path usersdir = new Path(localDir, "usercache");
                    Path userdir = new Path(usersdir, user);
                    Path appsdir = new Path(userdir, "appcache");
                    appDirs.add(new Path(appsdir, appIdStr));
                }
                containerScriptOutStream = lfs.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                environment.put("HADOOP_TOKEN_FILE_LOCATION", new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE).toUri().getPath());
                this.sanitizeEnv(environment, containerWorkDir, appDirs, userLocalDirs, containerLogDirs, localResources, nmPrivateClasspathJarDir);
                this.prepareContainer(localResources, containerLocalDirs);
                this.exec.writeLaunchEnv((OutputStream)containerScriptOutStream, environment, localResources, launchContext.getCommands(), new Path(containerLogDirs.get(0)), user);
                tokensOutStream = lfs.create(nmPrivateTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                Credentials creds = this.container.getCredentials();
                creds.writeTokenStorageToStream((DataOutputStream)tokensOutStream);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
            ret = this.launchContainer(new ContainerStartContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setNmPrivateContainerScriptPath(path).setNmPrivateTokensPath(nmPrivateTokensPath).setUser(user).setAppId(appIdStr).setContainerWorkDir(containerWorkDir).setLocalDirs(localDirs).setLogDirs(logDirs).setFilecacheDirs(filecacheDirs).setUserLocalDirs(userLocalDirs).setContainerLocalDirs(containerLocalDirs).setContainerLogDirs(containerLogDirs).build());
        }
        catch (ConfigurationException e) {
            LOG.error("Failed to launch container due to configuration error.", (Throwable)e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            this.context.getNodeStatusUpdater().reportException((Exception)((Object)e));
            Integer n = ret;
            return n;
        }
        catch (Throwable e) {
            LOG.warn("Failed to launch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.setContainerCompletedStatus(ret);
        }
        this.handleContainerExitCode(ret, containerLogDir);
        return ret;
    }

    private Path deriveContainerWorkDir() throws IOException {
        String containerWorkDirPath = "usercache/" + this.container.getUser() + "/" + "appcache" + "/" + this.app.getAppId().toString() + "/" + this.container.getContainerId().toString();
        Path containerWorkDir = this.dirsHandler.getLocalPathForWrite(containerWorkDirPath, -1L, false);
        return containerWorkDir;
    }

    private void prepareContainer(Map<Path, List<String>> localResources, List<String> containerLocalDirs) throws IOException {
        this.exec.prepareContainer(new ContainerPrepareContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setUser(this.container.getUser()).setContainerLocalDirs(containerLocalDirs).setCommands(this.container.getLaunchContext().getCommands()).build());
    }

    protected boolean validateContainerState() {
        if (this.container.getContainerState() == ContainerState.KILLING) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(this.container.getContainerId(), ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
            return false;
        }
        return true;
    }

    protected List<String> getContainerLogDirs(List<String> logDirs) {
        ArrayList<String> containerLogDirs = new ArrayList<String>(logDirs.size());
        String appIdStr = this.app.getAppId().toString();
        String containerIdStr = this.container.getContainerId().toString();
        String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
        for (String logDir : logDirs) {
            containerLogDirs.add(logDir + "/" + relativeContainerLogDir);
        }
        return containerLogDirs;
    }

    protected List<String> getContainerLocalDirs(List<String> localDirs) {
        ArrayList<String> containerLocalDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        String appIdStr = this.app.getAppId().toString();
        String relativeContainerLocalDir = "usercache/" + user + "/" + "appcache" + "/" + appIdStr + "/";
        for (String localDir : localDirs) {
            containerLocalDirs.add(localDir + "/" + relativeContainerLocalDir);
        }
        return containerLocalDirs;
    }

    protected List<String> getUserLocalDirs(List<String> localDirs) {
        ArrayList<String> userLocalDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        for (String localDir : localDirs) {
            String userLocalDir = localDir + "/" + "usercache" + "/" + user + "/";
            userLocalDirs.add(userLocalDir);
        }
        return userLocalDirs;
    }

    protected List<String> getNMFilecacheDirs(List<String> localDirs) {
        ArrayList<String> filecacheDirs = new ArrayList<String>(localDirs.size());
        for (String localDir : localDirs) {
            String filecacheDir = localDir + "/" + "filecache";
            filecacheDirs.add(filecacheDir);
        }
        return filecacheDirs;
    }

    protected Map<Path, List<String>> getLocalizedResources() throws YarnException {
        Map<Path, List<String>> localResources = this.container.getLocalizedResources();
        if (localResources == null) {
            throw RPCUtil.getRemoteException((String)("Unable to get local resources when Container " + this.container + " is at " + (Object)((Object)this.container.getContainerState())));
        }
        return localResources;
    }

    protected int launchContainer(ContainerStartContext ctx) throws IOException, ConfigurationException {
        ContainerId containerId = this.container.getContainerId();
        if (this.container.isMarkedForKilling()) {
            LOG.info("Container " + containerId + " not launched as it has already been marked for Killing");
            this.killedBeforeStart = true;
            return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_LAUNCHED));
        this.context.getNMStateStore().storeContainerLaunched(containerId);
        if (!this.containerAlreadyLaunched.compareAndSet(false, true)) {
            LOG.info("Container " + containerId + " not launched as cleanup already called");
            return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
        }
        this.exec.activateContainer(containerId, this.pidFilePath);
        return this.exec.launchContainer(ctx);
    }

    protected void setContainerCompletedStatus(int exitCode) {
        ContainerId containerId = this.container.getContainerId();
        this.completed.set(true);
        this.exec.deactivateContainer(containerId);
        try {
            if (!this.container.shouldRetry(exitCode)) {
                this.context.getNMStateStore().storeContainerCompleted(containerId, exitCode);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to set exit code for container " + containerId);
        }
    }

    protected void handleContainerExitCode(int exitCode, Path containerLogDir) {
        ContainerId containerId = this.container.getContainerId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + containerId + " completed with exit code " + exitCode);
        }
        StringBuilder diagnosticInfo = new StringBuilder("Container exited with a non-zero exit code ");
        diagnosticInfo.append(exitCode);
        diagnosticInfo.append(". ");
        if (exitCode == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || exitCode == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            if (!this.killedBeforeStart) {
                this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, exitCode, diagnosticInfo.toString()));
            }
        } else if (exitCode != 0) {
            this.handleContainerExitWithFailure(containerId, exitCode, containerLogDir, diagnosticInfo);
        } else {
            LOG.info("Container " + containerId + " succeeded ");
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleContainerExitWithFailure(ContainerId containerID, int ret, Path containerLogDir, StringBuilder diagnosticInfo) {
        FSDataInputStream errorFileIS;
        block6: {
            LOG.warn(diagnosticInfo.toString());
            String errorFileNamePattern = this.conf.get("yarn.nodemanager.container.stderr.pattern", "{*stderr*,*STDERR*}");
            errorFileIS = null;
            try {
                FileSystem fileSystem = FileSystem.getLocal((Configuration)this.conf).getRaw();
                FileStatus[] errorFileStatuses = fileSystem.globStatus(new Path(containerLogDir, errorFileNamePattern));
                if (errorFileStatuses == null || errorFileStatuses.length == 0) break block6;
                long tailSizeInBytes = this.conf.getLong("yarn.nodemanager.container.stderr.tail.bytes", 4096L);
                Path errorFile = errorFileStatuses[0].getPath();
                long fileSize = errorFileStatuses[0].getLen();
                if (errorFileStatuses.length > 1) {
                    String[] errorFileNames = new String[errorFileStatuses.length];
                    long latestModifiedTime = errorFileStatuses[0].getModificationTime();
                    errorFileNames[0] = errorFileStatuses[0].getPath().getName();
                    for (int i = 1; i < errorFileStatuses.length; ++i) {
                        errorFileNames[i] = errorFileStatuses[i].getPath().getName();
                        if (errorFileStatuses[i].getModificationTime() <= latestModifiedTime) continue;
                        latestModifiedTime = errorFileStatuses[i].getModificationTime();
                        errorFile = errorFileStatuses[i].getPath();
                        fileSize = errorFileStatuses[i].getLen();
                    }
                    diagnosticInfo.append("Error files: ").append(StringUtils.join((CharSequence)", ", (String[])errorFileNames)).append(".\n");
                }
                long startPosition = fileSize < tailSizeInBytes ? 0L : fileSize - tailSizeInBytes;
                int bufferSize = (int)(fileSize < tailSizeInBytes ? fileSize : tailSizeInBytes);
                byte[] tailBuffer = new byte[bufferSize];
                errorFileIS = fileSystem.open(errorFile);
                errorFileIS.readFully(startPosition, tailBuffer);
                String tailBufferMsg = new String(tailBuffer, StandardCharsets.UTF_8);
                diagnosticInfo.append("Last ").append(tailSizeInBytes).append(" bytes of ").append(errorFile.getName()).append(" :\n").append(tailBufferMsg).append("\n").append(this.analysesErrorMsgOfContainerExitWithFailure(tailBufferMsg));
            }
            catch (IOException e) {
                try {
                    LOG.error("Failed to get tail of the container's error log file", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
        this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, diagnosticInfo.toString()));
    }

    private String analysesErrorMsgOfContainerExitWithFailure(String errorMsg) {
        StringBuilder analysis = new StringBuilder();
        if (errorMsg.indexOf("Error: Could not find or load main class org.apache.hadoop.mapreduce") != -1) {
            analysis.append("Please check whether your etc/hadoop/mapred-site.xml contains the below configuration:\n");
            analysis.append("<property>\n").append("  <name>yarn.app.mapreduce.am.env</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n<property>\n").append("  <name>mapreduce.map.env</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n<property>\n").append("  <name>mapreduce.reduce.e nv</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n");
        }
        return analysis.toString();
    }

    protected String getPidFileSubpath(String appIdStr, String containerIdStr) {
        return this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format(PID_FILE_NAME_FMT, containerIdStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer() throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = containerId.toString();
        LOG.info("Cleaning up container " + containerIdStr);
        try {
            this.context.getNMStateStore().storeContainerKilled(containerId);
        }
        catch (IOException e) {
            LOG.error("Unable to mark container " + containerId + " killed in store", (Throwable)e);
        }
        boolean bl = alreadyLaunched = !this.containerAlreadyLaunched.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info("Container " + containerIdStr + " not launched. No cleanup needed to be done");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Marking container " + containerIdStr + " as inactive");
        }
        this.exec.deactivateContainer(containerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting pid for container " + containerIdStr + " to kill from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null"));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                String user = this.container.getUser();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
                }
                ContainerExecutor.Signal signal = this.sleepDelayBeforeSigKill > 0L ? ContainerExecutor.Signal.TERM : ContainerExecutor.Signal.KILL;
                boolean result = this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).build());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sent signal " + (Object)((Object)signal) + " to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed"));
                }
                if (this.sleepDelayBeforeSigKill > 0L) {
                    new ContainerExecutor.DelayedProcessKiller(this.container, user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec).start();
                }
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to cleanup container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(message);
            this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
        }
        finally {
            if (this.pidFilePath != null) {
                FileContext lfs = FileContext.getLocalFSFileContext();
                lfs.delete(this.pidFilePath, false);
                lfs.delete(this.pidFilePath.suffix(EXIT_CODE_FILE_SUFFIX), false);
            }
        }
    }

    public void signalContainer(SignalContainerCommand command) throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerTokenIdentifier().getContainerID();
        String containerIdStr = containerId.toString();
        String user = this.container.getUser();
        ContainerExecutor.Signal signal = ContainerLaunch.translateCommandToSignal(command);
        if (signal.equals((Object)ContainerExecutor.Signal.NULL)) {
            LOG.info("ignore signal command " + command);
            return;
        }
        LOG.info("Sending signal " + command + " to container " + containerIdStr);
        boolean bl = alreadyLaunched = !this.containerAlreadyLaunched.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info("Container " + containerIdStr + " not launched. Not sending the signal");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting pid for container " + containerIdStr + " to send signal to from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null"));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
                }
                boolean result = this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).build());
                String diagnostics = "Sent signal " + command + " (" + (Object)((Object)signal) + ") to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed");
                LOG.info(diagnostics);
                this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, diagnostics));
            }
        }
        catch (Exception e) {
            String message = "Exception when sending signal to container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(message);
        }
    }

    @VisibleForTesting
    public static ContainerExecutor.Signal translateCommandToSignal(SignalContainerCommand command) {
        ContainerExecutor.Signal signal = ContainerExecutor.Signal.NULL;
        switch (command) {
            case OUTPUT_THREAD_DUMP: {
                signal = Shell.WINDOWS ? ContainerExecutor.Signal.NULL : ContainerExecutor.Signal.QUIT;
                break;
            }
            case GRACEFUL_SHUTDOWN: {
                signal = ContainerExecutor.Signal.TERM;
                break;
            }
            case FORCEFUL_SHUTDOWN: {
                signal = ContainerExecutor.Signal.KILL;
            }
        }
        return signal;
    }

    private String getContainerPid(Path pidFilePath) throws Exception {
        String containerIdStr = this.container.getContainerId().toString();
        String processId = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accessing pid for container " + containerIdStr + " from pid file " + pidFilePath);
        }
        int sleepCounter = 0;
        int sleepInterval = 100;
        while (true) {
            if ((processId = ProcessIdFileReader.getProcessId(pidFilePath)) != null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Got pid " + processId + " for container " + containerIdStr);
                break;
            }
            if ((long)(sleepCounter * 100) > this.maxKillWaitTime) {
                LOG.info("Could not get pid for " + containerIdStr + ". Waited for " + this.maxKillWaitTime + " ms.");
                break;
            }
            ++sleepCounter;
            Thread.sleep(100L);
        }
        return processId;
    }

    public static String getRelativeContainerLogDir(String appIdStr, String containerIdStr) {
        return appIdStr + "/" + containerIdStr;
    }

    protected String getContainerPrivateDir(String appIdStr, String containerIdStr) {
        return this.getAppPrivateDir(appIdStr) + "/" + containerIdStr + "/";
    }

    private String getAppPrivateDir(String appIdStr) {
        return "nmPrivate/" + appIdStr;
    }

    Context getContext() {
        return this.context;
    }

    private static void putEnvIfNotNull(Map<String, String> environment, String variable, String value) {
        if (value != null) {
            environment.put(variable, value);
        }
    }

    private static void putEnvIfAbsent(Map<String, String> environment, String variable) {
        if (environment.get(variable) == null) {
            ContainerLaunch.putEnvIfNotNull(environment, variable, System.getenv(variable));
        }
    }

    public void sanitizeEnv(Map<String, String> environment, Path pwd, List<Path> appDirs, List<String> userLocalDirs, List<String> containerLogDirs, Map<Path, List<String>> resources, Path nmPrivateClasspathJarDir) throws IOException {
        environment.put(ApplicationConstants.Environment.CONTAINER_ID.name(), this.container.getContainerId().toString());
        environment.put(ApplicationConstants.Environment.NM_PORT.name(), String.valueOf(this.context.getNodeId().getPort()));
        environment.put(ApplicationConstants.Environment.NM_HOST.name(), this.context.getNodeId().getHost());
        environment.put(ApplicationConstants.Environment.NM_HTTP_PORT.name(), String.valueOf(this.context.getHttpPort()));
        environment.put(ApplicationConstants.Environment.LOCAL_DIRS.name(), StringUtils.join((CharSequence)",", appDirs));
        environment.put(ApplicationConstants.Environment.LOCAL_USER_DIRS.name(), StringUtils.join((CharSequence)",", userLocalDirs));
        environment.put(ApplicationConstants.Environment.LOG_DIRS.name(), StringUtils.join((CharSequence)",", containerLogDirs));
        environment.put(ApplicationConstants.Environment.USER.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.LOGNAME.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.HOME.name(), this.conf.get("yarn.nodemanager.user-home-dir", "/home/"));
        environment.put(ApplicationConstants.Environment.PWD.name(), pwd.toString());
        ContainerLaunch.putEnvIfAbsent(environment, ApplicationConstants.Environment.HADOOP_CONF_DIR.name());
        if (!Shell.WINDOWS) {
            environment.put("JVM_PID", "$$");
        }
        String[] whitelist = this.conf.get("yarn.nodemanager.env-whitelist", YarnConfiguration.DEFAULT_NM_ENV_WHITELIST).split(",");
        for (String whitelistEnvVariable : whitelist) {
            ContainerLaunch.putEnvIfAbsent(environment, whitelistEnvVariable.trim());
        }
        Apps.setEnvFromInputString(environment, (String)this.conf.get("yarn.nodemanager.admin-env", "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX"), (String)File.pathSeparator);
        if (Shell.WINDOWS) {
            this.sanitizeWindowsEnv(environment, pwd, resources, nmPrivateClasspathJarDir);
        }
        for (Map.Entry entry : this.containerManager.getAuxServiceMetaData().entrySet()) {
            AuxiliaryServiceHelper.setServiceDataIntoEnv((String)((String)entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue()), environment);
        }
    }

    private void sanitizeWindowsEnv(Map<String, String> environment, Path pwd, Map<Path, List<String>> resources, Path nmPrivateClasspathJarDir) throws IOException {
        String inputClassPath = environment.get(ApplicationConstants.Environment.CLASSPATH.name());
        if (inputClassPath != null && !inputClassPath.isEmpty()) {
            boolean preferLocalizedJars = Boolean.parseBoolean(environment.get(ApplicationConstants.Environment.CLASSPATH_PREPEND_DISTCACHE.name()));
            boolean needsSeparator = false;
            StringBuilder newClassPath = new StringBuilder();
            if (!preferLocalizedJars) {
                newClassPath.append(inputClassPath);
                needsSeparator = true;
            }
            for (Map.Entry<Path, List<String>> entry : resources.entrySet()) {
                boolean targetIsDirectory = new File(entry.getKey().toUri().getPath()).isDirectory();
                for (String linkName : entry.getValue()) {
                    if (needsSeparator) {
                        newClassPath.append(File.pathSeparator);
                    } else {
                        needsSeparator = true;
                    }
                    newClassPath.append(pwd.toString()).append("/").append(linkName);
                    if (!targetIsDirectory) continue;
                    newClassPath.append("/");
                }
            }
            if (preferLocalizedJars) {
                if (needsSeparator) {
                    newClassPath.append(File.pathSeparator);
                }
                newClassPath.append(inputClassPath);
            }
            HashMap<String, String> mergedEnv = new HashMap<String, String>(System.getenv());
            mergedEnv.putAll(environment);
            Path jarDir = this.exec instanceof WindowsSecureContainerExecutor ? nmPrivateClasspathJarDir : pwd;
            String[] jarCp = FileUtil.createJarWithClassPath((String)newClassPath.toString(), (Path)jarDir, (Path)pwd, mergedEnv);
            Path localizedClassPathJar = this.exec.localizeClasspathJar(new Path(jarCp[0]), pwd, this.container.getUser());
            String replacementClassPath = localizedClassPathJar.toString() + jarCp[1];
            environment.put(ApplicationConstants.Environment.CLASSPATH.name(), replacementClassPath);
        }
    }

    public static String getExitCodeFile(String pidFile) {
        return pidFile + EXIT_CODE_FILE_SUFFIX;
    }

    private void recordContainerLogDir(ContainerId containerId, String logDir) throws IOException {
        this.container.setLogDir(logDir);
        if (this.container.isRetryContextSet()) {
            this.context.getNMStateStore().storeContainerLogDir(containerId, logDir);
        }
    }

    private void recordContainerWorkDir(ContainerId containerId, String workDir) throws IOException {
        this.container.setWorkDir(workDir);
        if (this.container.isRetryContextSet()) {
            this.context.getNMStateStore().storeContainerWorkDir(containerId, workDir);
        }
    }

    private static final class WindowsShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("@if %errorlevel% neq 0 exit /b %errorlevel%");
        }

        private void lineWithLenCheck(String ... commands) throws IOException {
            Shell.checkWindowsCommandLineLength((String[])commands);
            this.line(commands);
        }

        public WindowsShellScriptBuilder() {
            this.line("@setlocal");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) throws IOException {
            this.lineWithLenCheck("@call ", StringUtils.join((CharSequence)" ", command));
            this.errorCheck();
        }

        @Override
        public void whitelistedEnv(String key, String value) throws IOException {
            this.lineWithLenCheck("@set ", key, "=", value);
            this.errorCheck();
        }

        @Override
        public void env(String key, String value) throws IOException {
            this.lineWithLenCheck("@set ", key, "=", value);
            this.errorCheck();
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            File srcFile = new File(src.toUri().getPath());
            String srcFileStr = srcFile.getPath();
            String dstFileStr = new File(dst.toString()).getPath();
            this.lineWithLenCheck(String.format("@%s symlink \"%s\" \"%s\"", Shell.getWinUtilsPath(), dstFileStr, srcFileStr));
            this.errorCheck();
        }

        @Override
        protected void mkdir(Path path) throws IOException {
            this.lineWithLenCheck(String.format("@if not exist \"%s\" mkdir \"%s\"", path.toString(), path.toString()));
            this.errorCheck();
        }

        @Override
        public void copyDebugInformation(Path src, Path dest) throws IOException {
            this.line("rem Creating copy of launch script");
            this.lineWithLenCheck(String.format("copy \"%s\" \"%s\"", src.toString(), dest.toString()));
        }

        @Override
        public void listDebugInformation(Path output) throws IOException {
            this.line("rem Determining directory contents");
            this.lineWithLenCheck(String.format("@echo \"dir:\" > \"%s\"", output.toString()));
            this.lineWithLenCheck(String.format("dir >> \"%s\"", output.toString()));
        }
    }

    private static final class UnixShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("hadoop_shell_errorcode=$?");
            this.line("if [ $hadoop_shell_errorcode -ne 0 ]");
            this.line("then");
            this.line("  exit $hadoop_shell_errorcode");
            this.line("fi");
        }

        public UnixShellScriptBuilder() {
            this.line("#!/bin/bash");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("exec /bin/bash -c \"", StringUtils.join((CharSequence)" ", command), "\"");
            this.errorCheck();
        }

        @Override
        public void whitelistedEnv(String key, String value) {
            this.line("export ", key, "=${", key, ":-", "\"", value, "\"}");
        }

        @Override
        public void env(String key, String value) {
            this.line("export ", key, "=\"", value, "\"");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            this.line("ln -sf \"", src.toUri().getPath(), "\" \"", dst.toString(), "\"");
            this.errorCheck();
        }

        @Override
        protected void mkdir(Path path) {
            this.line("mkdir -p ", path.toString());
            this.errorCheck();
        }

        @Override
        public void copyDebugInformation(Path src, Path dest) throws IOException {
            this.line("# Creating copy of launch script");
            this.line("cp \"", src.toUri().getPath(), "\" \"", dest.toUri().getPath(), "\"");
            if (dest.isAbsolute()) {
                this.line("chmod 640 \"", dest.toUri().getPath(), "\"");
            }
        }

        @Override
        public void listDebugInformation(Path output) throws IOException {
            this.line("# Determining directory contents");
            this.line("echo \"ls -l:\" 1>\"", output.toString(), "\"");
            this.line("ls -l 1>>\"", output.toString(), "\"");
            this.line("echo \"find -L . -maxdepth 5 -ls:\" 1>>\"", output.toString(), "\"");
            this.line("find -L . -maxdepth 5 -ls 1>>\"", output.toString(), "\"");
            this.line("echo \"broken symlinks(find -L . -maxdepth 5 -type l -ls):\" 1>>\"", output.toString(), "\"");
            this.line("find -L . -maxdepth 5 -type l -ls 1>>\"", output.toString(), "\"");
        }

        @Override
        public void setExitOnFailure() {
            this.line("set -o pipefail -e");
        }
    }

    public static abstract class ShellScriptBuilder {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final StringBuilder sb = new StringBuilder();

        public static ShellScriptBuilder create() {
            return Shell.WINDOWS ? new WindowsShellScriptBuilder() : new UnixShellScriptBuilder();
        }

        public abstract void command(List<String> var1) throws IOException;

        public abstract void whitelistedEnv(String var1, String var2) throws IOException;

        public abstract void env(String var1, String var2) throws IOException;

        public final void symlink(Path src, Path dst) throws IOException {
            if (!src.isAbsolute()) {
                throw new IOException("Source must be absolute");
            }
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            if (dst.toUri().getPath().indexOf(47) != -1) {
                this.mkdir(dst.getParent());
            }
            this.link(src, dst);
        }

        public abstract void copyDebugInformation(Path var1, Path var2) throws IOException;

        public abstract void listDebugInformation(Path var1) throws IOException;

        public String toString() {
            return this.sb.toString();
        }

        public final void write(PrintStream out) throws IOException {
            out.append(this.sb);
        }

        protected final void line(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
            this.sb.append(LINE_SEPARATOR);
        }

        public void setExitOnFailure() {
        }

        protected abstract void link(Path var1, Path var2) throws IOException;

        protected abstract void mkdir(Path var1) throws IOException;
    }
}

