/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreServiceFactory;
import org.apache.hadoop.mapreduce.v2.hs.JHSDelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.server.HSAdminServer;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;

public class JobHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    public static final long historyServerTimeStamp = System.currentTimeMillis();
    private static final Log LOG = LogFactory.getLog(JobHistoryServer.class);
    protected HistoryContext historyContext;
    private HistoryClientService clientService;
    private JobHistory jobHistoryService;
    protected JHSDelegationTokenSecretManager jhsDTSecretManager;
    private AggregatedLogDeletionService aggLogDelService;
    private HSAdminServer hsAdminServer;
    private HistoryServerStateStoreService stateStore;
    private JvmPauseMonitor pauseMonitor;

    public JobHistoryServer() {
        super(JobHistoryServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        YarnConfiguration config = new YarnConfiguration(conf);
        MRWebAppUtil.initialize((Configuration)this.getConfig());
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("History Server Failed to login", (Throwable)ie);
        }
        this.jobHistoryService = new JobHistory();
        this.historyContext = this.jobHistoryService;
        this.stateStore = this.createStateStore(conf);
        this.jhsDTSecretManager = this.createJHSSecretManager(conf, this.stateStore);
        this.clientService = this.createHistoryClientService();
        this.aggLogDelService = new AggregatedLogDeletionService();
        this.hsAdminServer = new HSAdminServer(this.aggLogDelService, this.jobHistoryService);
        this.addService((Service)this.stateStore);
        this.addService((Service)new HistoryServerSecretManagerService());
        this.addService((Service)this.jobHistoryService);
        this.addService((Service)this.clientService);
        this.addService((Service)this.aggLogDelService);
        this.addService((Service)this.hsAdminServer);
        DefaultMetricsSystem.initialize((String)"JobHistoryServer");
        JvmMetrics jm = JvmMetrics.initSingleton((String)"JobHistoryServer", null);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        jm.setPauseMonitor(this.pauseMonitor);
        super.serviceInit((Configuration)config);
    }

    @VisibleForTesting
    protected HistoryClientService createHistoryClientService() {
        return new HistoryClientService(this.historyContext, this.jhsDTSecretManager);
    }

    protected JHSDelegationTokenSecretManager createJHSSecretManager(Configuration conf, HistoryServerStateStoreService store) {
        long secretKeyInterval = conf.getLong("mapreduce.cluster.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("mapreduce.cluster.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("mapreduce.cluster.delegation.token.renew-interval", 86400000L);
        return new JHSDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L, store);
    }

    protected HistoryServerStateStoreService createStateStore(Configuration conf) {
        return HistoryServerStateStoreServiceFactory.getStore(conf);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        InetSocketAddress socAddr = JobHistoryServer.getBindAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobhistory.keytab", (String)"mapreduce.jobhistory.principal", (String)socAddr.getHostName());
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("mapreduce.jobhistory.address", "0.0.0.0:10020", 10020);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public HistoryClientService getClientService() {
        return this.clientService;
    }

    static JobHistoryServer launchJobHistoryServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(JobHistoryServer.class, (String[])args, (Log)LOG);
        JobHistoryServer jobHistoryServer = null;
        try {
            jobHistoryServer = new JobHistoryServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)jobHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
            new GenericOptionsParser((Configuration)conf, args);
            jobHistoryServer.init((Configuration)conf);
            jobHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting JobHistoryServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting JobHistoryServer");
        }
        return jobHistoryServer;
    }

    public static void main(String[] args) {
        JobHistoryServer.launchJobHistoryServer(args);
    }

    private class HistoryServerSecretManagerService
    extends AbstractService {
        public HistoryServerSecretManagerService() {
            super(HistoryServerSecretManagerService.class.getName());
        }

        protected void serviceStart() throws Exception {
            boolean recoveryEnabled = this.getConfig().getBoolean("mapreduce.jobhistory.recovery.enable", false);
            if (recoveryEnabled) {
                assert (JobHistoryServer.this.stateStore.isInState(Service.STATE.STARTED));
                HistoryServerStateStoreService.HistoryServerState state = JobHistoryServer.this.stateStore.loadState();
                JobHistoryServer.this.jhsDTSecretManager.recover(state);
            }
            try {
                JobHistoryServer.this.jhsDTSecretManager.startThreads();
            }
            catch (IOException io) {
                LOG.error((Object)"Error while starting the Secret Manager threads", (Throwable)io);
                throw io;
            }
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            if (JobHistoryServer.this.jhsDTSecretManager != null) {
                JobHistoryServer.this.jhsDTSecretManager.stopThreads();
            }
            super.serviceStop();
        }
    }
}

