/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.HistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.concurrent.HadoopScheduledThreadPoolExecutor;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;

public class JobHistory
extends AbstractService
implements HistoryContext {
    private static final Log LOG = LogFactory.getLog(JobHistory.class);
    public static final Pattern CONF_FILENAME_REGEX = Pattern.compile("(job_[0-9]+_[0-9]+)_conf.xml(?:\\.[0-9]+\\.old)?");
    public static final String OLD_SUFFIX = ".old";
    private long moveThreadInterval;
    private Configuration conf;
    private ScheduledThreadPoolExecutor scheduledExecutor = null;
    private HistoryStorage storage = null;
    private HistoryFileManager hsManager = null;
    ScheduledFuture<?> futureHistoryCleaner = null;
    private long cleanerInterval;
    private ApplicationAttemptId appAttemptID;
    private ApplicationId appID;
    private String userName;

    protected void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"JobHistory Init");
        this.conf = conf;
        this.appID = ApplicationId.newInstance((long)0L, (int)0);
        this.appAttemptID = (ApplicationAttemptId)RecordFactoryProvider.getRecordFactory((Configuration)conf).newRecordInstance(ApplicationAttemptId.class);
        this.moveThreadInterval = conf.getLong("mapreduce.jobhistory.move.interval-ms", 180000L);
        this.hsManager = this.createHistoryFileManager();
        this.hsManager.init(conf);
        try {
            this.hsManager.initExisting();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to intialize existing directories", (Throwable)e);
        }
        this.storage = this.createHistoryStorage();
        if (this.storage instanceof Service) {
            ((Service)this.storage).init(conf);
        }
        this.storage.setHistoryFileManager(this.hsManager);
        super.serviceInit(conf);
    }

    protected HistoryStorage createHistoryStorage() {
        return (HistoryStorage)ReflectionUtils.newInstance((Class)this.conf.getClass("mapreduce.jobhistory.store.class", CachedHistoryStorage.class, HistoryStorage.class), (Configuration)this.conf);
    }

    protected HistoryFileManager createHistoryFileManager() {
        return new HistoryFileManager();
    }

    protected void serviceStart() throws Exception {
        this.hsManager.start();
        if (this.storage instanceof Service) {
            ((Service)this.storage).start();
        }
        this.scheduledExecutor = new HadoopScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setNameFormat("Log Scanner/Cleaner #%d").build());
        this.scheduledExecutor.scheduleAtFixedRate(new MoveIntermediateToDoneRunnable(), this.moveThreadInterval, this.moveThreadInterval, TimeUnit.MILLISECONDS);
        this.scheduleHistoryCleaner();
        super.serviceStart();
    }

    protected int getInitDelaySecs() {
        return 30;
    }

    protected void serviceStop() throws Exception {
        LOG.info((Object)"Stopping JobHistory");
        if (this.scheduledExecutor != null) {
            LOG.info((Object)"Stopping History Cleaner/Move To Done");
            this.scheduledExecutor.shutdown();
            boolean interrupted = false;
            long currentTime = System.currentTimeMillis();
            while (!this.scheduledExecutor.isShutdown() && System.currentTimeMillis() > currentTime + 1000L && !interrupted) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (!this.scheduledExecutor.isShutdown()) {
                LOG.warn((Object)"HistoryCleanerService/move to done shutdown may not have succeeded, Forcing a shutdown");
                this.scheduledExecutor.shutdownNow();
            }
        }
        if (this.storage != null && this.storage instanceof Service) {
            ((Service)this.storage).stop();
        }
        if (this.hsManager != null) {
            this.hsManager.stop();
        }
        super.serviceStop();
    }

    public JobHistory() {
        super(JobHistory.class.getName());
    }

    public String getApplicationName() {
        return "Job History Server";
    }

    HistoryFileManager.HistoryFileInfo getJobFileInfo(JobId jobId) throws IOException {
        return this.hsManager.getFileInfo(jobId);
    }

    public Job getJob(JobId jobId) {
        return this.storage.getFullJob(jobId);
    }

    @Override
    public Map<JobId, Job> getAllJobs(ApplicationId appID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Called getAllJobs(AppId): " + appID));
        }
        JobID oldJobID = TypeConverter.fromYarn((ApplicationId)appID);
        HashMap<JobId, Job> jobs = new HashMap<JobId, Job>();
        JobId jobID = TypeConverter.toYarn((JobID)oldJobID);
        jobs.put(jobID, this.getJob(jobID));
        return jobs;
    }

    public Map<JobId, Job> getAllJobs() {
        return this.storage.getAllPartialJobs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshLoadedJobCache() {
        if (this.getServiceState() == Service.STATE.STARTED) {
            if (!(this.storage instanceof CachedHistoryStorage)) throw new UnsupportedOperationException(this.storage.getClass().getName() + " is expected to be an instance of " + CachedHistoryStorage.class.getName());
            ((CachedHistoryStorage)this.storage).refreshLoadedJobCache();
            return;
        } else {
            LOG.warn((Object)"Failed to execute refreshLoadedJobCache: JobHistory service is not started");
        }
    }

    @VisibleForTesting
    HistoryStorage getHistoryStorage() {
        return this.storage;
    }

    @Override
    public JobsInfo getPartialJobs(Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        return this.storage.getPartialJobs(offset, count, user, queue, sBegin, sEnd, fBegin, fEnd, jobState);
    }

    public void refreshJobRetentionSettings() {
        if (this.getServiceState() == Service.STATE.STARTED) {
            this.conf = this.createConf();
            long maxHistoryAge = this.conf.getLong("mapreduce.jobhistory.max-age-ms", 604800000L);
            this.hsManager.setMaxHistoryAge(maxHistoryAge);
            if (this.futureHistoryCleaner != null) {
                this.futureHistoryCleaner.cancel(false);
            }
            this.futureHistoryCleaner = null;
            this.scheduleHistoryCleaner();
        } else {
            LOG.warn((Object)"Failed to execute refreshJobRetentionSettings : Job History service is not started");
        }
    }

    private void scheduleHistoryCleaner() {
        boolean startCleanerService = this.conf.getBoolean("mapreduce.jobhistory.cleaner.enable", true);
        if (startCleanerService) {
            this.cleanerInterval = this.conf.getLong("mapreduce.jobhistory.cleaner.interval-ms", 86400000L);
            this.futureHistoryCleaner = this.scheduledExecutor.scheduleAtFixedRate(new HistoryCleaner(), (long)this.getInitDelaySecs() * 1000L, this.cleanerInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected Configuration createConf() {
        return new Configuration();
    }

    public long getCleanerInterval() {
        return this.cleanerInterval;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptID;
    }

    public ApplicationId getApplicationID() {
        return this.appID;
    }

    public EventHandler<Event> getEventHandler() {
        return null;
    }

    public CharSequence getUser() {
        if (this.userName != null) {
            this.userName = this.conf.get("mapreduce.job.user.name", "history-user");
        }
        return this.userName;
    }

    public Clock getClock() {
        return null;
    }

    public ClusterInfo getClusterInfo() {
        return null;
    }

    public Set<String> getBlacklistedNodes() {
        return null;
    }

    public ClientToAMTokenSecretManager getClientToAMTokenSecretManager() {
        return null;
    }

    public boolean isLastAMRetry() {
        return false;
    }

    public boolean hasSuccessfullyUnregistered() {
        return true;
    }

    public String getNMHostname() {
        return null;
    }

    public TaskAttemptFinishingMonitor getTaskAttemptFinishingMonitor() {
        return null;
    }

    public String getHistoryUrl() {
        return null;
    }

    public void setHistoryUrl(String historyUrl) {
    }

    private class HistoryCleaner
    implements Runnable {
        private HistoryCleaner() {
        }

        @Override
        public void run() {
            LOG.info((Object)"History Cleaner started");
            try {
                JobHistory.this.hsManager.clean();
            }
            catch (IOException e) {
                LOG.warn((Object)"Error trying to clean up ", (Throwable)e);
            }
            LOG.info((Object)"History Cleaner complete");
        }
    }

    private class MoveIntermediateToDoneRunnable
    implements Runnable {
        private MoveIntermediateToDoneRunnable() {
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)"Starting scan to move intermediate done files");
                JobHistory.this.hsManager.scanIntermediateDirectory();
            }
            catch (IOException e) {
                LOG.error((Object)"Error while scanning intermediate done dir ", (Throwable)e);
            }
        }
    }
}

