/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTask;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Records;

public class CompletedJob
implements Job {
    private static final int UNDEFINED_VALUE = -1;
    static final Log LOG = LogFactory.getLog(CompletedJob.class);
    private final Configuration conf;
    private final JobId jobId;
    private final String user;
    private final HistoryFileManager.HistoryFileInfo info;
    private JobHistoryParser.JobInfo jobInfo;
    private JobReport report;
    AtomicBoolean tasksLoaded = new AtomicBoolean(false);
    private Lock tasksLock = new ReentrantLock();
    private Map<TaskId, Task> tasks = new HashMap<TaskId, Task>();
    private Map<TaskId, Task> mapTasks = new HashMap<TaskId, Task>();
    private Map<TaskId, Task> reduceTasks = new HashMap<TaskId, Task>();
    private List<TaskAttemptCompletionEvent> completionEvents = null;
    private List<TaskAttemptCompletionEvent> mapCompletionEvents = null;
    private JobACLsManager aclsMgr;

    public CompletedJob(Configuration conf, JobId jobId, Path historyFile, boolean loadTasks, String userName, HistoryFileManager.HistoryFileInfo info, JobACLsManager aclsMgr) throws IOException {
        LOG.info((Object)("Loading job: " + jobId + " from file: " + historyFile));
        this.conf = conf;
        this.jobId = jobId;
        this.user = userName;
        this.info = info;
        this.aclsMgr = aclsMgr;
        this.loadFullHistoryData(loadTasks, historyFile);
    }

    public int getCompletedMaps() {
        int killedMaps = (int)this.jobInfo.getKilledMaps();
        int failedMaps = (int)this.jobInfo.getFailedMaps();
        if (killedMaps == -1) {
            killedMaps = 0;
        }
        if (failedMaps == -1) {
            failedMaps = 0;
        }
        return (int)(this.jobInfo.getSucceededMaps() + (long)killedMaps + (long)failedMaps);
    }

    public int getCompletedReduces() {
        int killedReduces = (int)this.jobInfo.getKilledReduces();
        int failedReduces = (int)this.jobInfo.getFailedReduces();
        if (killedReduces == -1) {
            killedReduces = 0;
        }
        if (failedReduces == -1) {
            failedReduces = 0;
        }
        return (int)(this.jobInfo.getSucceededReduces() + (long)killedReduces + (long)failedReduces);
    }

    public Counters getAllCounters() {
        return this.jobInfo.getTotalCounters();
    }

    public JobId getID() {
        return this.jobId;
    }

    public synchronized JobReport getReport() {
        if (this.report == null) {
            this.constructJobReport();
        }
        return this.report;
    }

    private void constructJobReport() {
        this.report = (JobReport)Records.newRecord(JobReport.class);
        this.report.setJobId(this.jobId);
        this.report.setJobState(JobState.valueOf((String)this.jobInfo.getJobStatus()));
        this.report.setSubmitTime(this.jobInfo.getSubmitTime());
        this.report.setStartTime(this.jobInfo.getLaunchTime());
        this.report.setFinishTime(this.jobInfo.getFinishTime());
        this.report.setJobName(this.jobInfo.getJobname());
        this.report.setUser(this.jobInfo.getUsername());
        this.report.setDiagnostics(this.jobInfo.getErrorInfo());
        if (this.getTotalMaps() == 0) {
            this.report.setMapProgress(1.0f);
        } else {
            this.report.setMapProgress((float)this.getCompletedMaps() / (float)this.getTotalMaps());
        }
        if (this.getTotalReduces() == 0) {
            this.report.setReduceProgress(1.0f);
        } else {
            this.report.setReduceProgress((float)this.getCompletedReduces() / (float)this.getTotalReduces());
        }
        this.report.setJobFile(this.getConfFile().toString());
        String historyUrl = "N/A";
        try {
            historyUrl = MRWebAppUtil.getApplicationWebURLOnJHSWithScheme((Configuration)this.conf, (ApplicationId)this.jobId.getAppId());
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Problem determining local host: " + e.getMessage()));
        }
        this.report.setTrackingUrl(historyUrl);
        this.report.setAMInfos(this.getAMInfos());
        this.report.setIsUber(this.isUber());
        this.report.setHistoryFile(this.info.getHistoryFile().toString());
    }

    public float getProgress() {
        return 1.0f;
    }

    public JobState getState() {
        return JobState.valueOf((String)this.jobInfo.getJobStatus());
    }

    public Task getTask(TaskId taskId) {
        if (this.tasksLoaded.get()) {
            return this.tasks.get(taskId);
        }
        TaskID oldTaskId = TypeConverter.fromYarn((TaskId)taskId);
        CompletedTask completedTask = new CompletedTask(taskId, (JobHistoryParser.TaskInfo)this.jobInfo.getAllTasks().get(oldTaskId));
        return completedTask;
    }

    public synchronized TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        if (this.completionEvents == null) {
            this.constructTaskAttemptCompletionEvents();
        }
        return CompletedJob.getAttemptCompletionEvents(this.completionEvents, fromEventId, maxEvents);
    }

    public synchronized TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        if (this.mapCompletionEvents == null) {
            this.constructTaskAttemptCompletionEvents();
        }
        return TypeConverter.fromYarn((TaskAttemptCompletionEvent[])CompletedJob.getAttemptCompletionEvents(this.mapCompletionEvents, startIndex, maxEvents));
    }

    private static TaskAttemptCompletionEvent[] getAttemptCompletionEvents(List<TaskAttemptCompletionEvent> eventList, int startIndex, int maxEvents) {
        TaskAttemptCompletionEvent[] events = new TaskAttemptCompletionEvent[]{};
        if (eventList.size() > startIndex) {
            int actualMax = Math.min(maxEvents, eventList.size() - startIndex);
            events = eventList.subList(startIndex, actualMax + startIndex).toArray(events);
        }
        return events;
    }

    private void constructTaskAttemptCompletionEvents() {
        this.loadAllTasks();
        this.completionEvents = new LinkedList<TaskAttemptCompletionEvent>();
        LinkedList<TaskAttempt> allTaskAttempts = new LinkedList<TaskAttempt>();
        int numMapAttempts = 0;
        for (Map.Entry<TaskId, Task> taskEntry : this.tasks.entrySet()) {
            Task task = taskEntry.getValue();
            for (Map.Entry taskAttemptEntry : task.getAttempts().entrySet()) {
                TaskAttempt taskAttempt = (TaskAttempt)taskAttemptEntry.getValue();
                allTaskAttempts.add(taskAttempt);
                if (task.getType() != TaskType.MAP) continue;
                ++numMapAttempts;
            }
        }
        Collections.sort(allTaskAttempts, new Comparator<TaskAttempt>(){

            @Override
            public int compare(TaskAttempt o1, TaskAttempt o2) {
                if (o1.getFinishTime() == 0L || o2.getFinishTime() == 0L) {
                    if (o1.getFinishTime() == 0L && o2.getFinishTime() == 0L) {
                        if (o1.getLaunchTime() == 0L || o2.getLaunchTime() == 0L) {
                            if (o1.getLaunchTime() == 0L && o2.getLaunchTime() == 0L) {
                                return 0;
                            }
                            long res = o1.getLaunchTime() - o2.getLaunchTime();
                            return res > 0L ? -1 : 1;
                        }
                        return (int)(o1.getLaunchTime() - o2.getLaunchTime());
                    }
                    long res = o1.getFinishTime() - o2.getFinishTime();
                    return res > 0L ? -1 : 1;
                }
                return (int)(o1.getFinishTime() - o2.getFinishTime());
            }
        });
        this.mapCompletionEvents = new ArrayList<TaskAttemptCompletionEvent>(numMapAttempts);
        int eventId = 0;
        for (TaskAttempt taskAttempt : allTaskAttempts) {
            TaskAttemptCompletionEvent tace = (TaskAttemptCompletionEvent)Records.newRecord(TaskAttemptCompletionEvent.class);
            int attemptRunTime = -1;
            if (taskAttempt.getLaunchTime() != 0L && taskAttempt.getFinishTime() != 0L) {
                attemptRunTime = (int)(taskAttempt.getFinishTime() - taskAttempt.getLaunchTime());
            }
            TaskAttemptCompletionEventStatus taceStatus = TaskAttemptCompletionEventStatus.KILLED;
            String taStateString = taskAttempt.getState().toString();
            try {
                taceStatus = TaskAttemptCompletionEventStatus.valueOf((String)taStateString);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot constuct TACEStatus from TaskAtemptState: [" + taStateString + "] for taskAttemptId: [" + taskAttempt.getID() + "]. Defaulting to KILLED"));
            }
            tace.setAttemptId(taskAttempt.getID());
            tace.setAttemptRunTime(attemptRunTime);
            tace.setEventId(eventId++);
            tace.setMapOutputServerAddress(taskAttempt.getAssignedContainerMgrAddress());
            tace.setStatus(taceStatus);
            this.completionEvents.add(tace);
            if (taskAttempt.getID().getTaskId().getTaskType() != TaskType.MAP) continue;
            this.mapCompletionEvents.add(tace);
        }
    }

    public Map<TaskId, Task> getTasks() {
        this.loadAllTasks();
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllTasks() {
        if (this.tasksLoaded.get()) {
            return;
        }
        this.tasksLock.lock();
        try {
            if (this.tasksLoaded.get()) {
                return;
            }
            for (Map.Entry entry : this.jobInfo.getAllTasks().entrySet()) {
                TaskId yarnTaskID = TypeConverter.toYarn((org.apache.hadoop.mapreduce.TaskID)((org.apache.hadoop.mapreduce.TaskID)entry.getKey()));
                JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)entry.getValue();
                CompletedTask task = new CompletedTask(yarnTaskID, taskInfo);
                this.tasks.put(yarnTaskID, task);
                if (task.getType() == TaskType.MAP) {
                    this.mapTasks.put(task.getID(), task);
                    continue;
                }
                if (task.getType() != TaskType.REDUCE) continue;
                this.reduceTasks.put(task.getID(), task);
            }
            this.tasksLoaded.set(true);
        }
        finally {
            this.tasksLock.unlock();
        }
    }

    protected JobHistoryParser createJobHistoryParser(Path historyFileAbsolute) throws IOException {
        return new JobHistoryParser(historyFileAbsolute.getFileSystem(this.conf), historyFileAbsolute);
    }

    protected synchronized void loadFullHistoryData(boolean loadTasks, Path historyFileAbsolute) throws IOException {
        LOG.info((Object)("Loading history file: [" + historyFileAbsolute + "]"));
        if (this.jobInfo != null) {
            return;
        }
        if (historyFileAbsolute != null) {
            JobHistoryParser parser = null;
            try {
                parser = this.createJobHistoryParser(historyFileAbsolute);
                this.jobInfo = parser.parse();
            }
            catch (IOException e) {
                throw new YarnRuntimeException("Could not load history file " + historyFileAbsolute, (Throwable)e);
            }
            IOException parseException = parser.getParseException();
            if (parseException != null) {
                throw new YarnRuntimeException("Could not parse history file " + historyFileAbsolute, (Throwable)parseException);
            }
        } else {
            throw new IOException("History file not found");
        }
        if (loadTasks) {
            this.loadAllTasks();
            LOG.info((Object)"TaskInfo loaded");
        }
    }

    public List<String> getDiagnostics() {
        return Collections.singletonList(this.jobInfo.getErrorInfo());
    }

    public String getName() {
        return this.jobInfo.getJobname();
    }

    public String getQueueName() {
        return this.jobInfo.getJobQueueName();
    }

    public int getTotalMaps() {
        return (int)this.jobInfo.getTotalMaps();
    }

    public int getTotalReduces() {
        return (int)this.jobInfo.getTotalReduces();
    }

    public boolean isUber() {
        return this.jobInfo.getUberized();
    }

    public Map<TaskId, Task> getTasks(TaskType taskType) {
        this.loadAllTasks();
        if (TaskType.MAP.equals((Object)taskType)) {
            return this.mapTasks;
        }
        return this.reduceTasks;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        Map jobACLs = this.jobInfo.getJobACLs();
        AccessControlList jobACL = (AccessControlList)jobACLs.get(jobOperation);
        if (jobACL == null) {
            return true;
        }
        return this.aclsMgr.checkAccess(callerUGI, jobOperation, this.jobInfo.getUsername(), jobACL);
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        return this.jobInfo.getJobACLs();
    }

    public String getUserName() {
        return this.user;
    }

    public Path getConfFile() {
        return this.info.getConfFile();
    }

    public Configuration loadConfFile() throws IOException {
        return this.info.loadConfFile();
    }

    public List<AMInfo> getAMInfos() {
        LinkedList<AMInfo> amInfos = new LinkedList<AMInfo>();
        for (JobHistoryParser.AMInfo jhAmInfo : this.jobInfo.getAMInfos()) {
            AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)jhAmInfo.getAppAttemptId(), (long)jhAmInfo.getStartTime(), (ContainerId)jhAmInfo.getContainerId(), (String)jhAmInfo.getNodeManagerHost(), (int)jhAmInfo.getNodeManagerPort(), (int)jhAmInfo.getNodeManagerHttpPort());
            amInfos.add(amInfo);
        }
        return amInfos;
    }

    public void setQueueName(String queueName) {
        throw new UnsupportedOperationException("Can't set job's queue name in history");
    }

    public void setJobPriority(Priority priority) {
        throw new UnsupportedOperationException("Can't set job's priority in history");
    }

    public int getFailedMaps() {
        return (int)this.jobInfo.getFailedMaps();
    }

    public int getFailedReduces() {
        return (int)this.jobInfo.getFailedReduces();
    }

    public int getKilledMaps() {
        return (int)this.jobInfo.getKilledMaps();
    }

    public int getKilledReduces() {
        return (int)this.jobInfo.getKilledReduces();
    }
}

