/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ErasureCodeConstants;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class SystemErasureCodingPolicies {
    private static final int DEFAULT_CELLSIZE = 0x100000;
    public static final byte RS_6_3_POLICY_ID = 1;
    private static final ErasureCodingPolicy SYS_POLICY1 = new ErasureCodingPolicy(ErasureCodeConstants.RS_6_3_SCHEMA, 0x100000, 1);
    public static final byte RS_3_2_POLICY_ID = 2;
    private static final ErasureCodingPolicy SYS_POLICY2 = new ErasureCodingPolicy(ErasureCodeConstants.RS_3_2_SCHEMA, 0x100000, 2);
    public static final byte RS_6_3_LEGACY_POLICY_ID = 3;
    private static final ErasureCodingPolicy SYS_POLICY3 = new ErasureCodingPolicy(ErasureCodeConstants.RS_6_3_LEGACY_SCHEMA, 0x100000, 3);
    public static final byte XOR_2_1_POLICY_ID = 4;
    private static final ErasureCodingPolicy SYS_POLICY4 = new ErasureCodingPolicy(ErasureCodeConstants.XOR_2_1_SCHEMA, 0x100000, 4);
    public static final byte RS_10_4_POLICY_ID = 5;
    private static final ErasureCodingPolicy SYS_POLICY5 = new ErasureCodingPolicy(ErasureCodeConstants.RS_10_4_SCHEMA, 0x100000, 5);
    private static final ErasureCodingPolicy REPLICATION_POLICY = new ErasureCodingPolicy("replication", ErasureCodeConstants.REPLICATION_1_2_SCHEMA, 0x100000, 63);
    private static final List<ErasureCodingPolicy> SYS_POLICIES = Collections.unmodifiableList(Arrays.asList(SYS_POLICY1, SYS_POLICY2, SYS_POLICY3, SYS_POLICY4, SYS_POLICY5));
    private static final Map<String, ErasureCodingPolicy> SYSTEM_POLICIES_BY_NAME = new TreeMap<String, ErasureCodingPolicy>();
    private static final Map<Byte, ErasureCodingPolicy> SYSTEM_POLICIES_BY_ID = new TreeMap<Byte, ErasureCodingPolicy>();

    private SystemErasureCodingPolicies() {
    }

    public static List<ErasureCodingPolicy> getPolicies() {
        return SYS_POLICIES;
    }

    public static ErasureCodingPolicy getByID(byte id) {
        return SYSTEM_POLICIES_BY_ID.get(id);
    }

    public static ErasureCodingPolicy getByName(String name) {
        return SYSTEM_POLICIES_BY_NAME.get(name);
    }

    public static ErasureCodingPolicy getReplicationPolicy() {
        return REPLICATION_POLICY;
    }

    static {
        for (ErasureCodingPolicy policy : SYS_POLICIES) {
            SYSTEM_POLICIES_BY_NAME.put(policy.getName(), policy);
            SYSTEM_POLICIES_BY_ID.put(policy.getId(), policy);
        }
    }
}

