/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.io.erasurecode.ECSchema;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ErasureCodingPolicy
implements Serializable {
    private static final long serialVersionUID = 7994958L;
    private String name;
    private final ECSchema schema;
    private final int cellSize;
    private byte id;
    private ErasureCodingPolicyState state;

    public ErasureCodingPolicy(String name, ECSchema schema, int cellSize, byte id, ErasureCodingPolicyState state) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((cellSize > 0 ? 1 : 0) != 0, (Object)"cellSize must be positive");
        Preconditions.checkArgument((cellSize % 1024 == 0 ? 1 : 0) != 0, (Object)"cellSize must be 1024 aligned");
        this.name = name;
        this.schema = schema;
        this.cellSize = cellSize;
        this.id = id;
        this.state = state;
    }

    public ErasureCodingPolicy(String name, ECSchema schema, int cellSize, byte id) {
        this(name, schema, cellSize, id, ErasureCodingPolicyState.DISABLED);
    }

    public ErasureCodingPolicy(ECSchema schema, int cellSize, byte id) {
        this(ErasureCodingPolicy.composePolicyName(schema, cellSize), schema, cellSize, id, ErasureCodingPolicyState.DISABLED);
    }

    public ErasureCodingPolicy(ECSchema schema, int cellSize) {
        this(ErasureCodingPolicy.composePolicyName(schema, cellSize), schema, cellSize, -1, ErasureCodingPolicyState.DISABLED);
    }

    public static String composePolicyName(ECSchema schema, int cellSize) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((cellSize > 0 ? 1 : 0) != 0, (Object)"cellSize must be positive");
        Preconditions.checkArgument((cellSize % 1024 == 0 ? 1 : 0) != 0, (Object)"cellSize must be 1024 aligned");
        return schema.getCodecName().toUpperCase() + "-" + schema.getNumDataUnits() + "-" + schema.getNumParityUnits() + "-" + cellSize / 1024 + "k";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ECSchema getSchema() {
        return this.schema;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getNumDataUnits() {
        return this.schema.getNumDataUnits();
    }

    public int getNumParityUnits() {
        return this.schema.getNumParityUnits();
    }

    public String getCodecName() {
        return this.schema.getCodecName();
    }

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public boolean isReplicationPolicy() {
        return this.id == 63;
    }

    public ErasureCodingPolicyState getState() {
        return this.state;
    }

    public void setState(ErasureCodingPolicyState state) {
        this.state = state;
    }

    public boolean isSystemPolicy() {
        return this.id < 64;
    }

    public boolean isEnabled() {
        return this.state == ErasureCodingPolicyState.ENABLED;
    }

    public boolean isDisabled() {
        return this.state == ErasureCodingPolicyState.DISABLED;
    }

    public boolean isRemoved() {
        return this.state == ErasureCodingPolicyState.REMOVED;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ErasureCodingPolicy rhs = (ErasureCodingPolicy)o;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.schema, (Object)rhs.schema).append(this.cellSize, rhs.cellSize).append(this.id, rhs.id).append((Object)this.state, (Object)rhs.state).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(303855623, 582626729).append((Object)this.name).append((Object)this.schema).append(this.cellSize).append(this.id).append((Object)this.state).toHashCode();
    }

    public String toString() {
        return "ErasureCodingPolicy=[Name=" + this.name + ", Schema=[" + this.schema.toString() + "], CellSize=" + this.cellSize + ", Id=" + this.id + ", State=" + this.state.toString() + "]";
    }
}

