/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@KerberosInfo(serverPrincipal="dfs.namenode.kerberos.principal")
@TokenInfo(value=DelegationTokenSelector.class)
public interface ClientProtocol {
    public static final long versionID = 69L;
    public static final int GET_STATS_CAPACITY_IDX = 0;
    public static final int GET_STATS_USED_IDX = 1;
    public static final int GET_STATS_REMAINING_IDX = 2;
    @Deprecated
    public static final int GET_STATS_UNDER_REPLICATED_IDX = 3;
    public static final int GET_STATS_LOW_REDUNDANCY_IDX = 3;
    public static final int GET_STATS_CORRUPT_BLOCKS_IDX = 4;
    public static final int GET_STATS_MISSING_BLOCKS_IDX = 5;
    public static final int GET_STATS_MISSING_REPL_ONE_BLOCKS_IDX = 6;
    public static final int GET_STATS_BYTES_IN_FUTURE_BLOCKS_IDX = 7;
    public static final int GET_STATS_PENDING_DELETION_BLOCKS_IDX = 8;
    public static final int STATS_ARRAY_LENGTH = 9;

    @Idempotent
    public LocatedBlocks getBlockLocations(String var1, long var2, long var4) throws IOException;

    @Idempotent
    public FsServerDefaults getServerDefaults() throws IOException;

    @AtMostOnce
    public HdfsFileStatus create(String var1, FsPermission var2, String var3, EnumSetWritable<CreateFlag> var4, boolean var5, short var6, long var7, CryptoProtocolVersion[] var9, String var10) throws IOException;

    @AtMostOnce
    public LastBlockWithStatus append(String var1, String var2, EnumSetWritable<CreateFlag> var3) throws IOException;

    @Idempotent
    public boolean setReplication(String var1, short var2) throws IOException;

    @Idempotent
    public BlockStoragePolicy[] getStoragePolicies() throws IOException;

    @Idempotent
    public void setStoragePolicy(String var1, String var2) throws IOException;

    @Idempotent
    public void unsetStoragePolicy(String var1) throws IOException;

    @Idempotent
    public BlockStoragePolicy getStoragePolicy(String var1) throws IOException;

    @Idempotent
    public void setPermission(String var1, FsPermission var2) throws IOException;

    @Idempotent
    public void setOwner(String var1, String var2, String var3) throws IOException;

    @Idempotent
    public void abandonBlock(ExtendedBlock var1, long var2, String var4, String var5) throws IOException;

    @Idempotent
    public LocatedBlock addBlock(String var1, String var2, ExtendedBlock var3, DatanodeInfo[] var4, long var5, String[] var7, EnumSet<AddBlockFlag> var8) throws IOException;

    @Idempotent
    public LocatedBlock getAdditionalDatanode(String var1, long var2, ExtendedBlock var4, DatanodeInfo[] var5, String[] var6, DatanodeInfo[] var7, int var8, String var9) throws IOException;

    @Idempotent
    public boolean complete(String var1, String var2, ExtendedBlock var3, long var4) throws IOException;

    @Idempotent
    public void reportBadBlocks(LocatedBlock[] var1) throws IOException;

    @AtMostOnce
    public boolean rename(String var1, String var2) throws IOException;

    @AtMostOnce
    public void concat(String var1, String[] var2) throws IOException;

    @AtMostOnce
    public void rename2(String var1, String var2, Options.Rename ... var3) throws IOException;

    @Idempotent
    public boolean truncate(String var1, long var2, String var4) throws IOException;

    @AtMostOnce
    public boolean delete(String var1, boolean var2) throws IOException;

    @Idempotent
    public boolean mkdirs(String var1, FsPermission var2, boolean var3) throws IOException;

    @Idempotent
    public DirectoryListing getListing(String var1, byte[] var2, boolean var3) throws IOException;

    @Idempotent
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException;

    @Idempotent
    public void renewLease(String var1) throws IOException;

    @Idempotent
    public boolean recoverLease(String var1, String var2) throws IOException;

    @Idempotent
    public long[] getStats() throws IOException;

    @Idempotent
    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException;

    @Idempotent
    public ECBlockGroupStats getECBlockGroupStats() throws IOException;

    @Idempotent
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType var1) throws IOException;

    @Idempotent
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType var1) throws IOException;

    @Idempotent
    public long getPreferredBlockSize(String var1) throws IOException;

    @Idempotent
    public boolean setSafeMode(HdfsConstants.SafeModeAction var1, boolean var2) throws IOException;

    @AtMostOnce
    public boolean saveNamespace(long var1, long var3) throws IOException;

    @Idempotent
    public long rollEdits() throws IOException;

    @Idempotent
    public boolean restoreFailedStorage(String var1) throws IOException;

    @Idempotent
    public void refreshNodes() throws IOException;

    @Idempotent
    public void finalizeUpgrade() throws IOException;

    @Idempotent
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction var1) throws IOException;

    @Idempotent
    public CorruptFileBlocks listCorruptFileBlocks(String var1, String var2) throws IOException;

    @Idempotent
    public void metaSave(String var1) throws IOException;

    @Idempotent
    public void setBalancerBandwidth(long var1) throws IOException;

    @Idempotent
    public HdfsFileStatus getFileInfo(String var1) throws IOException;

    @Idempotent
    public boolean isFileClosed(String var1) throws IOException;

    @Idempotent
    public HdfsFileStatus getFileLinkInfo(String var1) throws IOException;

    @Idempotent
    public ContentSummary getContentSummary(String var1) throws IOException;

    @Idempotent
    public void setQuota(String var1, long var2, long var4, StorageType var6) throws IOException;

    @Idempotent
    public void fsync(String var1, long var2, String var4, long var5) throws IOException;

    @Idempotent
    public void setTimes(String var1, long var2, long var4) throws IOException;

    @AtMostOnce
    public void createSymlink(String var1, String var2, FsPermission var3, boolean var4) throws IOException;

    @Idempotent
    public String getLinkTarget(String var1) throws IOException;

    @Idempotent
    public LocatedBlock updateBlockForPipeline(ExtendedBlock var1, String var2) throws IOException;

    @AtMostOnce
    public void updatePipeline(String var1, ExtendedBlock var2, ExtendedBlock var3, DatanodeID[] var4, String[] var5) throws IOException;

    @Idempotent
    public Token<DelegationTokenIdentifier> getDelegationToken(Text var1) throws IOException;

    @Idempotent
    public long renewDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;

    @Idempotent
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;

    @Idempotent
    public DataEncryptionKey getDataEncryptionKey() throws IOException;

    @AtMostOnce
    public String createSnapshot(String var1, String var2) throws IOException;

    @AtMostOnce
    public void deleteSnapshot(String var1, String var2) throws IOException;

    @AtMostOnce
    public void renameSnapshot(String var1, String var2, String var3) throws IOException;

    @Idempotent
    public void allowSnapshot(String var1) throws IOException;

    @Idempotent
    public void disallowSnapshot(String var1) throws IOException;

    @Idempotent
    public SnapshotDiffReport getSnapshotDiffReport(String var1, String var2, String var3) throws IOException;

    @AtMostOnce
    public long addCacheDirective(CacheDirectiveInfo var1, EnumSet<CacheFlag> var2) throws IOException;

    @AtMostOnce
    public void modifyCacheDirective(CacheDirectiveInfo var1, EnumSet<CacheFlag> var2) throws IOException;

    @AtMostOnce
    public void removeCacheDirective(long var1) throws IOException;

    @Idempotent
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long var1, CacheDirectiveInfo var3) throws IOException;

    @AtMostOnce
    public void addCachePool(CachePoolInfo var1) throws IOException;

    @AtMostOnce
    public void modifyCachePool(CachePoolInfo var1) throws IOException;

    @AtMostOnce
    public void removeCachePool(String var1) throws IOException;

    @Idempotent
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String var1) throws IOException;

    @Idempotent
    public void modifyAclEntries(String var1, List<AclEntry> var2) throws IOException;

    @Idempotent
    public void removeAclEntries(String var1, List<AclEntry> var2) throws IOException;

    @Idempotent
    public void removeDefaultAcl(String var1) throws IOException;

    @Idempotent
    public void removeAcl(String var1) throws IOException;

    @Idempotent
    public void setAcl(String var1, List<AclEntry> var2) throws IOException;

    @Idempotent
    public AclStatus getAclStatus(String var1) throws IOException;

    @AtMostOnce
    public void createEncryptionZone(String var1, String var2) throws IOException;

    @Idempotent
    public EncryptionZone getEZForPath(String var1) throws IOException;

    @Idempotent
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long var1) throws IOException;

    @AtMostOnce
    public void reencryptEncryptionZone(String var1, HdfsConstants.ReencryptAction var2) throws IOException;

    @Idempotent
    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long var1) throws IOException;

    @AtMostOnce
    public void setXAttr(String var1, XAttr var2, EnumSet<XAttrSetFlag> var3) throws IOException;

    @Idempotent
    public List<XAttr> getXAttrs(String var1, List<XAttr> var2) throws IOException;

    @Idempotent
    public List<XAttr> listXAttrs(String var1) throws IOException;

    @AtMostOnce
    public void removeXAttr(String var1, XAttr var2) throws IOException;

    @Idempotent
    public void checkAccess(String var1, FsAction var2) throws IOException;

    @Idempotent
    public long getCurrentEditLogTxid() throws IOException;

    @Idempotent
    public EventBatchList getEditsFromTxid(long var1) throws IOException;

    @AtMostOnce
    public void setErasureCodingPolicy(String var1, String var2) throws IOException;

    @AtMostOnce
    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] var1) throws IOException;

    @AtMostOnce
    public void removeErasureCodingPolicy(String var1) throws IOException;

    @AtMostOnce
    public void enableErasureCodingPolicy(String var1) throws IOException;

    @AtMostOnce
    public void disableErasureCodingPolicy(String var1) throws IOException;

    @Idempotent
    public ErasureCodingPolicy[] getErasureCodingPolicies() throws IOException;

    @Idempotent
    public Map<String, String> getErasureCodingCodecs() throws IOException;

    @Idempotent
    public ErasureCodingPolicy getErasureCodingPolicy(String var1) throws IOException;

    @AtMostOnce
    public void unsetErasureCodingPolicy(String var1) throws IOException;

    @Idempotent
    public QuotaUsage getQuotaUsage(String var1) throws IOException;

    @Idempotent
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long var1) throws IOException;
}

