/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestClusterTopology
extends Assert {
    @Test
    public void testCountNumNodes() throws Exception {
        NetworkTopology cluster = new NetworkTopology();
        cluster.add((Node)this.getNewNode("node1", "/d1/r1"));
        NodeElement node2 = this.getNewNode("node2", "/d1/r2");
        cluster.add((Node)node2);
        cluster.add((Node)this.getNewNode("node3", "/d1/r3"));
        NodeElement node3 = this.getNewNode("node4", "/d1/r4");
        cluster.add((Node)node3);
        ArrayList<NodeElement> excludedNodes = new ArrayList<NodeElement>();
        TestClusterTopology.assertEquals((String)"4 nodes should be available", (long)4L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        NodeElement deadNode = this.getNewNode("node5", "/d1/r2");
        excludedNodes.add(deadNode);
        TestClusterTopology.assertEquals((String)"4 nodes should be available with extra excluded Node", (long)4L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        excludedNodes.add(node3);
        TestClusterTopology.assertEquals((String)"excluded nodes with ROOT scope should be considered", (long)3L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        TestClusterTopology.assertEquals((String)"excluded nodes without ~ scope should be considered", (long)2L, (long)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes));
        TestClusterTopology.assertEquals((String)"excluded nodes with rack scope should be considered", (long)1L, (long)cluster.countNumOfAvailableNodes(deadNode.getNetworkLocation(), excludedNodes));
        excludedNodes.add(node2);
        TestClusterTopology.assertEquals((String)"excluded nodes with ~ scope should be considered", (long)2L, (long)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes));
        TestClusterTopology.assertEquals((String)"No nodes should be considered for non-exist scope", (long)0L, (long)cluster.countNumOfAvailableNodes("/non-exist", excludedNodes));
    }

    private NodeElement getNewNode(String name, String rackLocation) {
        NodeElement node = new NodeElement(name);
        node.setNetworkLocation(rackLocation);
        return node;
    }

    public static class NodeElement
    implements Node {
        private String location;
        private String name;
        private Node parent;
        private int level;

        public NodeElement(String name) {
            this.name = name;
        }

        public String getNetworkLocation() {
            return this.location;
        }

        public void setNetworkLocation(String location) {
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int i) {
            this.level = i;
        }
    }
}

