/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.system.main;

import java.util.Collections;

import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.repository.Artifact;

/**
 * @version $Revision: 487175 $ $Date: 2006-12-14 03:10:31 -0800 (Thu, 14 Dec 2006) $
 */
public class ClientCommandLine extends CommandLine {
    /**
     * Command line entry point called by executable jar
     * @param args command line args
     */
    public static void main(String[] args) {
        log.info("Client startup begun");
        if(args.length == 0) {
            System.out.println();
            System.out.println("ERROR: No arguments");
            showHelp();
            System.exit(1);
        } else if(args[0].equals("--help") || args[0].equals("-h") || args[0].equals("/?")) {
            showHelp();
            System.exit(0);
        }
        try {
            Artifact configuration = Artifact.create(args[0]);
            String[] clientArgs = new String[args.length -1];
            System.arraycopy(args, 1, clientArgs, 0, clientArgs.length);
            new ClientCommandLine(configuration, clientArgs);
        } catch (Exception e) {
            ExceptionUtil.trimStackTrace(e);
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    private static void showHelp() {
        System.out.println();
        System.out.println("syntax:   java -jar bin/client.jar config-name [app arg] [app arg] ...");
        System.out.println();
        System.out.println("The first argument should identify the Geronimo configuration that");
        System.out.println("contains the application client you want to run.");
        System.out.println();
        System.out.println("The rest of the arguments will be passed as arguments to the");
        System.out.println("application client when it is started.");
        System.out.println();
    }


    public ClientCommandLine(Artifact configuration, String[] args) throws Exception {
        Jsr77Naming naming = new Jsr77Naming();
        //this kinda sucks, but resource adapter modules deployed on the client insist on having a
        //J2EEApplication name component
        AbstractName baseName = naming.createRootName(configuration, configuration.toString(), "J2EEApplication");
        AbstractNameQuery baseNameQuery = new AbstractNameQuery(baseName);
        invokeMainGBean(Collections.singletonList(configuration), baseNameQuery, "main", args);
    }
}
