/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueListener;
import org.apache.felix.ipojo.extender.queue.debug.QueueEventProxy;

public class ReplayQueueEventProxy
implements QueueEventProxy,
QueueListener {
    private final List<QueueListener> m_listeners = new ArrayList<QueueListener>();
    private List<QueueEvent> m_events = new CopyOnWriteArrayList<QueueEvent>();

    public void addQueueListener(QueueListener listener) {
        this.m_listeners.add(listener);
        this.replay(listener);
    }

    public void removeQueueListener(QueueListener listener) {
        this.m_listeners.remove(listener);
    }

    public void enlisted(JobInfo info) {
        EnlistedQueueEvent event = new EnlistedQueueEvent(info);
        this.m_events.add(event);
        this.forward(event);
    }

    public void started(JobInfo info) {
        StartedQueueEvent event = new StartedQueueEvent(info);
        this.m_events.add(event);
        this.forward(event);
    }

    public void executed(JobInfo info, Object result) {
        ExecutedQueueEvent event = new ExecutedQueueEvent(info, result);
        this.m_events.add(event);
        this.forward(event);
    }

    public void failed(JobInfo info, Throwable throwable) {
        FailedQueueEvent event = new FailedQueueEvent(info, throwable);
        this.m_events.add(event);
        this.forward(event);
    }

    private void replay(QueueListener listener) {
        for (QueueEvent event : this.m_events) {
            event.replay(listener);
        }
    }

    private void forward(QueueEvent event) {
        for (QueueListener listener : this.m_listeners) {
            event.replay(listener);
        }
    }

    private class FailedQueueEvent
    implements QueueEvent {
        private final JobInfo m_info;
        private final Throwable m_throwable;

        public FailedQueueEvent(JobInfo info, Throwable throwable) {
            this.m_info = info;
            this.m_throwable = throwable;
        }

        public void replay(QueueListener listener) {
            listener.failed(this.m_info, this.m_throwable);
        }
    }

    private class ExecutedQueueEvent
    implements QueueEvent {
        private final JobInfo m_info;
        private final Object m_result;

        public ExecutedQueueEvent(JobInfo info, Object result) {
            this.m_info = info;
            this.m_result = result;
        }

        public void replay(QueueListener listener) {
            listener.executed(this.m_info, this.m_result);
        }
    }

    private class StartedQueueEvent
    implements QueueEvent {
        private final JobInfo m_info;

        public StartedQueueEvent(JobInfo info) {
            this.m_info = info;
        }

        public void replay(QueueListener listener) {
            listener.started(this.m_info);
        }
    }

    private class EnlistedQueueEvent
    implements QueueEvent {
        private final JobInfo m_info;

        public EnlistedQueueEvent(JobInfo info) {
            this.m_info = info;
        }

        public void replay(QueueListener listener) {
            listener.enlisted(this.m_info);
        }
    }

    private static interface QueueEvent {
        public void replay(QueueListener var1);
    }
}

