/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.declaration;

import org.apache.felix.ipojo.extender.TypeDeclaration;
import org.apache.felix.ipojo.extender.internal.declaration.AbstractDeclaration;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class DefaultTypeDeclaration
extends AbstractDeclaration
implements TypeDeclaration {
    private final Element m_componentMetadata;
    private final String m_componentName;
    private final String m_componentVersion;
    private final String m_extension;
    private boolean visible = true;

    public DefaultTypeDeclaration(BundleContext bundleContext, Element componentMetadata) {
        super(bundleContext, TypeDeclaration.class);
        this.m_componentMetadata = componentMetadata;
        this.visible = this.initVisible();
        this.m_componentName = this.initComponentName();
        this.m_componentVersion = this.initComponentVersion(bundleContext);
        this.m_extension = this.initExtension();
    }

    private String initExtension() {
        if (this.m_componentMetadata.getNameSpace() == null) {
            return this.m_componentMetadata.getName();
        }
        return this.m_componentMetadata.getNameSpace() + ":" + this.m_componentMetadata.getName();
    }

    private String initComponentVersion(BundleContext bundleContext) {
        String version = this.m_componentMetadata.getAttribute("version");
        if (version != null && "bundle".equalsIgnoreCase(version)) {
            return (String)bundleContext.getBundle().getHeaders().get("Bundle-Version");
        }
        return version;
    }

    private String initComponentName() {
        String name = this.m_componentMetadata.getAttribute("name");
        if (name == null) {
            name = this.m_componentMetadata.getAttribute("classname");
        }
        return name;
    }

    private boolean initVisible() {
        String publicAttribute = this.m_componentMetadata.getAttribute("public");
        return publicAttribute == null || !publicAttribute.equalsIgnoreCase("false");
    }

    public String getComponentName() {
        return this.m_componentName;
    }

    public String getComponentVersion() {
        return this.m_componentVersion;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public Element getComponentMetadata() {
        return this.m_componentMetadata;
    }

    public boolean isPublic() {
        return this.visible;
    }
}

