/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.persistentSearch;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControlDecoder;

public class PersistentSearchControl
extends AbstractControl {
    public static final String CONTROL_OID = "2.16.840.1.113730.3.4.3";
    private boolean changesOnly = true;
    private boolean returnECs = false;
    private int changeTypes = 15;
    public static final int CHANGE_TYPE_ADD = 1;
    public static final int CHANGE_TYPE_DELETE = 2;
    public static final int CHANGE_TYPE_MODIFY = 4;
    public static final int CHANGE_TYPE_MODDN = 8;
    public static final int CHANGE_TYPES_MIN = 1;
    public static final int CHANGE_TYPES_MAX = 15;
    private int psearchSeqLength;

    public PersistentSearchControl() {
        super(CONTROL_OID);
        this.decoder = new PersistentSearchControlDecoder();
    }

    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
    }

    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
    }

    public boolean isReturnECs() {
        return this.returnECs;
    }

    public void setChangeTypes(int changeTypes) {
        this.changeTypes = changeTypes;
    }

    public int getChangeTypes() {
        return this.changeTypes;
    }

    public int computeLength() {
        int changeTypesLength = 2 + Value.getNbBytes((int)this.changeTypes);
        int changesOnlyLength = 3;
        int returnRCsLength = 3;
        this.psearchSeqLength = changeTypesLength + changesOnlyLength + returnRCsLength;
        int valueLength = 1 + TLV.getNbBytes((int)this.psearchSeqLength) + this.psearchSeqLength;
        return super.computeLength(valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)"ERR_04023", (Object[])new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes((int)this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes((int)this.psearchSeqLength));
        Value.encode((ByteBuffer)buffer, (int)this.changeTypes);
        Value.encode((ByteBuffer)buffer, (boolean)this.changesOnly);
        Value.encode((ByteBuffer)buffer, (boolean)this.returnECs);
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes((int)this.psearchSeqLength));
                Value.encode((ByteBuffer)buffer, (int)this.changeTypes);
                Value.encode((ByteBuffer)buffer, (boolean)this.changesOnly);
                Value.encode((ByteBuffer)buffer, (boolean)this.returnECs);
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public boolean isNotificationEnabled(ChangeType changeType) {
        return (changeType.getValue() & this.changeTypes) > 0;
    }

    public void enableNotification(ChangeType changeType) {
        this.changeTypes |= changeType.getValue();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Persistant Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeTypes : '").append(this.changeTypes).append("'\n");
        sb.append("        changesOnly : '").append(this.changesOnly).append("'\n");
        sb.append("        returnECs   : '").append(this.returnECs).append("'\n");
        return sb.toString();
    }
}

