/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceEvaluator<ID>
implements Evaluator<PresenceNode, ServerEntry, ID> {
    private final PresenceNode node;
    private final Store<ServerEntry, ID> db;
    private final AttributeType type;
    private final SchemaManager schemaManager;
    private final Index<String, ServerEntry, ID> idx;

    public PresenceEvaluator(PresenceNode node, Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.type = schemaManager.lookupAttributeTypeRegistry(node.getAttribute());
        this.idx = db.hasUserIndexOn(node.getAttribute()) ? db.getPresenceIndex() : null;
    }

    public PresenceNode getExpression() {
        return this.node;
    }

    public AttributeType getAttributeType() {
        return this.type;
    }

    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward((Object)this.type.getOid(), indexEntry.getId());
        }
        ServerEntry entry = (ServerEntry)indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject((Object)entry);
        }
        return this.evaluateEntry(entry);
    }

    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.forward((Object)this.type.getOid(), id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        if (this.db.hasSystemIndexOn(this.node.getAttribute())) {
            return true;
        }
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            do {
                AttributeType descendant;
                if ((attr = (ServerAttribute)entry.get(descendant = (AttributeType)descendants.next())) == null) continue;
                return true;
            } while (descendants.hasNext());
        }
        return false;
    }
}

