/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.schema.comparators.StringComparator;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityEvaluator<T, ID>
implements Evaluator<EqualityNode<T>, ServerEntry, ID> {
    private final EqualityNode<T> node;
    private final Store<ServerEntry, ID> db;
    private final SchemaManager schemaManager;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final LdapComparator<?> comparator;
    private static final Comparator<byte[]> BINARY_COMPARATOR = new ByteArrayComparator(null);
    private static final Comparator<String> STRING_COMPARATOR = new StringComparator(null);
    private final Index<T, ServerEntry, ID> idx;

    public EqualityEvaluator(EqualityNode<T> node, Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        if (db.hasIndexOn(node.getAttribute())) {
            this.idx = db.getIndex(node.getAttribute());
            this.type = null;
            this.normalizer = null;
            this.comparator = null;
        } else {
            this.idx = null;
            this.type = schemaManager.lookupAttributeTypeRegistry(node.getAttribute());
            MatchingRule mr = this.type.getEquality();
            if (mr == null) {
                this.normalizer = new NoOpNormalizer(this.type.getOid());
                this.comparator = null;
            } else {
                this.normalizer = mr.getNormalizer();
                this.comparator = mr.getLdapComparator();
            }
        }
    }

    public EqualityNode<T> getExpression() {
        return this.node;
    }

    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.node.getValue().get(), indexEntry.getId());
        }
        ServerEntry entry = (ServerEntry)indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject((Object)entry);
        }
        return this.evaluateEntry(entry);
    }

    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverse(id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    private boolean evaluate(ServerAttribute attribute) throws Exception {
        for (Value value : attribute) {
            Object nodeValue;
            Object serverValue;
            value.normalize(this.normalizer);
            if (value.isBinary()) {
                serverValue = (byte[])value.getNormalizedValue();
                nodeValue = (byte[])this.node.getValue().getNormalizedValue();
                if (!(this.comparator != null ? this.comparator.compare(serverValue, nodeValue) == 0 : BINARY_COMPARATOR.compare((byte[])serverValue, (byte[])nodeValue) == 0)) continue;
                return true;
            }
            serverValue = (String)value.getNormalizedValue();
            nodeValue = null;
            nodeValue = this.node.getValue().isBinary() ? (Object)StringTools.utf8ToString((byte[])((byte[])this.node.getValue().getNormalizedValue())) : (Object)((String)this.node.getValue().getNormalizedValue());
            if (!(this.comparator != null ? this.comparator.compare(serverValue, nodeValue) == 0 : STRING_COMPARATOR.compare((String)serverValue, (String)nodeValue) == 0)) continue;
            return true;
        }
        return false;
    }
}

