/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.util.HashSet;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStore;
import org.apache.directory.server.xdbm.AbstractXdbmPartition;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmPartition
extends AbstractXdbmPartition<Long> {
    public JdbmPartition() {
        super((Store)new JdbmStore());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void initialize() throws Exception {
        this.store.setWorkingDirectory(this.getPartitionDir());
        EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.store, this.schemaManager);
        CursorBuilder cursorBuilder = new CursorBuilder(this.store, evaluatorBuilder);
        this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer(this.store);
        this.searchEngine = new DefaultSearchEngine(this.store, cursorBuilder, evaluatorBuilder, this.optimizer);
        this.store.setCacheSize(this.cacheSize);
        this.store.setName(this.id);
        this.suffix.normalize(this.schemaManager.getNormalizerMapping());
        this.store.setSuffixDn(this.suffix.getNormName());
        this.store.setWorkingDirectory(this.getPartitionDir());
        HashSet<JdbmIndex> userIndices = new HashSet<JdbmIndex>();
        for (Index obj : this.getIndexedAttributes()) {
            JdbmIndex index;
            if (obj instanceof JdbmIndex) {
                index = (JdbmIndex)obj;
            } else {
                index = new JdbmIndex();
                index.setAttributeId(obj.getAttributeId());
                index.setCacheSize(obj.getCacheSize());
                index.setWkDirPath(obj.getWkDirPath());
            }
            String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
            if (SYS_INDEX_OIDS.contains(oid)) {
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                    this.store.setAliasIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                    this.store.setPresenceIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                    this.store.setOneLevelIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                    this.store.setNdnIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                    this.store.setOneAliasIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                    this.store.setSubAliasIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                    this.store.setUpdnIndex((Index)index);
                } else if (oid.equals("2.5.4.0")) {
                    this.store.setObjectClassIndex((Index)index);
                } else if (oid.equals("1.3.6.1.4.1.4203.666.1.7")) {
                    this.store.setEntryCsnIndex((Index)index);
                } else {
                    if (!oid.equals("1.3.6.1.1.16.4")) throw new IllegalStateException("Unrecognized system index " + oid);
                    this.store.setEntryUuidIndex((Index)index);
                }
            } else {
                userIndices.add(index);
            }
            this.store.setUserIndices(userIndices);
        }
        this.store.init(this.schemaManager);
    }

    public Index<String, ServerEntry, Long> getObjectClassIndex() {
        return this.store.getObjectClassIndex();
    }

    public Index<String, ServerEntry, Long> getEntryCsnIndex() {
        return this.store.getEntryCsnIndex();
    }

    public Index<String, ServerEntry, Long> getEntryUuidIndex() {
        return this.store.getEntryUuidIndex();
    }
}

