/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class StringUtil {
    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String trimAndNullify(String string) {
        if (string != null && (string = string.trim()).equals("")) {
            string = null;
        }
        return string;
    }

    public static String trimSpaceInString(String oldName) {
        if (oldName == null) {
            return "";
        }
        return oldName.replace(" ", "");
    }

    public static String convertToJavaIdentifier(String name) {
        int REPLACE_CHAR = 95;
        if (name == null || name.length() == 0) {
            return "_";
        }
        StringBuilder buf = new StringBuilder();
        char c = name.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            buf.append('_');
        }
        for (int i = 0; i < name.length(); ++i) {
            c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public static String incrementName(String oldName) {
        String newName;
        int PREFIX = 95;
        if (oldName == null || oldName.length() == 0) {
            newName = "noName";
        } else {
            int lastDashIndex = oldName.lastIndexOf(95);
            if (lastDashIndex < 0) {
                newName = oldName + '_' + 2;
            } else {
                String suffix = oldName.substring(lastDashIndex + 1);
                try {
                    int number = Integer.parseInt(suffix);
                    int newNumber = number + 1;
                    newName = oldName.substring(0, lastDashIndex + 1) + newNumber;
                }
                catch (RuntimeException e) {
                    newName = oldName + '_' + 2;
                }
            }
        }
        return newName;
    }

    public static String getClassName(Class klass) {
        String fullName = klass.getName();
        int index = fullName.lastIndexOf(".");
        if (index < 0) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static String getStackTraceInString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }
}

