/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.jboss.logging.Logger;

public class Reclaimer {
    private static final Logger logger = Logger.getLogger(Reclaimer.class);

    public void scan(JournalFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            JournalFile currentFile = files[i];
            currentFile.setCanReclaim(true);
            for (int j = i - 1; j >= 0; --j) {
                JournalFile file = files[j];
                if (currentFile.getNegCount(file) == 0 || file.isCanReclaim()) continue;
                logger.tracef("%s can't be reclaimed because %s has negative values", (Object)currentFile, (Object)file);
                currentFile.setCanReclaim(false);
                break;
            }
            if (!currentFile.isCanReclaim()) continue;
            int negCount = 0;
            int posCount = currentFile.getPosCount();
            logger.tracef("posCount on %s = %d", (Object)currentFile, (Object)posCount);
            for (int j = i; j < files.length && negCount < posCount; ++j) {
                int toNeg = files[j].getNegCount(currentFile);
                negCount += toNeg;
                if (!logger.isTraceEnabled() || toNeg == 0) continue;
                logger.tracef("Negative from %s into %s = %d", (Object)files[j], (Object)currentFile, (Object)toNeg);
            }
            if (negCount < posCount) {
                logger.tracef("%s can't be reclaimed because there are not enough negatives %d", (Object)currentFile, (Object)negCount);
                currentFile.setCanReclaim(false);
                continue;
            }
            logger.tracef("%s can be reclaimed", (Object)currentFile);
        }
    }
}

