/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.threadhistory;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.moskito.core.util.threadhistory.ThreadHistoryEvent;

public enum ThreadHistoryUtility {
    INSTANCE;

    private volatile boolean isActive;
    private Timer timer;
    private volatile long updateInterval = 60000L;
    private Set<Long> runningThreadIds = new HashSet<Long>();
    private final ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
    private volatile int maxEventsSize = 1000;
    private List<ThreadHistoryEvent> eventList = new ArrayList<ThreadHistoryEvent>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Long[] PATTERN;

    public boolean isActive() {
        return this.isActive;
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.timer = new Timer("MoskitoThreadHistoryUpdater", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ThreadHistoryUtility.this.update();
            }
        }, 0L, this.updateInterval);
        this.isActive = true;
    }

    public void deactivate() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.lock.writeLock().lock();
        try {
            long[] ids = this.mxBean.getAllThreadIds();
            HashSet<Long> oldIds = new HashSet<Long>(this.runningThreadIds);
            for (long _id : ids) {
                Long id = _id;
                oldIds.remove(id);
                if (this.runningThreadIds.contains(id)) continue;
                ThreadHistoryEvent event = ThreadHistoryEvent.created(_id, this.mxBean.getThreadInfo(_id).getThreadName());
                this.runningThreadIds.add(id);
                this.eventList.add(event);
            }
            for (Long oldId : oldIds.toArray(new Long[oldIds.size()])) {
                ThreadHistoryEvent event = ThreadHistoryEvent.deleted(oldId, "");
                this.runningThreadIds.remove(oldId);
                this.eventList.add(event);
            }
            if (this.eventList.size() > this.maxEventsSize) {
                List<ThreadHistoryEvent> list = this.eventList;
                this.eventList = new ArrayList<ThreadHistoryEvent>(this.maxEventsSize);
                this.eventList.addAll(this.maxEventsSize / 10, list);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<ThreadHistoryEvent> getThreadHistoryEvents() {
        ArrayList<ThreadHistoryEvent> ret = null;
        this.lock.readLock().lock();
        try {
            ret = new ArrayList<ThreadHistoryEvent>(this.eventList);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return ret;
    }

    void setUpdateInterval(long aValue) {
        this.updateInterval = aValue;
    }

    public int getMaxEventsSize() {
        return this.maxEventsSize;
    }

    public void setMaxEventsSize(int maxEventsSize) {
        this.maxEventsSize = maxEventsSize;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    static {
        PATTERN = new Long[0];
    }
}

