/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import net.anotheria.moskito.core.predefined.OSStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInOSProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private OSStats stats;
    private List<IStats> statsList;
    private OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final String clazzname = "com.sun.management.UnixOperatingSystemMXBean";
    private Class<?> clazz;
    private final boolean isUnixOS;
    private static Logger log = LoggerFactory.getLogger(BuiltInOSProducer.class);

    public BuiltInOSProducer() {
        this.statsList = new ArrayList<IStats>(1);
        this.stats = new OSStats();
        this.statsList.add(this.stats);
        try {
            this.clazz = Class.forName(clazzname);
        }
        catch (ClassNotFoundException e) {
            log.warn("Couldn't find unix version of os class: com.sun.management.UnixOperatingSystemMXBean, osstats won't operate properly - " + e.getMessage());
        }
        char version = System.getProperty("java.version").charAt(2);
        this.isUnixOS = version > '7' ? this.mxBean.getClass().getName().equals("sun.management.OperatingSystemImpl") : this.mxBean.getClass().getName().equals("com.sun.management.UnixOperatingSystem");
        if (!this.isUnixOS) {
            log.warn("Couldn't find unix version of os class: com.sun.management.UnixOperatingSystemMXBean, osstats won't operate properly. Current type is: " + this.mxBean.getClass().getName());
        }
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInOSProducer.this.readMbean();
            }
        });
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
    }

    @Override
    public String getCategory() {
        return "os";
    }

    @Override
    public String getProducerId() {
        return "OS";
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    private void readMbean() {
        if (this.clazz == null) {
            return;
        }
        try {
            if (this.isUnixOS) {
                long openFiles = this.getValue("OpenFileDescriptorCount");
                long maxOpenFiles = this.getValue("MaxFileDescriptorCount");
                long freePhysicalMemorySize = this.getValue("FreePhysicalMemorySize");
                long totalPhysicalMemorySize = this.getValue("TotalPhysicalMemorySize");
                long processTime = this.getValue("ProcessCpuTime");
                double processCPULoad = this.getDoubleValue("ProcessCpuLoad");
                double systemCPULoad = this.getDoubleValue("SystemCpuLoad");
                long processors = this.getValue("AvailableProcessors");
                this.stats.update((int)openFiles, (int)maxOpenFiles, freePhysicalMemorySize, totalPhysicalMemorySize, processTime, (int)processors, processCPULoad, systemCPULoad);
            } else {
                long processors = this.getValue("AvailableProcessors");
                this.stats.update(-1, -1, -1L, -1L, -1L, (int)processors, -1.0, -1.0);
            }
        }
        catch (Exception e) {
            log.warn("Couldn't read value due to", (Throwable)e);
        }
    }

    private long getValue(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = this.clazz.getMethod("get" + name, new Class[0]);
        if (name.equals("AvailableProcessors")) {
            return ((Integer)m.invoke((Object)this.mxBean, new Object[0])).intValue();
        }
        Long result = (Long)m.invoke((Object)this.mxBean, new Object[0]);
        return result;
    }

    private double getDoubleValue(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = this.clazz.getMethod("get" + name, new Class[0]);
        Double result = (Double)m.invoke((Object)this.mxBean, new Object[0]);
        return result;
    }

    public static void main(String[] a) {
        new BuiltInOSProducer();
    }
}

