/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold.guard;

public enum GuardedDirection {
    DOWN{

        @Override
        protected int getExpectedCompareResult() {
            return -1;
        }
    }
    ,
    UP{

        @Override
        protected int getExpectedCompareResult() {
            return 1;
        }
    };


    abstract int getExpectedCompareResult();

    public boolean brokeThrough(Number value, Number limit) {
        int compareResult = 0;
        if (value instanceof Double) {
            compareResult = ((Double)value).compareTo((Double)limit);
        }
        if (value instanceof Long) {
            compareResult = ((Long)value).compareTo((Long)limit);
        }
        if (compareResult > 1) {
            compareResult = 1;
        }
        if (compareResult < -1) {
            compareResult = -1;
        }
        return this.getExpectedCompareResult() == compareResult || compareResult == 0 && this.getExpectedCompareResult() == 1;
    }
}

