/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold;

import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdConditionGuard;
import net.anotheria.moskito.core.threshold.ThresholdDefinition;
import net.anotheria.moskito.core.threshold.ThresholdRepository;

public final class Thresholds {
    private Thresholds() {
    }

    public static void addThreshold(String name, String producerName, String statName, String valueName, String intervalName, ThresholdConditionGuard ... guards) {
        ThresholdDefinition definition = new ThresholdDefinition();
        definition.setName(name);
        definition.setProducerName(producerName);
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(intervalName);
        Threshold threshold = ThresholdRepository.getInstance().createThreshold(definition);
        if (guards != null) {
            for (ThresholdConditionGuard g : guards) {
                threshold.addGuard(g);
            }
        }
    }

    public static void addServiceAVGThreshold(String name, String producerName, ThresholdConditionGuard ... guards) {
        Thresholds.addServiceAVGThreshold(name, producerName, "5m", guards);
    }

    public static void addServiceAVGThreshold(String name, String producerName, String interval, ThresholdConditionGuard ... guards) {
        Thresholds.addThreshold(name, producerName, "cumulated", "AVG", interval, guards);
    }

    public static void addServiceREQThreshold(String name, String producerName, ThresholdConditionGuard ... guards) {
        Thresholds.addServiceREQThreshold(name, producerName, "5m", guards);
    }

    public static void addServiceREQThreshold(String name, String producerName, String interval, ThresholdConditionGuard ... guards) {
        Thresholds.addThreshold(name, producerName, "cumulated", "REQ", interval, guards);
    }

    public static void addUrlAVGThreshold(String name, String url, ThresholdConditionGuard ... guards) {
        Thresholds.addUrlAVGThreshold(name, url, "5m", guards);
    }

    public static void addUrlAVGThreshold(String name, String url, String interval, ThresholdConditionGuard ... guards) {
        Thresholds.addThreshold(name, "RequestURIFilter", url, "AVG", interval, guards);
    }

    public static void addMemoryThreshold(String name, String producerName, String valueName, ThresholdConditionGuard ... guards) {
        Thresholds.addMemoryThreshold(name, producerName, valueName, "1m", guards);
    }

    public static void addMemoryThreshold(String name, String producerName, String valueName, String intervalName, ThresholdConditionGuard ... guards) {
        Thresholds.addThreshold(name, producerName, producerName, valueName, intervalName, guards);
    }
}

