/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.IValueHolderFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.UnknownIntervalException;
import net.anotheria.moskito.core.stats.ValueHolder;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;

class StatValueImpl
implements StatValue {
    private static final Interval ABSOLUTE_VALUE = IntervalRegistry.getInstance().getInterval("default", 0);
    protected ValueHolder absoluteValue;
    protected Map<String, ValueHolder> values;
    private List<ValueHolder> valuesAsList;
    private String name;
    private transient IValueHolderFactory factory;

    public StatValueImpl(String aName, IValueHolderFactory aFactory) {
        this.name = aName;
        this.factory = aFactory;
        this.values = new HashMap<String, ValueHolder>();
        this.valuesAsList = new ArrayList<ValueHolder>();
        this.absoluteValue = this.factory.createValueHolder(ABSOLUTE_VALUE);
        this.values.put(ABSOLUTE_VALUE.getName(), this.absoluteValue);
        this.valuesAsList.add(this.absoluteValue);
    }

    @Override
    public void addInterval(Interval aInterval) {
        ValueHolder h = this.factory.createValueHolder(aInterval);
        this.values.put(aInterval.getName(), h);
        this.valuesAsList.add(h);
    }

    public String toString() {
        return this.name + ": " + this.valuesAsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void increase() {
        for (ValueHolder holder : this.valuesAsList) {
            holder.increase();
        }
    }

    @Override
    public void decrease() {
        for (ValueHolder holder : this.valuesAsList) {
            holder.decrease();
        }
    }

    private ValueHolder getHolderByIntervalName(String aIntervalName) {
        ValueHolder h = this.values.get(aIntervalName);
        if (h == null) {
            throw new UnknownIntervalException(aIntervalName);
        }
        return h;
    }

    @Override
    public int getValueAsInt() {
        return this.getValueAsInt(null);
    }

    @Override
    public long getValueAsLong() {
        return this.getValueAsLong(null);
    }

    @Override
    public double getValueAsDouble() {
        return this.getValueAsDouble(null);
    }

    @Override
    public int getValueAsInt(String aIntervalName) {
        if (aIntervalName == null || aIntervalName.equals(ABSOLUTE_VALUE.getName())) {
            return this.absoluteValue.getCurrentValueAsInt();
        }
        return this.getHolderByIntervalName(aIntervalName).getValueAsInt();
    }

    @Override
    public long getValueAsLong(String aIntervalName) {
        if (aIntervalName == null || aIntervalName.equals(ABSOLUTE_VALUE.getName())) {
            return this.absoluteValue.getCurrentValueAsLong();
        }
        return this.getHolderByIntervalName(aIntervalName).getValueAsLong();
    }

    @Override
    public double getValueAsDouble(String aIntervalName) {
        if (aIntervalName == null || aIntervalName.equals(ABSOLUTE_VALUE.getName())) {
            return this.absoluteValue.getCurrentValueAsDouble();
        }
        return this.getHolderByIntervalName(aIntervalName).getValueAsDouble();
    }

    @Override
    public void setValueAsInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setValueAsInt(aValue);
        }
    }

    @Override
    public void setValueAsString(String aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setValueAsString(aValue);
        }
    }

    @Override
    public void setValueAsLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setValueAsLong(aValue);
        }
    }

    @Override
    public void setValueAsDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setValueAsDouble(aValue);
        }
    }

    @Override
    public void increaseByInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.increaseByInt(aValue);
        }
    }

    @Override
    public void increaseByLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.increaseByLong(aValue);
        }
    }

    @Override
    public void increaseByDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.increaseByDouble(aValue);
        }
    }

    @Override
    public void decreaseByInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.decreaseByInt(aValue);
        }
    }

    @Override
    public void decreaseByLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.decreaseByLong(aValue);
        }
    }

    @Override
    public void decreaseByDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.decreaseByDouble(aValue);
        }
    }

    @Override
    public void setDefaultValueAsLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setDefaultValueAsLong(aValue);
        }
    }

    @Override
    public void setDefaultValueAsInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setDefaultValueAsInt(aValue);
        }
    }

    @Override
    public void setDefaultValueAsDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            holder.setDefaultValueAsDouble(aValue);
        }
    }

    @Override
    public void reset() {
        for (ValueHolder holder : this.valuesAsList) {
            holder.reset();
        }
    }

    @Override
    public void setValueIfGreaterThanCurrentAsLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (holder.getCurrentValueAsLong() >= aValue) continue;
            holder.setValueAsLong(aValue);
        }
    }

    @Override
    public void setValueIfGreaterThanCurrentAsInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (holder.getCurrentValueAsInt() >= aValue) continue;
            holder.setValueAsInt(aValue);
        }
    }

    @Override
    public void setValueIfGreaterThanCurrentAsDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (!(holder.getCurrentValueAsDouble() < aValue)) continue;
            holder.setValueAsDouble(aValue);
        }
    }

    @Override
    public void setValueIfLesserThanCurrentAsLong(long aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (holder.getCurrentValueAsLong() <= aValue) continue;
            holder.setValueAsLong(aValue);
        }
    }

    @Override
    public void setValueIfLesserThanCurrentAsInt(int aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (holder.getCurrentValueAsInt() <= aValue) continue;
            holder.setValueAsInt(aValue);
        }
    }

    @Override
    public void setValueIfLesserThanCurrentAsDouble(double aValue) {
        for (ValueHolder holder : this.valuesAsList) {
            if (!(holder.getCurrentValueAsDouble() > aValue)) continue;
            holder.setValueAsDouble(aValue);
        }
    }

    @Override
    public String getValueAsString(String intervalName) {
        if (intervalName == null || intervalName.equals(ABSOLUTE_VALUE.getName())) {
            return this.absoluteValue.getCurrentValueAsString();
        }
        return this.getHolderByIntervalName(intervalName).getValueAsString();
    }

    @Override
    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    @Override
    public void destroy() {
        IntervalRegistry reg = IntervalRegistry.getInstance();
        for (Map.Entry<String, ValueHolder> entry : this.values.entrySet()) {
            if (!(entry.getValue() instanceof IIntervalListener)) continue;
            reg.getInterval(entry.getKey()).removePrimaryIntervalListener((IIntervalListener)((Object)entry.getValue()));
        }
    }
}

