/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.Collection;
import net.anotheria.moskito.core.stats.DetailedStatValue;
import net.anotheria.moskito.core.stats.IValueHolderFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;
import net.anotheria.moskito.core.stats.impl.DetailedTypeAwareStatValueImpl;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import net.anotheria.moskito.core.stats.impl.StatValueTypeUtility;
import net.anotheria.moskito.core.stats.impl.TypeAwareStatValueImpl;

public class StatValueFactory {
    public static final StatValue createStatValue(Object aPattern, String aName, Interval[] aIntervals) {
        return StatValueFactory.createStatValue(StatValueTypeUtility.object2type(aPattern), aName, aIntervals);
    }

    public static TypeAwareStatValue createStatValue(StatValueTypes aType, String aName, Interval[] aIntervals) {
        IValueHolderFactory valueHolderFactory = StatValueTypeUtility.createValueHolderFactory(aType);
        TypeAwareStatValueImpl value = new TypeAwareStatValueImpl(aName, aType, valueHolderFactory);
        for (int i = 0; i < aIntervals.length; ++i) {
            value.addInterval(aIntervals[i]);
        }
        return value;
    }

    public static TypeAwareStatValue createStatValue(StatValueTypes aType, String aName, Collection<String> aIntervals) {
        Interval[] arrayIntervals = new Interval[aIntervals.size()];
        int i = 0;
        for (String interval : aIntervals) {
            arrayIntervals[i++] = IntervalRegistry.getInstance().getInterval(interval);
        }
        return StatValueFactory.createStatValue(aType, aName, arrayIntervals);
    }

    public static final DetailedStatValue createDetailedStatValue(Object aPattern, String aName, Interval[] aIntervals) {
        return StatValueFactory.createDetailedStatValue(StatValueTypeUtility.object2type(aPattern), aName, aIntervals);
    }

    public static DetailedStatValue createDetailedStatValue(StatValueTypes aType, String aName, Interval[] aIntervals) {
        IValueHolderFactory valueHolderFactory = StatValueTypeUtility.createValueHolderFactory(aType);
        DetailedTypeAwareStatValueImpl value = new DetailedTypeAwareStatValueImpl(aName, aType, valueHolderFactory);
        for (Interval aInterval : aIntervals) {
            value.addInterval(aInterval);
        }
        value.reset();
        return value;
    }
}

