/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.producers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;

public class GenericStats
extends AbstractStats {
    private final Map<String, TypeAwareStatValue> values = new LinkedHashMap<String, TypeAwareStatValue>();

    public GenericStats(String aName) {
        super(aName);
    }

    public Collection<TypeAwareStatValue> getAllValues() {
        return Collections.unmodifiableCollection(this.values.values());
    }

    @Override
    public List<String> getAvailableValueNames() {
        return new ArrayList<String>(this.values.keySet());
    }

    public TypeAwareStatValue getValueByName(String valueName) {
        if (valueName == null) {
            throw new AssertionError((Object)"value name must not be null!");
        }
        return this.values.get(valueName.toLowerCase());
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        TypeAwareStatValue value = this.getValueByName(valueName);
        if (value == null) {
            return null;
        }
        return value.getValueAsString(intervalName);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public void putValue(TypeAwareStatValue value) {
        String name = value.getName();
        this.values.put(name.toLowerCase(), value);
    }

    @Override
    public String toStatsString(String aIntervalName, TimeUnit unit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        for (Map.Entry<String, TypeAwareStatValue> entry : this.values.entrySet()) {
            String key = entry.getKey();
            StatValue value = entry.getValue();
            b.append(key).append(value.getValueAsString(aIntervalName));
        }
        return b.toString();
    }
}

